/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.AbstractValue;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttribute
implements Attribute,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAttribute.class);
    private AttributeType attributeType;
    private Set<Value<?>> values = new LinkedHashSet();
    private String upId;
    private String id;
    private Boolean isHR;
    private volatile int h;

    DefaultAttribute() {
    }

    DefaultAttribute(AttributeType attributeType, String upId, String normId, boolean isHR, int hashCode, Value<?> ... values) {
        this.attributeType = attributeType;
        this.upId = upId;
        this.id = normId;
        this.isHR = isHR;
        this.h = hashCode;
        if (values != null) {
            for (Value<?> value : values) {
                this.values.add(value);
            }
        }
    }

    public DefaultAttribute(AttributeType attributeType) {
        if (attributeType != null) {
            try {
                this.apply(attributeType);
            }
            catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {
                // empty catch block
            }
        }
    }

    public DefaultAttribute(String upId) {
        this.setUpId(upId);
    }

    public DefaultAttribute(byte[] upId) {
        this.setUpId(upId);
    }

    public DefaultAttribute(String upId, AttributeType attributeType) {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        try {
            this.apply(attributeType);
        }
        catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {
            // empty catch block
        }
        this.setUpId(upId, attributeType);
    }

    public DefaultAttribute(String upId, Value<?> ... vals) {
        if (vals[0] == null) {
            this.add(new StringValue((String)null));
        } else {
            for (Value<?> val : vals) {
                if (!(val instanceof StringValue) && val.isHumanReadable()) {
                    String message = I18n.err(I18n.ERR_04129, val.getClass().getName());
                    LOG.error(message);
                    throw new IllegalStateException(message);
                }
                this.add(val);
            }
        }
        this.setUpId(upId);
    }

    public DefaultAttribute(AttributeType attributeType, String ... vals) throws LdapInvalidAttributeValueException {
        this(null, attributeType, vals);
    }

    public DefaultAttribute(String upId, AttributeType attributeType, String ... vals) throws LdapInvalidAttributeValueException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.apply(attributeType);
        if (vals != null && vals.length > 0) {
            this.add(vals);
        }
        this.setUpId(upId, attributeType);
    }

    public DefaultAttribute(String upId, AttributeType attributeType, Value<?> ... vals) throws LdapInvalidAttributeValueException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.apply(attributeType);
        this.setUpId(upId, attributeType);
        this.add(vals);
    }

    public DefaultAttribute(AttributeType attributeType, Value<?> ... vals) throws LdapInvalidAttributeValueException {
        this(null, attributeType, vals);
    }

    public DefaultAttribute(String upId, String ... vals) {
        try {
            this.add(vals);
        }
        catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {
            // empty catch block
        }
        this.setUpId(upId);
    }

    public DefaultAttribute(String upId, byte[] ... vals) {
        try {
            this.add(vals);
        }
        catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {
            // empty catch block
        }
        this.setUpId(upId);
    }

    public DefaultAttribute(AttributeType attributeType, byte[] ... vals) throws LdapInvalidAttributeValueException {
        this(null, attributeType, vals);
    }

    public DefaultAttribute(String upId, AttributeType attributeType, byte[] ... vals) throws LdapInvalidAttributeValueException {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]));
        }
        this.apply(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    public DefaultAttribute(AttributeType attributeType, Attribute attribute) throws LdapException {
        this.attributeType = attributeType;
        this.id = attribute.getId();
        this.upId = attribute.getUpId();
        if (attributeType == null) {
            this.isHR = attribute.isHumanReadable();
            for (Value value : attribute) {
                this.add(value.clone());
            }
            if (attribute.getAttributeType() != null) {
                this.apply(attribute.getAttributeType());
            }
        } else {
            this.isHR = attributeType.getSyntax().isHumanReadable();
            for (Value clientValue : attribute) {
                AbstractValue serverValue = null;
                if (clientValue instanceof StringValue) {
                    serverValue = this.isHR.booleanValue() ? new StringValue(attributeType, clientValue.getString()) : new BinaryValue(attributeType, clientValue.getBytes());
                } else if (clientValue instanceof BinaryValue) {
                    serverValue = this.isHR != false ? new StringValue(attributeType, clientValue.getString()) : new BinaryValue(attributeType, clientValue.getBytes());
                }
                this.add(serverValue);
            }
        }
    }

    private Value<String> createStringValue(AttributeType attributeType, String value) {
        StringValue stringValue;
        if (attributeType != null) {
            try {
                stringValue = new StringValue(attributeType, value);
            }
            catch (LdapInvalidAttributeValueException iae) {
                return null;
            }
        } else {
            stringValue = new StringValue(value);
        }
        return stringValue;
    }

    private Value<byte[]> createBinaryValue(AttributeType attributeType, byte[] value) throws LdapInvalidAttributeValueException {
        BinaryValue binaryValue = attributeType != null ? new BinaryValue(attributeType, value) : new BinaryValue(value);
        return binaryValue;
    }

    @Override
    public byte[] getBytes() throws LdapInvalidAttributeValueException {
        Value<?> value = this.get();
        if (!this.isHR.booleanValue() && value != null) {
            return value.getBytes();
        }
        String message = I18n.err(I18n.ERR_04130, new Object[0]);
        LOG.error(message);
        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    @Override
    public String getString() throws LdapInvalidAttributeValueException {
        Value<?> value = this.get();
        if (this.isHR.booleanValue() && value != null) {
            return value.getString();
        }
        String message = I18n.err(I18n.ERR_04131, new Object[0]);
        LOG.error(message);
        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUpId() {
        return this.upId;
    }

    @Override
    public void setUpId(String upId) {
        this.setUpId(upId, this.attributeType);
    }

    public void setUpId(byte[] upId) {
        this.setUpId(upId, this.attributeType);
    }

    private boolean areCompatible(String id, AttributeType attributeType) {
        int optPos = id.indexOf(59);
        String idNoOption = id;
        if (optPos != -1) {
            idNoOption = id.substring(0, optPos);
        }
        for (String name : attributeType.getNames()) {
            if (!name.equalsIgnoreCase(idNoOption)) continue;
            return true;
        }
        return Oid.isOid(id) && attributeType.getOid().equals(id);
    }

    @Override
    public void setUpId(String upId, AttributeType attributeType) {
        String trimmed = Strings.trim(upId);
        if (Strings.isEmpty(trimmed) && attributeType == null) {
            throw new IllegalArgumentException("Cannot set a null ID with a null AttributeType");
        }
        String newId = Strings.toLowerCaseAscii(trimmed);
        this.setUpIdInternal(upId, newId, attributeType);
    }

    public void setUpId(byte[] upId, AttributeType attributeType) {
        byte[] trimmed = Strings.trim(upId);
        if (Strings.isEmpty(trimmed) && attributeType == null) {
            throw new IllegalArgumentException("Cannot set a null ID with a null AttributeType");
        }
        String newId = Strings.toLowerCase(trimmed);
        this.setUpIdInternal(Strings.utf8ToString(upId), newId, attributeType);
    }

    private void setUpIdInternal(String upId, String newId, AttributeType attributeType) {
        if (attributeType == null) {
            if (this.attributeType == null) {
                this.upId = upId;
                this.id = newId;
                this.rehash();
                return;
            }
            if (this.areCompatible(newId, this.attributeType)) {
                this.upId = upId;
                this.id = this.attributeType.getOid();
                this.rehash();
                return;
            }
            return;
        }
        if (Strings.isEmpty(newId)) {
            this.attributeType = attributeType;
            this.upId = attributeType.getName();
            this.id = attributeType.getOid();
            this.rehash();
            return;
        }
        if (this.areCompatible(newId, attributeType)) {
            this.upId = upId;
            this.id = attributeType.getOid();
            this.attributeType = attributeType;
            this.rehash();
            return;
        }
        throw new IllegalArgumentException("ID '" + this.id + "' and AttributeType '" + attributeType.getName() + "' are not compatible ");
    }

    @Override
    public boolean isHumanReadable() {
        return this.isHR != null ? this.isHR : false;
    }

    @Override
    public boolean isValid(AttributeType attributeType) throws LdapInvalidAttributeValueException {
        LdapSyntax syntax = attributeType.getSyntax();
        if (syntax == null) {
            return false;
        }
        SyntaxChecker syntaxChecker = syntax.getSyntaxChecker();
        if (syntaxChecker == null) {
            return false;
        }
        if (this.values.isEmpty()) {
            return syntaxChecker.isValidSyntax(null);
        }
        if (attributeType.isSingleValued() && this.values.size() > 1) {
            return false;
        }
        for (Value<?> value : this.values) {
            try {
                if (value.isValid(syntaxChecker)) continue;
                return false;
            }
            catch (LdapException le) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int add(Value<?> ... vals) {
        int nbAdded = 0;
        BinaryValue nullBinaryValue = null;
        StringValue nullStringValue = null;
        boolean nullValueAdded = false;
        Value<?>[] valArray = vals;
        if (vals == null) {
            valArray = new Value[]{};
        }
        if (this.attributeType != null) {
            for (Value<?> val : valArray) {
                String message;
                AbstractValue nullSV;
                if (this.attributeType.getSyntax().isHumanReadable()) {
                    if (val == null || val.isNull()) {
                        try {
                            nullSV = new StringValue(this.attributeType, (String)null);
                            if (!this.values.add(nullSV)) continue;
                            ++nbAdded;
                        }
                        catch (LdapInvalidAttributeValueException iae) {}
                        continue;
                    }
                    if (val instanceof StringValue) {
                        StringValue stringValue = (StringValue)val;
                        try {
                            if (stringValue.getAttributeType() == null) {
                                stringValue.apply(this.attributeType);
                            }
                            if (this.values.contains(val)) {
                                this.values.remove(val);
                                this.values.add(val);
                                continue;
                            }
                            if (!this.values.add(val)) continue;
                            ++nbAdded;
                        }
                        catch (LdapInvalidAttributeValueException iae) {}
                        continue;
                    }
                    message = I18n.err(I18n.ERR_04451, new Object[0]);
                    LOG.error(message);
                    continue;
                }
                if (val == null) {
                    if (this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(val)) {
                        try {
                            nullSV = new BinaryValue(this.attributeType, null);
                            if (!this.values.add(nullSV)) continue;
                            ++nbAdded;
                        }
                        catch (LdapInvalidAttributeValueException iae) {}
                        continue;
                    }
                    message = I18n.err(I18n.ERR_04452, new Object[0]);
                    LOG.error(message);
                    continue;
                }
                if (val instanceof BinaryValue) {
                    BinaryValue binaryValue = (BinaryValue)val;
                    try {
                        if (binaryValue.getAttributeType() == null) {
                            binaryValue = new BinaryValue(this.attributeType, val.getBytes());
                        }
                        if (!this.values.add(binaryValue)) continue;
                        ++nbAdded;
                    }
                    catch (LdapInvalidAttributeValueException iae) {}
                    continue;
                }
                message = I18n.err(I18n.ERR_04452, new Object[0]);
                LOG.error(message);
            }
        } else {
            for (Value<?> val : valArray) {
                if (val == null) {
                    if (this.isHR == null) {
                        nullBinaryValue = new BinaryValue((byte[])null);
                        nullStringValue = new StringValue((String)null);
                        this.values.add(nullBinaryValue);
                        this.values.add(nullStringValue);
                        nullValueAdded = true;
                        ++nbAdded;
                        continue;
                    }
                    if (!this.isHR.booleanValue()) {
                        nullBinaryValue = new BinaryValue((byte[])null);
                        if (this.values.contains(nullBinaryValue)) continue;
                        this.values.add(nullBinaryValue);
                        ++nbAdded;
                        continue;
                    }
                    nullStringValue = new StringValue((String)null);
                    if (this.values.contains(nullStringValue)) continue;
                    this.values.add(nullStringValue);
                    continue;
                }
                if (val instanceof StringValue) {
                    if (this.isHR == null) {
                        this.isHR = true;
                        this.values.add(val);
                        ++nbAdded;
                        continue;
                    }
                    if (!this.isHR.booleanValue()) {
                        BinaryValue bv = new BinaryValue(val.getBytes());
                        if (this.contains(bv)) continue;
                        this.values.add(bv);
                        ++nbAdded;
                        continue;
                    }
                    if (this.contains(val)) continue;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                if (this.isHR == null) {
                    this.isHR = false;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                if (!this.isHR.booleanValue()) {
                    if (this.contains(val)) continue;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                StringValue sv = new StringValue(val.getString());
                if (this.contains(sv)) continue;
                this.values.add(sv);
                ++nbAdded;
            }
        }
        if (nullValueAdded) {
            if (this.isHR.booleanValue()) {
                this.values.remove(nullBinaryValue);
            } else {
                this.values.remove(nullStringValue);
            }
        }
        return nbAdded;
    }

    @Override
    public int add(String ... vals) throws LdapInvalidAttributeValueException {
        int nbAdded = 0;
        String[] valArray = vals;
        if (vals == null) {
            valArray = new String[]{};
        }
        if (this.isHR == null) {
            this.isHR = true;
        }
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (String val : valArray) {
                    Value<String> value = this.createStringValue(this.attributeType, val);
                    if (value == null) {
                        LOG.error(I18n.err(I18n.ERR_04449, val));
                        continue;
                    }
                    if (this.add(value) == 1) {
                        ++nbAdded;
                        continue;
                    }
                    LOG.warn(I18n.err(I18n.ERR_04486_VALUE_ALREADY_EXISTS, val, this.upId));
                }
            } else {
                for (String val : valArray) {
                    Value<byte[]> value;
                    byte[] valBytes = null;
                    if (val != null) {
                        valBytes = Strings.getBytesUtf8(val);
                    }
                    if (this.add(value = this.createBinaryValue(this.attributeType, valBytes)) != 1) continue;
                    ++nbAdded;
                }
            }
        } else {
            if (this.attributeType.isSingleValued() && this.values.size() + valArray.length > 1) {
                LOG.error(I18n.err(I18n.ERR_04487_ATTRIBUTE_IS_SINGLE_VALUED, this.attributeType.getName()));
                return 0;
            }
            if (this.isHR.booleanValue()) {
                for (String val : valArray) {
                    Value<String> value = this.createStringValue(this.attributeType, val);
                    if (value == null) {
                        LOG.error(I18n.err(I18n.ERR_04449, val));
                        continue;
                    }
                    if (this.add(value) == 1) {
                        ++nbAdded;
                        continue;
                    }
                    LOG.warn(I18n.err(I18n.ERR_04486_VALUE_ALREADY_EXISTS, val, this.upId));
                }
            } else {
                for (String val : valArray) {
                    Value<byte[]> value;
                    byte[] valBytes = null;
                    if (val != null) {
                        valBytes = Strings.getBytesUtf8(val);
                    }
                    if (this.add(value = this.createBinaryValue(this.attributeType, valBytes)) != 1) continue;
                    ++nbAdded;
                }
            }
        }
        return nbAdded;
    }

    @Override
    public int add(byte[] ... vals) throws LdapInvalidAttributeValueException {
        int nbAdded = 0;
        Object valArray = vals;
        if (vals == null) {
            valArray = new byte[0][];
        }
        if (this.isHR == null) {
            this.isHR = false;
        }
        if (!this.isHR.booleanValue()) {
            for (byte[] val : valArray) {
                Value<byte[]> value = this.attributeType == null ? new BinaryValue(val) : this.createBinaryValue(this.attributeType, val);
                if (this.add(value) != 0) {
                    ++nbAdded;
                    continue;
                }
                LOG.warn(I18n.err(I18n.ERR_04486_VALUE_ALREADY_EXISTS, Strings.dumpBytes(val), this.upId));
            }
        } else {
            LOG.info(I18n.err(I18n.ERR_04451, new Object[0]));
            return 0;
        }
        return nbAdded;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(Value<?> ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (Value<?> val : vals) {
                    byte[] binaryVal;
                    if (!(val instanceof StringValue ? !this.values.contains(val) : !this.values.contains(new StringValue(Strings.utf8ToString(binaryVal = val.getBytes()))))) continue;
                    return false;
                }
            } else {
                for (Value<?> val : vals) {
                    String stringVal;
                    if (!(val.isHumanReadable() ? !this.values.contains(new BinaryValue(Strings.getBytesUtf8(stringVal = val.getString()))) : !this.values.contains(val))) continue;
                    return false;
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    try {
                        if (stringValue.getAttributeType() == null) {
                            stringValue.apply(this.attributeType);
                        }
                    }
                    catch (LdapInvalidAttributeValueException liave) {
                        return false;
                    }
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof BinaryValue) {
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(String ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    try {
                        if (this.contains(new StringValue(val))) continue;
                        return false;
                    }
                    catch (IllegalArgumentException iae) {
                        return false;
                    }
                }
            } else {
                for (String val : vals) {
                    byte[] binaryVal = Strings.getBytesUtf8(val);
                    if (this.contains(new BinaryValue(binaryVal))) continue;
                    return false;
                }
            }
        } else {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    try {
                        StringValue value = new StringValue(this.attributeType, val);
                        if (this.values.contains(value)) continue;
                        return false;
                    }
                    catch (LdapInvalidAttributeValueException liave) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(byte[] ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.attributeType == null) {
            if (!this.isHR.booleanValue()) {
                for (byte[] val : vals) {
                    if (this.contains(new BinaryValue(val))) continue;
                    return false;
                }
            } else {
                for (byte[] val : vals) {
                    String stringVal = Strings.utf8ToString(val);
                    if (this.contains(new StringValue(stringVal))) continue;
                    return false;
                }
            }
        } else {
            if (!this.isHR.booleanValue()) {
                for (byte[] val : vals) {
                    try {
                        BinaryValue value = new BinaryValue(this.attributeType, val);
                        if (this.values.contains(value)) continue;
                        return false;
                    }
                    catch (LdapInvalidAttributeValueException liave) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Value<?> get() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean remove(Value<?> ... vals) {
        if (this.isHR == null || this.values.isEmpty()) {
            return false;
        }
        boolean removed = true;
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (Value<?> val : vals) {
                    if (val instanceof StringValue) {
                        removed &= this.values.remove(val);
                        continue;
                    }
                    byte[] binaryVal = val.getBytes();
                    removed &= this.values.remove(new StringValue(Strings.utf8ToString(binaryVal)));
                }
            } else {
                for (Value<?> val : vals) {
                    removed &= this.values.remove(val);
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    try {
                        if (stringValue.getAttributeType() == null) {
                            stringValue.apply(this.attributeType);
                        }
                        removed &= this.values.remove(stringValue);
                    }
                    catch (LdapInvalidAttributeValueException liave) {
                        removed = false;
                    }
                    continue;
                }
                removed = false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof BinaryValue) {
                    try {
                        BinaryValue binaryValue = (BinaryValue)val;
                        if (binaryValue.getAttributeType() == null) {
                            binaryValue.apply(this.attributeType);
                        }
                        removed &= this.values.remove(binaryValue);
                    }
                    catch (LdapInvalidAttributeValueException liave) {
                        removed = false;
                    }
                    continue;
                }
                removed = false;
            }
        }
        return removed;
    }

    @Override
    public boolean remove(byte[] ... vals) {
        if (this.isHR == null || this.values.isEmpty()) {
            return false;
        }
        boolean removed = true;
        if (this.attributeType == null) {
            if (!this.isHR.booleanValue()) {
                for (byte[] val : vals) {
                    BinaryValue value = new BinaryValue(val);
                    removed &= this.values.remove(value);
                }
            } else {
                for (byte[] val : vals) {
                    StringValue value = new StringValue(Strings.utf8ToString(val));
                    removed &= this.values.remove(value);
                }
            }
        } else if (!this.isHR.booleanValue()) {
            try {
                for (byte[] val : vals) {
                    BinaryValue value = new BinaryValue(this.attributeType, val);
                    removed &= this.values.remove(value);
                }
            }
            catch (LdapInvalidAttributeValueException liave) {
                removed = false;
            }
        } else {
            removed = false;
        }
        return removed;
    }

    @Override
    public boolean remove(String ... vals) {
        if (this.isHR == null || this.values.isEmpty()) {
            return false;
        }
        boolean removed = true;
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    StringValue value = new StringValue(val);
                    removed &= this.values.remove(value);
                }
            } else {
                for (String val : vals) {
                    BinaryValue value = new BinaryValue(Strings.getBytesUtf8(val));
                    removed &= this.values.remove(value);
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (String val : vals) {
                try {
                    StringValue value = new StringValue(this.attributeType, val);
                    removed &= this.values.remove(value);
                }
                catch (LdapInvalidAttributeValueException liave) {
                    removed = false;
                }
            }
        } else {
            removed = false;
        }
        return removed;
    }

    @Override
    public Iterator<Value<?>> iterator() {
        return this.values.iterator();
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void apply(AttributeType attributeType) throws LdapInvalidAttributeValueException {
        if (attributeType == null) {
            throw new IllegalArgumentException("The AttributeType parameter should not be null");
        }
        this.attributeType = attributeType;
        this.id = attributeType.getOid();
        if (Strings.isEmpty(this.upId)) {
            this.upId = attributeType.getName();
        } else if (!this.areCompatible(this.upId, attributeType)) {
            this.upId = attributeType.getName();
        }
        if (this.values != null) {
            LinkedHashSet newValues = new LinkedHashSet(this.values.size());
            for (Value<?> value : this.values) {
                if (value instanceof StringValue) {
                    newValues.add(new StringValue(attributeType, value.getString()));
                    continue;
                }
                newValues.add(new BinaryValue(attributeType, value.getBytes()));
            }
            this.values = newValues;
        }
        this.isHR = attributeType.getSyntax().isHumanReadable();
        this.rehash();
    }

    @Override
    public boolean isInstanceOf(AttributeType attributeType) throws LdapInvalidAttributeValueException {
        return attributeType != null && (this.attributeType.equals(attributeType) || this.attributeType.isDescendantOf(attributeType));
    }

    private void rehash() {
        this.h = 37;
        if (this.isHR != null) {
            this.h = this.h * 17 + this.isHR.hashCode();
        }
        if (this.id != null) {
            this.h = this.h * 17 + this.id.hashCode();
        }
        if (this.attributeType != null) {
            this.h = this.h * 17 + this.attributeType.hashCode();
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            this.rehash();
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.id == null) {
            if (other.getId() != null) {
                return false;
            }
        } else {
            if (other.getId() == null) {
                return false;
            }
            if (this.attributeType != null ? !this.attributeType.equals(other.getAttributeType()) : !this.id.equals(other.getId())) {
                return false;
            }
        }
        if (this.isHumanReadable() != other.isHumanReadable()) {
            return false;
        }
        if (this.values.size() != other.size()) {
            return false;
        }
        for (Value<?> val : this.values) {
            if (other.contains(val)) continue;
            return false;
        }
        if (this.attributeType == null) {
            return other.getAttributeType() == null;
        }
        return this.attributeType.equals(other.getAttributeType());
    }

    @Override
    public Attribute clone() {
        try {
            DefaultAttribute attribute = (DefaultAttribute)super.clone();
            if (this.attributeType != null) {
                attribute.id = this.attributeType.getOid();
                attribute.attributeType = this.attributeType;
            }
            attribute.values = new LinkedHashSet(this.values.size());
            for (Value<?> value : this.values) {
                attribute.values.add(value);
            }
            return attribute;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.upId);
        if (this.isHR != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.isHR);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.size());
        if (this.size() > 0) {
            for (Value<?> value : this.values) {
                value.writeExternal(out);
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbValues;
        this.upId = in.readUTF();
        this.setUpId(this.upId);
        if (in.readBoolean()) {
            this.isHR = in.readBoolean();
        }
        if ((nbValues = in.readInt()) > 0) {
            for (int i = 0; i < nbValues; ++i) {
                AbstractValue value = this.isHR != false ? new StringValue(this.attributeType) : new BinaryValue(this.attributeType);
                value.readExternal(in);
                this.values.add(value);
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        if (this.values != null && !this.values.isEmpty()) {
            boolean isFirst = true;
            for (Value<?> value : this.values) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('\n');
                }
                sb.append(tabs).append(this.upId).append(": ");
                if (value.isNull()) {
                    sb.append("''");
                    continue;
                }
                sb.append(value);
            }
        } else {
            sb.append(tabs).append(this.upId).append(": (null)");
        }
        return sb.toString();
    }
}

