/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.AbstractAnonymizer;

public class IntegerAnonymizer
extends AbstractAnonymizer<String> {
    private Map<Integer, String> latestIntegerMap;

    public IntegerAnonymizer() {
        this.latestIntegerMap = new HashMap<Integer, String>();
    }

    public IntegerAnonymizer(Map<Integer, String> latestIntegerMap) {
        this.latestIntegerMap = latestIntegerMap == null ? new HashMap<Integer, String>() : latestIntegerMap;
    }

    @Override
    public Attribute anonymize(Map<Value<String>, Value<String>> valueMap, Set<Value<String>> valueSet, Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        for (Value value : attribute) {
            if (!(value instanceof StringValue)) continue;
            Value<String> anonymized = valueMap.get(value);
            if (anonymized != null) {
                try {
                    result.add(anonymized);
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                continue;
            }
            String strValue = value.getNormValue().toString();
            String newValue = this.computeNewIntegerValue(strValue);
            try {
                result.add(newValue);
                StringValue anonValue = new StringValue(attribute.getAttributeType(), newValue);
                valueMap.put(value, anonValue);
                valueSet.add(anonValue);
            }
            catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
        }
        return result;
    }

    public Map<Integer, String> getLatestIntegerMap() {
        return this.latestIntegerMap;
    }

    public void setLatestIntegerMap(Map<Integer, String> latestIntegerMap) {
        this.latestIntegerMap = latestIntegerMap;
    }

    private String computeNewIntegerValue(String valStr) {
        int length = valStr.length();
        String latestInteger = this.latestIntegerMap.get(length);
        if (latestInteger == null) {
            char[] newValue = new char[length];
            Arrays.fill(newValue, '9');
            String anonymizedValue = new String(newValue);
            this.latestIntegerMap.put(length, anonymizedValue);
            return anonymizedValue;
        }
        char[] latest = latestInteger.toCharArray();
        boolean overflow = true;
        for (int i = length - 1; i >= 0; --i) {
            if (latest[i] != '0') {
                int n = i;
                latest[n] = (char)(latest[n] - '\u0001');
                overflow = false;
                break;
            }
            latest[i] = 57;
        }
        if (length > 1 && latest[0] == '0') {
            throw new RuntimeException("Overflow for " + valStr);
        }
        String anonymizedValue = new String(latest);
        if (overflow) {
            throw new RuntimeException("Cannot compute a new value for " + anonymizedValue);
        }
        this.latestIntegerMap.put(length, anonymizedValue);
        return anonymizedValue;
    }
}

