/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;

public class DeepTrimNormalizer
extends Normalizer {
    public DeepTrimNormalizer(String oid) {
        super(oid);
    }

    public DeepTrimNormalizer() {
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.DIRECTORY_STRING);
            return new StringValue(normalized);
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_04224, value), ioe);
        }
    }

    @Override
    public String normalize(String value) throws LdapException {
        try {
            return PrepareString.normalize(value, PrepareString.StringType.DIRECTORY_STRING);
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_04224, value), ioe);
        }
    }
}

