/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class AttributeTypeUsageSyntaxChecker
extends SyntaxChecker {
    public static final AttributeTypeUsageSyntaxChecker INSTANCE = new AttributeTypeUsageSyntaxChecker("1.3.6.1.4.1.18060.0.4.0.0.3");

    private AttributeTypeUsageSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        switch (strValue) {
            case "dSAOperation": 
            case "directoryOperation": 
            case "distributedOperation": 
            case "userApplications": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
                }
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
        }
        return false;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<AttributeTypeUsageSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.0.0.3");
        }

        @Override
        public AttributeTypeUsageSyntaxChecker build() {
            return new AttributeTypeUsageSyntaxChecker(this.oid);
        }
    }
}

