/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flex2.compiler.asdoc.PackageInfo;
import flex2.tools.ASDocConfiguration;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OverviewsHandler
extends DefaultHandler {
    private BufferedWriter writer;
    private List packages;

    public OverviewsHandler(BufferedWriter w, ASDocConfiguration config) {
        this.writer = w;
        this.packages = config.getPackagesConfiguration().getPackages();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equals("packages") && this.packages.size() > 0) {
                throw new RuntimeException("packages can not be specified in ASDoc_Config.xml and as a Flex parameter");
            }
            this.writer.newLine();
            this.writer.write("<" + qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.writer.write(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
            }
            this.writer.write(">");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (qName.equals("overviews") && this.packages.size() > 0) {
                this.writer.newLine();
                this.writer.write("<packages>");
                for (PackageInfo info : this.packages) {
                    this.writer.newLine();
                    this.writer.write("<package name=\"" + info.name + "\">");
                    this.writer.newLine();
                    this.writer.write("<shortDescription>" + info.description + "</shortDescription>");
                    this.writer.write("<longDescription>" + info.description + "</longDescription>");
                    this.writer.newLine();
                    this.writer.write("</package>");
                }
                this.writer.newLine();
                this.writer.write("</packages>");
            }
            this.writer.write("</" + qName + ">");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.write(new String(ch, start, length));
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

