/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.runtime.directive;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.flex.forks.velocity.VelocityContext;
import org.apache.flex.forks.velocity.context.InternalContextAdapter;
import org.apache.flex.forks.velocity.context.InternalContextAdapterImpl;
import org.apache.flex.forks.velocity.exception.MethodInvocationException;
import org.apache.flex.forks.velocity.runtime.RuntimeServices;
import org.apache.flex.forks.velocity.runtime.parser.ParserTreeConstants;
import org.apache.flex.forks.velocity.runtime.parser.node.ASTReference;
import org.apache.flex.forks.velocity.runtime.parser.node.Node;
import org.apache.flex.forks.velocity.runtime.parser.node.SimpleNode;
import org.apache.flex.forks.velocity.util.StringUtils;

public class VMProxyArg
implements Serializable {
    private int type = 0;
    private Node nodeTree = null;
    private Object staticObject = null;
    private InternalContextAdapter usercontext = null;
    private int numTreeChildren = 0;
    private String contextReference = null;
    private String callerReference = null;
    private String singleLevelRef = null;
    private boolean constant = false;
    private final int GENERALSTATIC = -1;
    private transient RuntimeServices rsvc = null;

    public VMProxyArg(RuntimeServices rs, String contextRef, Node callerArg) {
        this.rsvc = rs;
        this.contextReference = contextRef;
        this.nodeTree = callerArg;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public Object setObject(InternalContextAdapter context, Object o) {
        if (this.type == 14) {
            if (this.numTreeChildren > 0) {
                try {
                    ((ASTReference)this.nodeTree).setValue(context, o);
                }
                catch (MethodInvocationException mie) {
                    this.rsvc.error("VMProxyArg.getObject() : method invocation error setting value : " + mie);
                }
            } else {
                context.put(this.singleLevelRef, o);
            }
        } else {
            this.type = -1;
            this.staticObject = o;
            this.rsvc.error("VMProxyArg.setObject() : Programmer error : I am a constant!  No setting! : " + this.contextReference + " / " + this.callerReference);
        }
        return null;
    }

    public Object getObject(InternalContextAdapter context) {
        try {
            return this.nodeTree.value(context);
        }
        catch (MethodInvocationException mie) {
            this.rsvc.error("VMProxyArg.getObject() : method invocation error getting value : " + mie);
            return null;
        }
    }

    private void setup() {
        switch (this.type) {
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 17: {
                this.constant = false;
                try {
                    String buff = "#include(" + this.callerReference + " ) ";
                    BufferedReader br = new BufferedReader(new StringReader(buff));
                    this.nodeTree = this.rsvc.parse(br, "VMProxyArg:" + this.callerReference, true);
                    this.nodeTree = (SimpleNode)this.nodeTree.jjtGetChild(0).jjtGetChild(0);
                    if (this.nodeTree != null && this.nodeTree.getType() != this.type) {
                        this.rsvc.error("VMProxyArg.setup() : programmer error : type doesn't match node type.");
                    }
                    InternalContextAdapterImpl ica = new InternalContextAdapterImpl(new VelocityContext());
                    ica.pushCurrentTemplateName("VMProxyArg : " + ParserTreeConstants.jjtNodeName[this.type]);
                    this.nodeTree.init(ica, this.rsvc);
                }
                catch (Exception e) {
                    this.rsvc.error("VMProxyArg.setup() : exception " + this.callerReference + " : " + StringUtils.stackTrace(e));
                }
                break;
            }
            case 15: {
                this.constant = true;
                this.staticObject = new Boolean(true);
                break;
            }
            case 16: {
                this.constant = true;
                this.staticObject = new Boolean(false);
                break;
            }
            case 5: {
                this.constant = true;
                this.staticObject = new Integer(this.callerReference);
                break;
            }
            case 8: {
                this.rsvc.error("Unsupported arg type : " + this.callerReference + "  You most likely intended to call a VM with a string literal, so enclose with ' or \" characters. (VMProxyArg.setup())");
                this.constant = true;
                this.staticObject = new String(this.callerReference);
                break;
            }
            default: {
                this.rsvc.error(" VMProxyArg.setup() : unsupported type : " + this.callerReference);
            }
        }
    }

    public VMProxyArg(VMProxyArg model, InternalContextAdapter c) {
        this.usercontext = c;
        this.contextReference = model.getContextReference();
        this.callerReference = model.getCallerReference();
        this.nodeTree = model.getNodeTree();
        this.staticObject = model.getStaticObject();
        this.type = model.getType();
        if (this.nodeTree != null) {
            this.numTreeChildren = this.nodeTree.jjtGetNumChildren();
        }
        if (this.type == 14 && this.numTreeChildren == 0) {
            this.singleLevelRef = ((ASTReference)this.nodeTree).getRootString();
        }
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public String getContextReference() {
        return this.contextReference;
    }

    public Node getNodeTree() {
        return this.nodeTree;
    }

    public Object getStaticObject() {
        return this.staticObject;
    }

    public int getType() {
        return this.type;
    }
}

