/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.amf.translator.TranslationException;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionDecoder
extends ActionScriptDecoder {
    @Override
    public boolean hasShell() {
        return true;
    }

    protected boolean isSuitableCollection(Object encodedObject, Class desiredClass) {
        return encodedObject instanceof Collection && desiredClass.isAssignableFrom(encodedObject.getClass());
    }

    @Override
    public Object createShell(Object encodedObject, Class desiredClass) {
        AbstractCollection col = null;
        try {
            if (encodedObject != null) {
                if (this.isSuitableCollection(encodedObject, desiredClass)) {
                    col = (Collection)encodedObject;
                } else if (desiredClass.isInterface()) {
                    if (List.class.isAssignableFrom(desiredClass)) {
                        col = new ArrayList();
                    } else if (SortedSet.class.isAssignableFrom(desiredClass)) {
                        col = new TreeSet();
                    } else if (Set.class.isAssignableFrom(desiredClass)) {
                        col = new HashSet();
                    } else if (Collection.class.isAssignableFrom(desiredClass)) {
                        col = new ArrayList();
                    }
                } else {
                    col = (Collection)desiredClass.newInstance();
                }
            } else {
                col = (ArrayList)desiredClass.newInstance();
            }
        }
        catch (Exception e) {
            TranslationException ex = new TranslationException("Could not create Collection " + desiredClass, e);
            ex.setCode("Server.Processing");
            throw ex;
        }
        if (col == null) {
            DecoderFactory.invalidType(encodedObject, desiredClass);
        }
        return col;
    }

    @Override
    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        if (shell == null || encodedObject == null) {
            return null;
        }
        if (this.isSuitableCollection(encodedObject, desiredClass)) {
            return encodedObject;
        }
        return this.decodeCollection((Collection)shell, encodedObject);
    }

    protected Collection decodeCollection(Collection collectionShell, Object encodedObject) {
        Object obj = null;
        if (encodedObject instanceof String) {
            encodedObject = ((String)encodedObject).toCharArray();
        } else if (encodedObject instanceof Collection) {
            encodedObject = ((Collection)encodedObject).toArray();
        }
        int len = Array.getLength(encodedObject);
        for (int i = 0; i < len; ++i) {
            obj = Array.get(encodedObject, i);
            collectionShell.add(obj);
        }
        return collectionShell;
    }
}

