/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.v4.runtime.misc;

import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LogManager {
    protected List<Record> records;

    public void log(@Nullable String component, String msg) {
        Record r = new Record();
        r.component = component;
        r.msg = msg;
        if (this.records == null) {
            this.records = new ArrayList<Record>();
        }
        this.records.add(r);
    }

    public void log(String msg) {
        this.log(null, msg);
    }

    public void save(String filename) throws IOException {
        FileWriter fw = new FileWriter(filename);
        try (BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(this.toString());
        }
    }

    public String save() throws IOException {
        String dir = ".";
        String defaultFilename = dir + "/antlr-" + new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date()) + ".log";
        this.save(defaultFilename);
        return defaultFilename;
    }

    public String toString() {
        if (this.records == null) {
            return "";
        }
        String nl = System.lineSeparator();
        StringBuilder buf = new StringBuilder();
        for (Record r : this.records) {
            buf.append(r);
            buf.append(nl);
        }
        return buf.toString();
    }

    public static void main(String[] args) throws IOException {
        LogManager mgr = new LogManager();
        mgr.log("atn", "test msg");
        mgr.log("dfa", "test msg 2");
        System.out.println(mgr);
        mgr.save();
    }

    protected static class Record {
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
        private static final ZoneId ZONE = ZoneId.systemDefault();
        long timestamp = System.currentTimeMillis();
        StackTraceElement location = new Throwable().getStackTrace()[0];
        String component;
        String msg;

        public String toString() {
            String result = DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZONE)) + " " + this.component + " " + this.location.getFileName() + ":" + this.location.getLineNumber() + " " + this.msg;
            return result;
        }
    }
}

