/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.Console;
import org.apache.karaf.shell.console.ConsoleFactory;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.ssh.SshTerminal;
import org.apache.karaf.util.StreamLoggerInterceptor;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.osgi.service.blueprint.container.ReifiedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellFactoryImpl
implements Factory<Command> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellFactoryImpl.class);
    private CommandProcessor commandProcessor;
    private ConsoleFactory consoleFactory;
    private ThreadIO threadIO;
    private boolean consoleLogger;
    private String consoleLoggerName;
    private String consoleLoggerOutLevel;
    private String consoleLoggerErrLevel;

    public ShellFactoryImpl(CommandProcessor commandProcessor, ConsoleFactory consoleFactory, ThreadIO threadIO, boolean consoleLogger, String consoleLoggerName, String consoleLoggerOutLevel, String consoleLoggerErrLevel) {
        this.commandProcessor = commandProcessor;
        this.consoleFactory = consoleFactory;
        this.threadIO = threadIO;
        this.consoleLogger = consoleLogger;
        this.consoleLoggerName = consoleLoggerName;
        this.consoleLoggerOutLevel = consoleLoggerOutLevel;
        this.consoleLoggerErrLevel = consoleLoggerErrLevel;
    }

    public Command create() {
        return new ShellImpl();
    }

    public static String getEncoding() {
        String envEncoding = ShellFactoryImpl.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }

    private static void flush(OutputStream ... streams) {
        for (OutputStream s : streams) {
            try {
                s.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static Converter getConverter() {
        return new Converter();
    }

    public class LfToCrLfFilterOutputStream
    extends FilterOutputStream {
        private boolean lastWasCr;

        public LfToCrLfFilterOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.lastWasCr && b == 10) {
                this.out.write(13);
                this.out.write(10);
            } else {
                this.out.write(b);
            }
            this.lastWasCr = b == 13;
        }
    }

    public static class Converter
    implements org.osgi.service.blueprint.container.Converter {
        public boolean canConvert(Object sourceObject, ReifiedType targetType) {
            return ShellFactoryImpl.class.isAssignableFrom(sourceObject.getClass()) && Factory.class.equals((Object)targetType.getRawClass()) && Command.class.equals((Object)targetType.getActualTypeArgument(0).getRawClass());
        }

        public Object convert(Object sourceObject, ReifiedType targetType) throws Exception {
            return sourceObject;
        }
    }

    public class ShellImpl
    implements Command,
    SessionAware {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = ShellFactoryImpl.this.consoleLogger ? new StreamLoggerInterceptor(out, ShellFactoryImpl.this.consoleLoggerName, ShellFactoryImpl.this.consoleLoggerOutLevel) : out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = ShellFactoryImpl.this.consoleLogger ? new StreamLoggerInterceptor(err, ShellFactoryImpl.this.consoleLoggerName, ShellFactoryImpl.this.consoleLoggerErrLevel) : err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(final Environment env) throws IOException {
            new Thread(){

                @Override
                public void run() {
                    Subject subject;
                    Subject subject2 = subject = ShellImpl.this.session != null ? (Subject)ShellImpl.this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                    if (subject != null) {
                        JaasHelper.doAs((Subject)subject, (PrivilegedAction)new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                String userName = JaasHelper.getUserName((Subject)subject);
                                Thread.currentThread().setName("Karaf Console ssh for user " + userName);
                                this.runConsole(userName);
                                return null;
                            }
                        });
                    } else {
                        Thread.currentThread().setName("Karaf Console ssh for anonymous user");
                        this.runConsole(null);
                    }
                }

                protected void runConsole(String userName) {
                    try {
                        SshTerminal terminal = new SshTerminal(env);
                        Runnable destroyCallback = new Runnable(){

                            @Override
                            public void run() {
                                ShellImpl.this.destroy();
                            }
                        };
                        String encoding = ShellFactoryImpl.getEncoding();
                        Console console = ShellFactoryImpl.this.consoleFactory.create(ShellFactoryImpl.this.commandProcessor, ShellFactoryImpl.this.threadIO, ShellImpl.this.in, ShellImpl.this.lfToCrLfPrintStream(ShellImpl.this.out), ShellImpl.this.lfToCrLfPrintStream(ShellImpl.this.err), (Terminal)terminal, encoding, destroyCallback);
                        CommandSession session = console.getSession();
                        for (Map.Entry e : env.getEnv().entrySet()) {
                            session.put((String)e.getKey(), e.getValue());
                        }
                        session.put("USER", (Object)userName);
                        console.run();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to start shell", (Throwable)e);
                        try {
                            ShellImpl.this.out.write(("unable to start shell because " + e.getMessage() + "\n").getBytes());
                            ShellImpl.this.out.flush();
                        }
                        catch (IOException e1) {
                            LOGGER.warn("Unable to send back error message", (Throwable)e1);
                        }
                        ShellImpl.this.session.close(true);
                    }
                }
            }.start();
        }

        private PrintStream lfToCrLfPrintStream(OutputStream stream) {
            return new PrintStream(new LfToCrLfFilterOutputStream(stream), true);
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.flush(new OutputStream[]{this.out, this.err});
                ShellFactoryImpl.close(new Closeable[]{this.in, this.out, this.err});
                this.callback.onExit(0);
            }
        }
    }
}

