/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstructorInterceptorHandler;
import org.jvnet.hk2.internal.Creator;
import org.jvnet.hk2.internal.InjecteeImpl;
import org.jvnet.hk2.internal.InstanceLifecycleEventImpl;
import org.jvnet.hk2.internal.MethodInterceptorHandler;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;
import org.jvnet.hk2.internal.Utilities;

public class ClazzCreator<T>
implements Creator<T> {
    private static final MethodFilter METHOD_FILTER = new MethodFilter(){

        public boolean isHandled(Method method) {
            return !method.getName().equals("finalize");
        }
    };
    private final ServiceLocatorImpl locator;
    private final Class<?> implClass;
    private final Set<ResolutionInfo> myInitializers = new LinkedHashSet<ResolutionInfo>();
    private final Set<ResolutionInfo> myFields = new LinkedHashSet<ResolutionInfo>();
    private ActiveDescriptor<?> selfDescriptor;
    private ResolutionInfo myConstructor;
    private List<Injectee> allInjectees;
    private Method postConstructMethod;
    private Method preDestroyMethod;

    ClazzCreator(ServiceLocatorImpl locator, Class<?> implClass) {
        this.locator = locator;
        this.implClass = implClass;
    }

    void initialize(ActiveDescriptor<?> selfDescriptor, String analyzerName, Collector collector) {
        ClassAnalyzer analyzer;
        this.selfDescriptor = selfDescriptor;
        if (selfDescriptor != null && selfDescriptor.getAdvertisedContracts().contains(ClassAnalyzer.class.getName())) {
            String incomingAnalyzerName;
            String descriptorAnalyzerName = selfDescriptor.getName();
            if (descriptorAnalyzerName == null) {
                descriptorAnalyzerName = this.locator.getDefaultClassAnalyzerName();
            }
            if ((incomingAnalyzerName = analyzerName) == null) {
                incomingAnalyzerName = this.locator.getDefaultClassAnalyzerName();
            }
            if (descriptorAnalyzerName.equals(incomingAnalyzerName)) {
                collector.addThrowable(new IllegalArgumentException("The ClassAnalyzer named " + descriptorAnalyzerName + " is its own ClassAnalyzer. Ensure that an implementation of" + " ClassAnalyzer is not its own ClassAnalyzer"));
                this.myConstructor = null;
                return;
            }
        }
        if ((analyzer = Utilities.getClassAnalyzer(this.locator, analyzerName, collector)) == null) {
            this.myConstructor = null;
            return;
        }
        LinkedList<Injectee> baseAllInjectees = new LinkedList<Injectee>();
        AccessibleObject element = Utilities.getConstructor(this.implClass, analyzer, collector);
        if (element == null) {
            this.myConstructor = null;
            return;
        }
        List<Injectee> injectees = Utilities.getConstructorInjectees(element, selfDescriptor);
        if (injectees == null) {
            this.myConstructor = null;
            return;
        }
        baseAllInjectees.addAll(injectees);
        this.myConstructor = new ResolutionInfo(element, injectees);
        Set<Method> initMethods = Utilities.getInitMethods(this.implClass, analyzer, collector);
        for (Method initMethod : initMethods) {
            element = initMethod;
            injectees = Utilities.getMethodInjectees(initMethod, selfDescriptor);
            if (injectees == null) {
                return;
            }
            baseAllInjectees.addAll(injectees);
            this.myInitializers.add(new ResolutionInfo(element, injectees));
        }
        Set<Field> fields = Utilities.getInitFields(this.implClass, analyzer, collector);
        for (Field field : fields) {
            element = field;
            injectees = Utilities.getFieldInjectees(field, selfDescriptor);
            if (injectees == null) {
                return;
            }
            baseAllInjectees.addAll(injectees);
            this.myFields.add(new ResolutionInfo(element, injectees));
        }
        this.postConstructMethod = Utilities.getPostConstruct(this.implClass, analyzer, collector);
        this.preDestroyMethod = Utilities.getPreDestroy(this.implClass, analyzer, collector);
        this.allInjectees = Collections.unmodifiableList(baseAllInjectees);
        Utilities.validateSelfInjectees(selfDescriptor, this.allInjectees, collector);
    }

    void initialize(ActiveDescriptor<?> selfDescriptor, Collector collector) {
        this.initialize(selfDescriptor, selfDescriptor == null ? null : selfDescriptor.getClassAnalysisName(), collector);
    }

    void resetSelfDescriptor(ActiveDescriptor<?> selfDescriptor) {
        this.selfDescriptor = selfDescriptor;
        for (Injectee injectee : this.allInjectees) {
            if (!(injectee instanceof InjecteeImpl)) continue;
            ((InjecteeImpl)injectee).resetInjecteeDescriptor(selfDescriptor);
        }
    }

    private void resolve(Map<Injectee, Object> addToMe, InjectionResolver<?> resolver, Injectee injectee, ServiceHandle<?> root, Collector errorCollection) {
        if (injectee.isSelf()) {
            addToMe.put(injectee, this.selfDescriptor);
            return;
        }
        Object addIn = null;
        try {
            addIn = resolver.resolve(injectee, root);
        }
        catch (Throwable th) {
            errorCollection.addThrowable(th);
        }
        if (addIn != null) {
            addToMe.put(injectee, addIn);
        }
    }

    private Map<Injectee, Object> resolveAllDependencies(ServiceHandle<?> root) throws MultiException, IllegalStateException {
        InjectionResolver<?> resolver;
        Collector errorCollector = new Collector();
        LinkedHashMap<Injectee, Object> retVal = new LinkedHashMap<Injectee, Object>();
        for (Injectee injectee : this.myConstructor.injectees) {
            resolver = Utilities.getInjectionResolver(this.locator, injectee);
            this.resolve(retVal, resolver, injectee, root, errorCollector);
        }
        for (ResolutionInfo fieldRI : this.myFields) {
            resolver = Utilities.getInjectionResolver(this.locator, fieldRI.baseElement);
            for (Injectee injectee : fieldRI.injectees) {
                this.resolve(retVal, resolver, injectee, root, errorCollector);
            }
        }
        for (ResolutionInfo methodRI : this.myInitializers) {
            for (Injectee injectee : methodRI.injectees) {
                InjectionResolver<?> resolver2 = Utilities.getInjectionResolver(this.locator, injectee);
                this.resolve(retVal, resolver2, injectee, root, errorCollector);
            }
        }
        if (errorCollector.hasErrors()) {
            errorCollector.addThrowable(new IllegalArgumentException("While attempting to resolve the dependencies of " + this.implClass.getName() + " errors were found"));
            errorCollector.throwIfErrors();
        }
        return retVal;
    }

    private Object createMe(Map<Injectee, Object> resolved) throws Throwable {
        Constructor c = (Constructor)this.myConstructor.baseElement;
        List injectees = this.myConstructor.injectees;
        Object[] args = new Object[injectees.size()];
        for (Injectee injectee : injectees) {
            args[injectee.getPosition()] = resolved.get(injectee);
        }
        Utilities.Interceptors interceptors = Utilities.getAllInterceptors(this.locator, this.selfDescriptor, this.implClass, c);
        final Map<Method, List<MethodInterceptor>> methodInterceptors = interceptors.getMethodInterceptors();
        List<ConstructorInterceptor> constructorInterceptors = interceptors.getConstructorInterceptors();
        if ((methodInterceptors == null || methodInterceptors.isEmpty()) && (constructorInterceptors == null || constructorInterceptors.isEmpty())) {
            return ReflectionHelper.makeMe((Constructor)c, (Object[])args, (boolean)this.locator.getNeutralContextClassLoader());
        }
        boolean neutral = this.locator.getNeutralContextClassLoader();
        if (methodInterceptors == null || methodInterceptors.isEmpty()) {
            return ConstructorInterceptorHandler.construct(c, args, neutral, constructorInterceptors);
        }
        return ConstructorInterceptorHandler.construct(c, args, neutral, constructorInterceptors, new ConstructorInterceptorHandler.ConstructorAction(){

            @Override
            public Object makeMe(final Constructor<?> c, final Object[] args, final boolean neutralCCL) throws Throwable {
                final MethodInterceptorHandler methodInterceptor = new MethodInterceptorHandler(ClazzCreator.this.locator, methodInterceptors);
                final ProxyFactory proxyFactory = new ProxyFactory();
                proxyFactory.setSuperclass(ClazzCreator.this.implClass);
                proxyFactory.setFilter(METHOD_FILTER);
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ClassLoader currentCCL = null;
                        if (neutralCCL) {
                            currentCCL = Thread.currentThread().getContextClassLoader();
                        }
                        try {
                            Object object = proxyFactory.create((Class[])c.getParameterTypes(), args, (MethodHandler)methodInterceptor);
                            return object;
                        }
                        catch (InvocationTargetException ite) {
                            Throwable targetException = ite.getTargetException();
                            Logger.getLogger().debug(c.getDeclaringClass().getName(), c.getName(), targetException);
                            if (targetException instanceof Exception) {
                                throw (Exception)targetException;
                            }
                            throw new RuntimeException(targetException);
                        }
                        finally {
                            if (neutralCCL) {
                                Thread.currentThread().setContextClassLoader(currentCCL);
                            }
                        }
                    }
                });
            }
        });
    }

    private void fieldMe(Map<Injectee, Object> resolved, T t) throws Throwable {
        for (ResolutionInfo ri : this.myFields) {
            Field field = (Field)ri.baseElement;
            List injectees = ri.injectees;
            Injectee fieldInjectee = null;
            Iterator i$ = injectees.iterator();
            while (i$.hasNext()) {
                Injectee candidate;
                fieldInjectee = candidate = (Injectee)i$.next();
            }
            Object putMeIn = resolved.get(fieldInjectee);
            ReflectionHelper.setField((Field)field, t, (Object)putMeIn);
        }
    }

    private void methodMe(Map<Injectee, Object> resolved, T t) throws Throwable {
        for (ResolutionInfo ri : this.myInitializers) {
            Method m = (Method)ri.baseElement;
            List injectees = ri.injectees;
            Object[] args = new Object[injectees.size()];
            for (Injectee injectee : injectees) {
                args[injectee.getPosition()] = resolved.get(injectee);
            }
            ReflectionHelper.invoke(t, (Method)m, (Object[])args, (boolean)this.locator.getNeutralContextClassLoader());
        }
    }

    private void postConstructMe(T t) throws Throwable {
        if (t == null) {
            return;
        }
        if (t instanceof PostConstruct) {
            ((PostConstruct)t).postConstruct();
            return;
        }
        if (this.postConstructMethod == null) {
            return;
        }
        ReflectionHelper.invoke(t, (Method)this.postConstructMethod, (Object[])new Object[0], (boolean)this.locator.getNeutralContextClassLoader());
    }

    private void preDestroyMe(T t) throws Throwable {
        if (t == null) {
            return;
        }
        if (t instanceof PreDestroy) {
            ((PreDestroy)t).preDestroy();
            return;
        }
        if (this.preDestroyMethod == null) {
            return;
        }
        ReflectionHelper.invoke(t, (Method)this.preDestroyMethod, (Object[])new Object[0], (boolean)this.locator.getNeutralContextClassLoader());
    }

    @Override
    public T create(ServiceHandle<?> root, SystemDescriptor<?> eventThrower) {
        String failureLocation = "resolve";
        try {
            Map<Injectee, Object> allResolved = this.resolveAllDependencies(root);
            if (eventThrower != null) {
                eventThrower.invokeInstanceListeners(new InstanceLifecycleEventImpl(InstanceLifecycleEventType.PRE_PRODUCTION, null, allResolved, eventThrower));
            }
            failureLocation = "create";
            Object retVal = this.createMe(allResolved);
            failureLocation = "field inject";
            this.fieldMe(allResolved, retVal);
            failureLocation = "method inject";
            this.methodMe(allResolved, retVal);
            failureLocation = "post construct";
            this.postConstructMe(retVal);
            if (eventThrower != null) {
                eventThrower.invokeInstanceListeners(new InstanceLifecycleEventImpl(InstanceLifecycleEventType.POST_PRODUCTION, retVal, allResolved, eventThrower));
            }
            return (T)retVal;
        }
        catch (Throwable th) {
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                me.addError((Throwable)new IllegalStateException("Unable to perform operation: " + failureLocation + " on " + this.implClass.getName()));
                throw me;
            }
            MultiException me = new MultiException(th);
            me.addError((Throwable)new IllegalStateException("Unable to perform operation: " + failureLocation + " on " + this.implClass.getName()));
            throw me;
        }
    }

    @Override
    public void dispose(T instance) {
        try {
            this.preDestroyMe(instance);
        }
        catch (Throwable th) {
            if (th instanceof MultiException) {
                throw (MultiException)th;
            }
            throw new MultiException(th);
        }
    }

    @Override
    public List<Injectee> getInjectees() {
        return this.allInjectees;
    }

    private static class ResolutionInfo {
        private final AnnotatedElement baseElement;
        private final List<Injectee> injectees = new LinkedList<Injectee>();

        private ResolutionInfo(AnnotatedElement baseElement, List<Injectee> injectees) {
            this.baseElement = baseElement;
            this.injectees.addAll(injectees);
        }
    }
}

