﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class RomanianStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "", -1, 3 ),
                    new Among ( "I", 0, 1 ),
                    new Among ( "U", 0, 2 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "ea", -1, 3 ),
                    new Among ( "a\u0163ia", -1, 7 ),
                    new Among ( "aua", -1, 2 ),
                    new Among ( "iua", -1, 4 ),
                    new Among ( "a\u0163ie", -1, 7 ),
                    new Among ( "ele", -1, 3 ),
                    new Among ( "ile", -1, 5 ),
                    new Among ( "iile", 6, 4 ),
                    new Among ( "iei", -1, 4 ),
                    new Among ( "atei", -1, 6 ),
                    new Among ( "ii", -1, 4 ),
                    new Among ( "ului", -1, 1 ),
                    new Among ( "ul", -1, 1 ),
                    new Among ( "elor", -1, 3 ),
                    new Among ( "ilor", -1, 4 ),
                    new Among ( "iilor", 14, 4 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "icala", -1, 4 ),
                    new Among ( "iciva", -1, 4 ),
                    new Among ( "ativa", -1, 5 ),
                    new Among ( "itiva", -1, 6 ),
                    new Among ( "icale", -1, 4 ),
                    new Among ( "a\u0163iune", -1, 5 ),
                    new Among ( "i\u0163iune", -1, 6 ),
                    new Among ( "atoare", -1, 5 ),
                    new Among ( "itoare", -1, 6 ),
                    new Among ( "\u0103toare", -1, 5 ),
                    new Among ( "icitate", -1, 4 ),
                    new Among ( "abilitate", -1, 1 ),
                    new Among ( "ibilitate", -1, 2 ),
                    new Among ( "ivitate", -1, 3 ),
                    new Among ( "icive", -1, 4 ),
                    new Among ( "ative", -1, 5 ),
                    new Among ( "itive", -1, 6 ),
                    new Among ( "icali", -1, 4 ),
                    new Among ( "atori", -1, 5 ),
                    new Among ( "icatori", 18, 4 ),
                    new Among ( "itori", -1, 6 ),
                    new Among ( "\u0103tori", -1, 5 ),
                    new Among ( "icitati", -1, 4 ),
                    new Among ( "abilitati", -1, 1 ),
                    new Among ( "ivitati", -1, 3 ),
                    new Among ( "icivi", -1, 4 ),
                    new Among ( "ativi", -1, 5 ),
                    new Among ( "itivi", -1, 6 ),
                    new Among ( "icit\u0103i", -1, 4 ),
                    new Among ( "abilit\u0103i", -1, 1 ),
                    new Among ( "ivit\u0103i", -1, 3 ),
                    new Among ( "icit\u0103\u0163i", -1, 4 ),
                    new Among ( "abilit\u0103\u0163i", -1, 1 ),
                    new Among ( "ivit\u0103\u0163i", -1, 3 ),
                    new Among ( "ical", -1, 4 ),
                    new Among ( "ator", -1, 5 ),
                    new Among ( "icator", 35, 4 ),
                    new Among ( "itor", -1, 6 ),
                    new Among ( "\u0103tor", -1, 5 ),
                    new Among ( "iciv", -1, 4 ),
                    new Among ( "ativ", -1, 5 ),
                    new Among ( "itiv", -1, 6 ),
                    new Among ( "ical\u0103", -1, 4 ),
                    new Among ( "iciv\u0103", -1, 4 ),
                    new Among ( "ativ\u0103", -1, 5 ),
                    new Among ( "itiv\u0103", -1, 6 )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "ica", -1, 1 ),
                    new Among ( "abila", -1, 1 ),
                    new Among ( "ibila", -1, 1 ),
                    new Among ( "oasa", -1, 1 ),
                    new Among ( "ata", -1, 1 ),
                    new Among ( "ita", -1, 1 ),
                    new Among ( "anta", -1, 1 ),
                    new Among ( "ista", -1, 3 ),
                    new Among ( "uta", -1, 1 ),
                    new Among ( "iva", -1, 1 ),
                    new Among ( "ic", -1, 1 ),
                    new Among ( "ice", -1, 1 ),
                    new Among ( "abile", -1, 1 ),
                    new Among ( "ibile", -1, 1 ),
                    new Among ( "isme", -1, 3 ),
                    new Among ( "iune", -1, 2 ),
                    new Among ( "oase", -1, 1 ),
                    new Among ( "ate", -1, 1 ),
                    new Among ( "itate", 17, 1 ),
                    new Among ( "ite", -1, 1 ),
                    new Among ( "ante", -1, 1 ),
                    new Among ( "iste", -1, 3 ),
                    new Among ( "ute", -1, 1 ),
                    new Among ( "ive", -1, 1 ),
                    new Among ( "ici", -1, 1 ),
                    new Among ( "abili", -1, 1 ),
                    new Among ( "ibili", -1, 1 ),
                    new Among ( "iuni", -1, 2 ),
                    new Among ( "atori", -1, 1 ),
                    new Among ( "osi", -1, 1 ),
                    new Among ( "ati", -1, 1 ),
                    new Among ( "itati", 30, 1 ),
                    new Among ( "iti", -1, 1 ),
                    new Among ( "anti", -1, 1 ),
                    new Among ( "isti", -1, 3 ),
                    new Among ( "uti", -1, 1 ),
                    new Among ( "i\u015Fti", -1, 3 ),
                    new Among ( "ivi", -1, 1 ),
                    new Among ( "it\u0103i", -1, 1 ),
                    new Among ( "o\u015Fi", -1, 1 ),
                    new Among ( "it\u0103\u0163i", -1, 1 ),
                    new Among ( "abil", -1, 1 ),
                    new Among ( "ibil", -1, 1 ),
                    new Among ( "ism", -1, 3 ),
                    new Among ( "ator", -1, 1 ),
                    new Among ( "os", -1, 1 ),
                    new Among ( "at", -1, 1 ),
                    new Among ( "it", -1, 1 ),
                    new Among ( "ant", -1, 1 ),
                    new Among ( "ist", -1, 3 ),
                    new Among ( "ut", -1, 1 ),
                    new Among ( "iv", -1, 1 ),
                    new Among ( "ic\u0103", -1, 1 ),
                    new Among ( "abil\u0103", -1, 1 ),
                    new Among ( "ibil\u0103", -1, 1 ),
                    new Among ( "oas\u0103", -1, 1 ),
                    new Among ( "at\u0103", -1, 1 ),
                    new Among ( "it\u0103", -1, 1 ),
                    new Among ( "ant\u0103", -1, 1 ),
                    new Among ( "ist\u0103", -1, 3 ),
                    new Among ( "ut\u0103", -1, 1 ),
                    new Among ( "iv\u0103", -1, 1 )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "ea", -1, 1 ),
                    new Among ( "ia", -1, 1 ),
                    new Among ( "esc", -1, 1 ),
                    new Among ( "\u0103sc", -1, 1 ),
                    new Among ( "ind", -1, 1 ),
                    new Among ( "\u00E2nd", -1, 1 ),
                    new Among ( "are", -1, 1 ),
                    new Among ( "ere", -1, 1 ),
                    new Among ( "ire", -1, 1 ),
                    new Among ( "\u00E2re", -1, 1 ),
                    new Among ( "se", -1, 2 ),
                    new Among ( "ase", 10, 1 ),
                    new Among ( "sese", 10, 2 ),
                    new Among ( "ise", 10, 1 ),
                    new Among ( "use", 10, 1 ),
                    new Among ( "\u00E2se", 10, 1 ),
                    new Among ( "e\u015Fte", -1, 1 ),
                    new Among ( "\u0103\u015Fte", -1, 1 ),
                    new Among ( "eze", -1, 1 ),
                    new Among ( "ai", -1, 1 ),
                    new Among ( "eai", 19, 1 ),
                    new Among ( "iai", 19, 1 ),
                    new Among ( "sei", -1, 2 ),
                    new Among ( "e\u015Fti", -1, 1 ),
                    new Among ( "\u0103\u015Fti", -1, 1 ),
                    new Among ( "ui", -1, 1 ),
                    new Among ( "ezi", -1, 1 ),
                    new Among ( "\u00E2i", -1, 1 ),
                    new Among ( "a\u015Fi", -1, 1 ),
                    new Among ( "se\u015Fi", -1, 2 ),
                    new Among ( "ase\u015Fi", 29, 1 ),
                    new Among ( "sese\u015Fi", 29, 2 ),
                    new Among ( "ise\u015Fi", 29, 1 ),
                    new Among ( "use\u015Fi", 29, 1 ),
                    new Among ( "\u00E2se\u015Fi", 29, 1 ),
                    new Among ( "i\u015Fi", -1, 1 ),
                    new Among ( "u\u015Fi", -1, 1 ),
                    new Among ( "\u00E2\u015Fi", -1, 1 ),
                    new Among ( "a\u0163i", -1, 2 ),
                    new Among ( "ea\u0163i", 38, 1 ),
                    new Among ( "ia\u0163i", 38, 1 ),
                    new Among ( "e\u0163i", -1, 2 ),
                    new Among ( "i\u0163i", -1, 2 ),
                    new Among ( "\u00E2\u0163i", -1, 2 ),
                    new Among ( "ar\u0103\u0163i", -1, 1 ),
                    new Among ( "ser\u0103\u0163i", -1, 2 ),
                    new Among ( "aser\u0103\u0163i", 45, 1 ),
                    new Among ( "seser\u0103\u0163i", 45, 2 ),
                    new Among ( "iser\u0103\u0163i", 45, 1 ),
                    new Among ( "user\u0103\u0163i", 45, 1 ),
                    new Among ( "\u00E2ser\u0103\u0163i", 45, 1 ),
                    new Among ( "ir\u0103\u0163i", -1, 1 ),
                    new Among ( "ur\u0103\u0163i", -1, 1 ),
                    new Among ( "\u00E2r\u0103\u0163i", -1, 1 ),
                    new Among ( "am", -1, 1 ),
                    new Among ( "eam", 54, 1 ),
                    new Among ( "iam", 54, 1 ),
                    new Among ( "em", -1, 2 ),
                    new Among ( "asem", 57, 1 ),
                    new Among ( "sesem", 57, 2 ),
                    new Among ( "isem", 57, 1 ),
                    new Among ( "usem", 57, 1 ),
                    new Among ( "\u00E2sem", 57, 1 ),
                    new Among ( "im", -1, 2 ),
                    new Among ( "\u00E2m", -1, 2 ),
                    new Among ( "\u0103m", -1, 2 ),
                    new Among ( "ar\u0103m", 65, 1 ),
                    new Among ( "ser\u0103m", 65, 2 ),
                    new Among ( "aser\u0103m", 67, 1 ),
                    new Among ( "seser\u0103m", 67, 2 ),
                    new Among ( "iser\u0103m", 67, 1 ),
                    new Among ( "user\u0103m", 67, 1 ),
                    new Among ( "\u00E2ser\u0103m", 67, 1 ),
                    new Among ( "ir\u0103m", 65, 1 ),
                    new Among ( "ur\u0103m", 65, 1 ),
                    new Among ( "\u00E2r\u0103m", 65, 1 ),
                    new Among ( "au", -1, 1 ),
                    new Among ( "eau", 76, 1 ),
                    new Among ( "iau", 76, 1 ),
                    new Among ( "indu", -1, 1 ),
                    new Among ( "\u00E2ndu", -1, 1 ),
                    new Among ( "ez", -1, 1 ),
                    new Among ( "easc\u0103", -1, 1 ),
                    new Among ( "ar\u0103", -1, 1 ),
                    new Among ( "ser\u0103", -1, 2 ),
                    new Among ( "aser\u0103", 84, 1 ),
                    new Among ( "seser\u0103", 84, 2 ),
                    new Among ( "iser\u0103", 84, 1 ),
                    new Among ( "user\u0103", 84, 1 ),
                    new Among ( "\u00E2ser\u0103", 84, 1 ),
                    new Among ( "ir\u0103", -1, 1 ),
                    new Among ( "ur\u0103", -1, 1 ),
                    new Among ( "\u00E2r\u0103", -1, 1 ),
                    new Among ( "eaz\u0103", -1, 1 )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "a", -1, 1 ),
                    new Among ( "e", -1, 1 ),
                    new Among ( "ie", 1, 1 ),
                    new Among ( "i", -1, 1 ),
                    new Among ( "\u0103", -1, 1 )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)2, (char)32, (char)0, (char)0, (char)4 };

        private bool B_standard_suffix_removed;
        private int I_p2;
        private int I_p1;
        private int I_pV;

        private void copy_from(RomanianStemmer other)
        {
            B_standard_suffix_removed = other.B_standard_suffix_removed;
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_prelude()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 31
            // repeat, line 32
            while (true)
            {
                v_1 = m_cursor;
                do
                {
                    // goto, line 32
                    while (true)
                    {
                        v_2 = m_cursor;
                        do
                        {
                            // (, line 32
                            if (!(InGrouping(g_v, 97, 259)))
                            {
                                goto lab3;
                            }
                            // [, line 33
                            m_bra = m_cursor;
                            // or, line 33
                            do
                            {
                                v_3 = m_cursor;
                                do
                                {
                                    // (, line 33
                                    // literal, line 33
                                    if (!(Eq_S(1, "u")))
                                    {
                                        goto lab5;
                                    }
                                    // ], line 33
                                    m_ket = m_cursor;
                                    if (!(InGrouping(g_v, 97, 259)))
                                    {
                                        goto lab5;
                                    }
                                    // <-, line 33
                                    SliceFrom("U");
                                    goto lab4;
                                } while (false);
                                lab5:
                                m_cursor = v_3;
                                // (, line 34
                                // literal, line 34
                                if (!(Eq_S(1, "i")))
                                {
                                    goto lab3;
                                }
                                // ], line 34
                                m_ket = m_cursor;
                                if (!(InGrouping(g_v, 97, 259)))
                                {
                                    goto lab3;
                                }
                                // <-, line 34
                                SliceFrom("I");
                            } while (false);
                            lab4:
                            m_cursor = v_2;
                            goto golab2;
                        } while (false);
                        lab3:
                        m_cursor = v_2;
                        if (m_cursor >= m_limit)
                        {
                            goto lab1;
                        }
                        m_cursor++;
                    }
                    golab2:
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_6;
            int v_8;
            // (, line 38
            I_pV = m_limit;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 44
            v_1 = m_cursor;
            do
            {
                // (, line 44
                // or, line 46
                do
                {
                    v_2 = m_cursor;
                    do
                    {
                        // (, line 45
                        if (!(InGrouping(g_v, 97, 259)))
                        {
                            goto lab2;
                        }
                        // or, line 45
                        do
                        {
                            v_3 = m_cursor;
                            do
                            {
                                // (, line 45
                                if (!(OutGrouping(g_v, 97, 259)))
                                {
                                    goto lab4;
                                }
                                // gopast, line 45
                                while (true)
                                {
                                    do
                                    {
                                        if (!(InGrouping(g_v, 97, 259)))
                                        {
                                            goto lab6;
                                        }
                                        goto golab5;
                                    } while (false);
                                    lab6:
                                    if (m_cursor >= m_limit)
                                    {
                                        goto lab4;
                                    }
                                    m_cursor++;
                                }
                                golab5:
                                goto lab3;
                            } while (false);
                            lab4:
                            m_cursor = v_3;
                            // (, line 45
                            if (!(InGrouping(g_v, 97, 259)))
                            {
                                goto lab2;
                            }
                            // gopast, line 45
                            while (true)
                            {
                                do
                                {
                                    if (!(OutGrouping(g_v, 97, 259)))
                                    {
                                        goto lab8;
                                    }
                                    goto golab7;
                                } while (false);
                                lab8:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab2;
                                }
                                m_cursor++;
                            }
                            golab7: {/* LUCENENET: intentionally blank */}
                        } while (false);
                        lab3:
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;
                    // (, line 47
                    if (!(OutGrouping(g_v, 97, 259)))
                    {
                        goto lab0;
                    }
                    // or, line 47
                    do
                    {
                        v_6 = m_cursor;
                        do
                        {
                            // (, line 47
                            if (!(OutGrouping(g_v, 97, 259)))
                            {
                                goto lab10;
                            }
                            // gopast, line 47
                            while (true)
                            {
                                do
                                {
                                    if (!(InGrouping(g_v, 97, 259)))
                                    {
                                        goto lab12;
                                    }
                                    goto golab11;
                                } while (false);
                                lab12:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab10;
                                }
                                m_cursor++;
                            }
                            golab11:
                            goto lab9;
                        } while (false);
                        lab10:
                        m_cursor = v_6;
                        // (, line 47
                        if (!(InGrouping(g_v, 97, 259)))
                        {
                            goto lab0;
                        }
                        // next, line 47
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    } while (false);
                    lab9: {/* LUCENENET: intentionally blank */}
                } while (false);
                lab1:
                // setmark pV, line 48
                I_pV = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 50
            v_8 = m_cursor;
            do
            {
                // (, line 50
                // gopast, line 51
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 259)))
                        {
                            goto lab15;
                        }
                        goto golab14;
                    } while (false);
                    lab15:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab14:
                // gopast, line 51
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 259)))
                        {
                            goto lab17;
                        }
                        goto golab16;
                    } while (false);
                    lab17:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab16:
                // setmark p1, line 51
                I_p1 = m_cursor;
                // gopast, line 52
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 259)))
                        {
                            goto lab19;
                        }
                        goto golab18;
                    } while (false);
                    lab19:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab18:
                // gopast, line 52
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 259)))
                        {
                            goto lab21;
                        }
                        goto golab20;
                    } while (false);
                    lab21:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab20:
                // setmark p2, line 52
                I_p2 = m_cursor;
            } while (false);
            lab13:
            m_cursor = v_8;
            return true;
        }

        private bool r_postlude()
        {
            int among_var;
            int v_1;
            // repeat, line 56
            while (true)
            {
                v_1 = m_cursor;
                do
                {
                    // (, line 56
                    // [, line 58
                    m_bra = m_cursor;
                    // substring, line 58
                    among_var = FindAmong(a_0, 3);
                    if (among_var == 0)
                    {
                        goto lab1;
                    }
                    // ], line 58
                    m_ket = m_cursor;
                    switch (among_var)
                    {
                        case 0:
                            goto lab1;
                        case 1:
                            // (, line 59
                            // <-, line 59
                            SliceFrom("i");
                            break;
                        case 2:
                            // (, line 60
                            // <-, line 60
                            SliceFrom("u");
                            break;
                        case 3:
                            // (, line 61
                            // next, line 61
                            if (m_cursor >= m_limit)
                            {
                                goto lab1;
                            }
                            m_cursor++;
                            break;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        private bool r_RV()
        {
            if (!(I_pV <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_step_0()
        {
            int among_var;
            int v_1;
            // (, line 72
            // [, line 73
            m_ket = m_cursor;
            // substring, line 73
            among_var = FindAmongB(a_1, 16);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 73
            m_bra = m_cursor;
            // call R1, line 73
            if (!r_R1())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 75
                    // delete, line 75
                    SliceDel();
                    break;
                case 2:
                    // (, line 77
                    // <-, line 77
                    SliceFrom("a");
                    break;
                case 3:
                    // (, line 79
                    // <-, line 79
                    SliceFrom("e");
                    break;
                case 4:
                    // (, line 81
                    // <-, line 81
                    SliceFrom("i");
                    break;
                case 5:
                    // (, line 83
                    // not, line 83
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 83
                            if (!(Eq_S_B(2, "ab")))
                            {
                                goto lab0;
                            }
                            return false;
                        } while (false);
                        lab0:
                        m_cursor = m_limit - v_1;
                    }
                    // <-, line 83
                    SliceFrom("i");
                    break;
                case 6:
                    // (, line 85
                    // <-, line 85
                    SliceFrom("at");
                    break;
                case 7:
                    // (, line 87
                    // <-, line 87
                    SliceFrom("a\u0163i");
                    break;
            }
            return true;
        }

        private bool r_combo_suffix()
        {
            int among_var;
            int v_1;
            // test, line 91
            v_1 = m_limit - m_cursor;
            // (, line 91
            // [, line 92
            m_ket = m_cursor;
            // substring, line 92
            among_var = FindAmongB(a_2, 46);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 92
            m_bra = m_cursor;
            // call R1, line 92
            if (!r_R1())
            {
                return false;
            }
            // (, line 92
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 100
                    // <-, line 101
                    SliceFrom("abil");
                    break;
                case 2:
                    // (, line 103
                    // <-, line 104
                    SliceFrom("ibil");
                    break;
                case 3:
                    // (, line 106
                    // <-, line 107
                    SliceFrom("iv");
                    break;
                case 4:
                    // (, line 112
                    // <-, line 113
                    SliceFrom("ic");
                    break;
                case 5:
                    // (, line 117
                    // <-, line 118
                    SliceFrom("at");
                    break;
                case 6:
                    // (, line 121
                    // <-, line 122
                    SliceFrom("it");
                    break;
            }
            // set standard_suffix_removed, line 125
            B_standard_suffix_removed = true;
            m_cursor = m_limit - v_1;
            return true;
        }

        private bool r_standard_suffix()
        {
            int among_var;
            int v_1;
            // (, line 129
            // unset standard_suffix_removed, line 130
            B_standard_suffix_removed = false;
            // repeat, line 131
            while (true)
            {
                v_1 = m_limit - m_cursor;
                do
                {
                    // call combo_suffix, line 131
                    if (!r_combo_suffix())
                    {
                        goto lab1;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = m_limit - v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            // [, line 132
            m_ket = m_cursor;
            // substring, line 132
            among_var = FindAmongB(a_3, 62);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 132
            m_bra = m_cursor;
            // call R2, line 132
            if (!r_R2())
            {
                return false;
            }
            // (, line 132
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 148
                    // delete, line 149
                    SliceDel();
                    break;
                case 2:
                    // (, line 151
                    // literal, line 152
                    if (!(Eq_S_B(1, "\u0163")))
                    {
                        return false;
                    }
                    // ], line 152
                    m_bra = m_cursor;
                    // <-, line 152
                    SliceFrom("t");
                    break;
                case 3:
                    // (, line 155
                    // <-, line 156
                    SliceFrom("ist");
                    break;
            }
            // set standard_suffix_removed, line 160
            B_standard_suffix_removed = true;
            return true;
        }

        private bool r_verb_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            // setlimit, line 164
            v_1 = m_limit - m_cursor;
            // tomark, line 164
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 164
            // [, line 165
            m_ket = m_cursor;
            // substring, line 165
            among_var = FindAmongB(a_4, 94);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 165
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    m_limit_backward = v_2;
                    return false;
                case 1:
                    // (, line 200
                    // or, line 200
                    do
                    {
                        v_3 = m_limit - m_cursor;
                        do
                        {
                            if (!(OutGroupingB(g_v, 97, 259)))
                            {
                                goto lab1;
                            }
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_3;
                        // literal, line 200
                        if (!(Eq_S_B(1, "u")))
                        {
                            m_limit_backward = v_2;
                            return false;
                        }
                    } while (false);
                    lab0:
                    // delete, line 200
                    SliceDel();
                    break;
                case 2:
                    // (, line 214
                    // delete, line 214
                    SliceDel();
                    break;
            }
            m_limit_backward = v_2;
            return true;
        }

        private bool r_vowel_suffix()
        {
            int among_var;
            // (, line 218
            // [, line 219
            m_ket = m_cursor;
            // substring, line 219
            among_var = FindAmongB(a_5, 5);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 219
            m_bra = m_cursor;
            // call RV, line 219
            if (!r_RV())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 220
                    // delete, line 220
                    SliceDel();
                    break;
            }
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            // (, line 225
            // do, line 226
            v_1 = m_cursor;
            do
            {
                // call prelude, line 226
                if (!r_prelude())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 227
            v_2 = m_cursor;
            do
            {
                // call mark_regions, line 227
                if (!r_mark_regions())
                {
                    goto lab1;
                }
            } while (false);
            lab1:
            m_cursor = v_2;
            // backwards, line 228
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 228
            // do, line 229
            v_3 = m_limit - m_cursor;
            do
            {
                // call step_0, line 229
                if (!r_step_0())
                {
                    goto lab2;
                }
            } while (false);
            lab2:
            m_cursor = m_limit - v_3;
            // do, line 230
            v_4 = m_limit - m_cursor;
            do
            {
                // call standard_suffix, line 230
                if (!r_standard_suffix())
                {
                    goto lab3;
                }
            } while (false);
            lab3:
            m_cursor = m_limit - v_4;
            // do, line 231
            v_5 = m_limit - m_cursor;
            do
            {
                // (, line 231
                // or, line 231
                do
                {
                    v_6 = m_limit - m_cursor;
                    do
                    {
                        // Boolean test standard_suffix_removed, line 231
                        if (!(B_standard_suffix_removed))
                        {
                            goto lab6;
                        }
                        goto lab5;
                    } while (false);
                    lab6:
                    m_cursor = m_limit - v_6;
                    // call verb_suffix, line 231
                    if (!r_verb_suffix())
                    {
                        goto lab4;
                    }
                } while (false);
                lab5: {/* LUCENENET: intentionally blank */}
            } while (false);
            lab4:
            m_cursor = m_limit - v_5;
            // do, line 232
            v_7 = m_limit - m_cursor;
            do
            {
                // call vowel_suffix, line 232
                if (!r_vowel_suffix())
                {
                    goto lab7;
                }
            } while (false);
            lab7:
            m_cursor = m_limit - v_7;
            m_cursor = m_limit_backward;                    // do, line 234
            v_8 = m_cursor;
            do
            {
                // call postlude, line 234
                if (!r_postlude())
                {
                    goto lab8;
                }
            } while (false);
            lab8:
            m_cursor = v_8;
            return true;
        }


        public override bool Equals(object o)
        {
            return o is RomanianStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}