/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.core.fuzzyml.ByteBuffer;
import org.apache.manifoldcf.core.fuzzyml.ByteReceiver;
import org.apache.manifoldcf.core.fuzzyml.EncodingDetector;
import org.apache.manifoldcf.core.fuzzyml.PrefixedInputStream;
import org.apache.manifoldcf.core.fuzzyml.SingleByteReceiver;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class BOMEncodingDetector
extends SingleByteReceiver
implements EncodingDetector {
    protected String encoding = null;
    protected final ByteReceiver overflowByteReceiver;
    protected ByteBuffer replayBuffer = new ByteBuffer();
    protected static final int BOM_NOTHINGYET = 0;
    protected static final int BOM_SEEN_EF = 1;
    protected static final int BOM_SEEN_FF = 2;
    protected static final int BOM_SEEN_FE = 3;
    protected static final int BOM_SEEN_ZERO = 4;
    protected static final int BOM_SEEN_EFBB = 5;
    protected static final int BOM_SEEN_FFFE = 6;
    protected static final int BOM_SEEN_0000 = 7;
    protected static final int BOM_SEEN_FFFE00 = 8;
    protected static final int BOM_SEEN_0000FE = 9;
    protected int currentState = 0;

    public BOMEncodingDetector(ByteReceiver overflowByteReceiver) {
        super(8);
        this.overflowByteReceiver = overflowByteReceiver;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean dealWithByte(byte b) throws ManifoldCFException {
        this.replayBuffer.appendByte(b);
        int theByte = 0xFF & b;
        switch (this.currentState) {
            case 0: {
                if (theByte == 239) {
                    this.currentState = 1;
                    break;
                }
                if (theByte == 255) {
                    this.currentState = 2;
                    break;
                }
                if (theByte == 254) {
                    this.currentState = 3;
                    break;
                }
                if (theByte == 0) {
                    this.currentState = 4;
                    break;
                }
                return this.replay();
            }
            case 1: {
                if (theByte == 187) {
                    this.currentState = 5;
                    break;
                }
                return this.replay();
            }
            case 2: {
                if (theByte == 254) {
                    this.mark();
                    this.currentState = 6;
                    break;
                }
                return this.replay();
            }
            case 3: {
                if (theByte == 255) {
                    this.mark();
                    return this.establishEncoding("UTF-16BE");
                }
                return this.replay();
            }
            case 4: {
                if (theByte == 0) {
                    this.currentState = 7;
                    break;
                }
                return this.replay();
            }
            case 5: {
                if (theByte == 191) {
                    this.mark();
                    return this.establishEncoding(StandardCharsets.UTF_8.name());
                }
                return this.replay();
            }
            case 6: {
                if (theByte == 0) {
                    this.currentState = 8;
                    break;
                }
                return this.establishEncoding(StandardCharsets.UTF_16LE.name());
            }
            case 7: {
                if (theByte == 254) {
                    this.currentState = 9;
                    break;
                }
                return this.replay();
            }
            case 8: {
                if (theByte == 0) {
                    this.mark();
                    return this.establishEncoding("UTF-32LE");
                }
                return this.establishEncoding(StandardCharsets.UTF_16LE.name());
            }
            case 9: {
                if (theByte == 255) {
                    this.mark();
                    return this.establishEncoding("UTF-32BE");
                }
                return this.replay();
            }
            default: {
                throw new ManifoldCFException("Unknown state: " + this.currentState);
            }
        }
        return false;
    }

    protected boolean establishEncoding(String encoding) throws ManifoldCFException {
        this.setEncoding(encoding);
        return true;
    }

    protected void mark() {
        this.replayBuffer.clear();
    }

    protected boolean replay() throws ManifoldCFException {
        return true;
    }

    protected boolean playFromCurrentPoint() throws ManifoldCFException {
        this.mark();
        return true;
    }

    @Override
    protected boolean dealWithRemainder(byte[] buffer, int offset, int len, InputStream inputStream) throws IOException, ManifoldCFException {
        if (this.overflowByteReceiver == null) {
            return super.dealWithRemainder(buffer, offset, len, inputStream);
        }
        while (len > 0) {
            this.replayBuffer.appendByte(buffer[offset++]);
            --len;
        }
        return this.overflowByteReceiver.dealWithBytes(new PrefixedInputStream(this.replayBuffer, inputStream));
    }
}

