/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.util.Map;
import org.apache.manifoldcf.core.fuzzyml.XMLFuzzyHierarchicalParseState;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class XMLParsingContext {
    protected final XMLFuzzyHierarchicalParseState theStream;
    protected final XMLParsingContext previousContext;
    protected final Map<String, String> theseAttributes;
    protected final String namespace;
    protected final String localname;
    protected final String qname;

    public XMLParsingContext(XMLFuzzyHierarchicalParseState theStream) {
        this(theStream, null, null, null, null);
    }

    public XMLParsingContext(XMLFuzzyHierarchicalParseState theStream, String namespace, String localname, String qname, Map<String, String> theseAttributes) {
        this.theStream = theStream;
        this.previousContext = theStream.getContext();
        this.namespace = namespace;
        this.localname = localname;
        this.qname = qname;
        this.theseAttributes = theseAttributes;
    }

    public String getAttribute(String attributeName) {
        if (this.theseAttributes != null) {
            return this.theseAttributes.get(attributeName);
        }
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalname() {
        return this.localname;
    }

    public String getQname() {
        return this.qname;
    }

    public final void startElement(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
        XMLParsingContext newContext = this.beginTag(namespace, localName, qName, atts);
        if (newContext == null) {
            newContext = new XMLParsingContext(this.theStream, namespace, localName, qName, atts);
        }
        this.theStream.setContext(newContext);
    }

    public final void endElement(String namespace, String localName, String qName) throws ManifoldCFException {
        if (this.previousContext != null) {
            this.previousContext.endTag();
        }
        this.theStream.getContext().tagCleanup();
        this.theStream.setContext(this.previousContext);
    }

    public final void characters(String contents) throws ManifoldCFException {
        this.tagContents(contents);
    }

    public final void cleanup() throws ManifoldCFException {
        this.tagCleanup();
        this.theStream.setContext(this.previousContext);
    }

    protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
        return null;
    }

    protected void endTag() throws ManifoldCFException {
    }

    protected void tagContents(String contents) throws ManifoldCFException {
    }

    protected void tagCleanup() throws ManifoldCFException {
    }
}

