/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.shortcircuit.DomainSocketFactory;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.util.ByteArrayManager;

@InterfaceAudience.Private
public class ClientContext {
    private static final Log LOG = LogFactory.getLog(ClientContext.class);
    private static final HashMap<String, ClientContext> CACHES = new HashMap();
    private final String name;
    private final String confString;
    private final ShortCircuitCache shortCircuitCache;
    private final PeerCache peerCache;
    private final DomainSocketFactory domainSocketFactory;
    private final boolean useLegacyBlockReaderLocal;
    private volatile boolean disableLegacyBlockReaderLocal = false;
    private final ByteArrayManager byteArrayManager;
    private boolean printedConfWarning = false;

    private ClientContext(String name, DFSClient.Conf conf) {
        this.name = name;
        this.confString = ClientContext.confAsString(conf);
        this.shortCircuitCache = new ShortCircuitCache(conf.shortCircuitStreamsCacheSize, conf.shortCircuitStreamsCacheExpiryMs, conf.shortCircuitMmapCacheSize, conf.shortCircuitMmapCacheExpiryMs, conf.shortCircuitMmapCacheRetryTimeout, conf.shortCircuitCacheStaleThresholdMs, conf.shortCircuitSharedMemoryWatcherInterruptCheckMs);
        this.peerCache = new PeerCache(conf.socketCacheCapacity, conf.socketCacheExpiry);
        this.useLegacyBlockReaderLocal = conf.useLegacyBlockReaderLocal;
        this.domainSocketFactory = new DomainSocketFactory(conf);
        this.byteArrayManager = ByteArrayManager.newInstance(conf.writeByteArrayManagerConf);
    }

    public static String confAsString(DFSClient.Conf conf) {
        StringBuilder builder = new StringBuilder();
        builder.append("shortCircuitStreamsCacheSize = ").append(conf.shortCircuitStreamsCacheSize).append(", shortCircuitStreamsCacheExpiryMs = ").append(conf.shortCircuitStreamsCacheExpiryMs).append(", shortCircuitMmapCacheSize = ").append(conf.shortCircuitMmapCacheSize).append(", shortCircuitMmapCacheExpiryMs = ").append(conf.shortCircuitMmapCacheExpiryMs).append(", shortCircuitMmapCacheRetryTimeout = ").append(conf.shortCircuitMmapCacheRetryTimeout).append(", shortCircuitCacheStaleThresholdMs = ").append(conf.shortCircuitCacheStaleThresholdMs).append(", socketCacheCapacity = ").append(conf.socketCacheCapacity).append(", socketCacheExpiry = ").append(conf.socketCacheExpiry).append(", shortCircuitLocalReads = ").append(conf.shortCircuitLocalReads).append(", useLegacyBlockReaderLocal = ").append(conf.useLegacyBlockReaderLocal).append(", domainSocketDataTraffic = ").append(conf.domainSocketDataTraffic).append(", shortCircuitSharedMemoryWatcherInterruptCheckMs = ").append(conf.shortCircuitSharedMemoryWatcherInterruptCheckMs);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientContext get(String name, DFSClient.Conf conf) {
        Class<ClientContext> clazz = ClientContext.class;
        synchronized (ClientContext.class) {
            ClientContext context = CACHES.get(name);
            if (context == null) {
                context = new ClientContext(name, conf);
                CACHES.put(name, context);
            } else {
                context.printConfWarningIfNeeded(conf);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return context;
        }
    }

    @VisibleForTesting
    public static ClientContext getFromConf(Configuration conf) {
        return ClientContext.get(conf.get("dfs.client.context", "default"), new DFSClient.Conf(conf));
    }

    private void printConfWarningIfNeeded(DFSClient.Conf conf) {
        String requested;
        String existing = this.getConfString();
        if (!existing.equals(requested = ClientContext.confAsString(conf)) && !this.printedConfWarning) {
            this.printedConfWarning = true;
            LOG.warn((Object)("Existing client context '" + this.name + "' does not match " + "requested configuration.  Existing: " + existing + ", Requested: " + requested));
        }
    }

    public String getConfString() {
        return this.confString;
    }

    public ShortCircuitCache getShortCircuitCache() {
        return this.shortCircuitCache;
    }

    public PeerCache getPeerCache() {
        return this.peerCache;
    }

    public boolean getUseLegacyBlockReaderLocal() {
        return this.useLegacyBlockReaderLocal;
    }

    public boolean getDisableLegacyBlockReaderLocal() {
        return this.disableLegacyBlockReaderLocal;
    }

    public void setDisableLegacyBlockReaderLocal() {
        this.disableLegacyBlockReaderLocal = true;
    }

    public DomainSocketFactory getDomainSocketFactory() {
        return this.domainSocketFactory;
    }

    public ByteArrayManager getByteArrayManager() {
        return this.byteArrayManager;
    }
}

