/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.extmimemap.ExtensionMimeMap;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.filesystem.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;

public class FileConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: FileConnector.java 995085 2010-09-08 15:13:38Z kwright $";
    protected static final String ACTIVITY_READ = "read document";
    protected static final String RELATIONSHIP_CHILD = "child";
    protected static final String[] activitiesList = new String[]{"read document"};

    public int getConnectorModel() {
        return 10;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{""};
    }

    protected static String convertToWGETURI(String path) throws ManifoldCFException {
        try {
            StringBuffer sb = new StringBuffer();
            String[] tmp = path.split("/", 3);
            String scheme = "";
            String host = "";
            String other = "";
            scheme = tmp.length >= 1 ? tmp[0] : "http";
            host = tmp.length >= 2 ? tmp[1] : "localhost";
            other = tmp.length >= 3 ? "/" + tmp[2] : "/";
            return new URI(scheme + "://" + host + other).toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad url: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ManifoldCFException("Bad url: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static String convertToURI(String documentIdentifier) throws ManifoldCFException {
        try {
            return new File(documentIdentifier).toURI().toURL().toString();
        }
        catch (IOException e) {
            throw new ManifoldCFException("Bad url", (Throwable)e);
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        try {
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode n = spec.getChild(i);
                if (!n.getType().equals("startpoint")) continue;
                String seed = new File(n.getAttributeValue("path")).getCanonicalPath();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Seed = '" + seed + "'"));
                }
                activities.addSeedDocument(seed);
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("Could not get a canonical path: " + e.getMessage(), (Throwable)e);
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 32[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static String findConvertPath(Specification spec, File theFile) {
        String fullpath = theFile.getAbsolutePath().replaceAll("\\\\", "/");
        for (int j = 0; j < spec.getChildCount(); ++j) {
            SpecificationNode sn = spec.getChild(j);
            if (!sn.getType().equals("startpoint")) continue;
            String path = sn.getAttributeValue("path").replaceAll("\\\\", "/");
            String convertToURI = sn.getAttributeValue("converttouri");
            if (path.length() <= 0 || convertToURI == null || !convertToURI.equals("true")) continue;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!fullpath.startsWith(path)) continue;
            return fullpath.substring(path.length());
        }
        return null;
    }

    protected static String mapExtensionToMimeType(String fileName) {
        int dotIndex;
        int slashIndex = fileName.lastIndexOf("/");
        if (slashIndex != -1) {
            fileName = fileName.substring(slashIndex + 1);
        }
        if ((dotIndex = fileName.lastIndexOf(".")) == -1) {
            return null;
        }
        return ExtensionMimeMap.mapToMimeType((String)fileName.substring(dotIndex + 1).toLowerCase(Locale.ROOT));
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "FileConnector.Paths"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n" + "{\n" + "  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n" + "  postFormSetAnchor(anchorvalue);\n" + "}\n" + "//-->\n" + "</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (tabName.equals(Messages.getString(locale, "FileConnector.Paths")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"3\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FileConnector.Paths2") + "</nobr></td>\n" + "    <td class=\"boxcell\">\n" + "      <table class=\"formtable\">\n" + "        <tr class=\"formheaderrow\">\n" + "          <td class=\"formcolumnheader\"></td>\n" + "          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.RootPath") + "</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.ConvertToURI") + "<br/>" + Messages.getBodyString(locale, "FileConnector.ConvertToURIExample") + "</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.Rules") + "</nobr></td>\n" + "        </tr>\n");
            int i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                int j;
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
                String pathDescription = "_" + Integer.toString(k);
                String pathOpName = seqPrefix + "specop" + pathDescription;
                String path = sn.getAttributeValue("path");
                String convertToURIString = sn.getAttributeValue("converttouri");
                boolean convertToURI = false;
                if (convertToURIString != null && convertToURIString.equals("true")) {
                    convertToURI = true;
                }
                out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <input type=\"hidden\" name=\"" + pathOpName + "\" value=\"\"/>\n" + "            <input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)sn.getAttributeValue("path")) + "\"/>\n" + "            <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n" + "              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FileConnector.Delete") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Delete\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "FileConnector.DeletePath") + Integer.toString(k) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              " + Encoder.bodyEscape((String)path) + " \n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <input type=\"hidden\" name=\"" + seqPrefix + "converttouri" + pathDescription + "\" value=\"" + (convertToURI ? "true" : "false") + "\">\n" + "            <nobr>\n" + "              " + (convertToURI ? Messages.getBodyString(locale, "FileConnector.Yes") : Messages.getBodyString(locale, "FileConnector.No")) + " \n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"boxcell\">\n" + "            <input type=\"hidden\" name=\"" + seqPrefix + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(sn.getChildCount()) + "\"/>\n" + "            <table class=\"formtable\">\n" + "              <tr class=\"formheaderrow\">\n" + "                <td class=\"formcolumnheader\"></td>\n" + "                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.IncludeExclude") + "</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.FileDirectory") + "</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.Match") + "</nobr></td>\n" + "              </tr>\n");
                for (j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String instanceOpName = seqPrefix + "specop" + instanceDescription;
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue("type");
                    String nodeMatch = excludeNode.getAttributeValue("match");
                    out.print("              <tr class=\"evenformrow\">\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FileConnector.InsertHere") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + instanceOpName + "\",\"Insert Here\",\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "FileConnector.InsertNewMatchForPath") + Integer.toString(k) + " before position #" + Integer.toString(j) + "\"/>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + seqPrefix + "specflavor" + instanceDescription + "\">\n" + "                      <option value=\"include\">" + Messages.getBodyString(locale, "FileConnector.include") + "</option>\n" + "                      <option value=\"exclude\">" + Messages.getBodyString(locale, "FileConnector.exclude") + "</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + seqPrefix + "spectype" + instanceDescription + "\">\n" + "                      <option value=\"file\">" + Messages.getBodyString(locale, "FileConnector.File") + "</option>\n" + "                      <option value=\"directory\">" + Messages.getBodyString(locale, "FileConnector.Directory") + "</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <input type=\"text\" size=\"10\" name=\"" + seqPrefix + "specmatch" + instanceDescription + "\" value=\"\"/>\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n" + "              <tr class=\"oddformrow\">\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <input type=\"hidden\" name=\"" + instanceOpName + "\" value=\"\"/>\n" + "                    <input type=\"hidden\" name=\"" + seqPrefix + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n" + "                    <input type=\"hidden\" name=\"" + seqPrefix + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n" + "                    <input type=\"hidden\" name=\"" + seqPrefix + "specma" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)nodeMatch) + "\"/>\n" + "                    <a name=\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n" + "                      <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FileConnector.Delete") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + instanceOpName + "\",\"Delete\",\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\")' alt=\"" + Messages.getAttributeString(locale, "FileConnector.DeletePath") + Integer.toString(k) + ", match spec #" + Integer.toString(j) + "\"/>\n" + "                    </a>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + nodeFlavor + "\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + nodeType + "\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + Encoder.bodyEscape((String)nodeMatch) + "\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n");
                }
                if (j == 0) {
                    out.print("              <tr class=\"formrow\"><td class=\"formcolumnmessage\" colspan=\"4\">" + Messages.getBodyString(locale, "FileConnector.NoRulesDefined") + "</td></tr>\n");
                }
                out.print("              <tr class=\"formrow\"><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n              <tr class=\"formrow\">\n                <td class=\"formcolumncell\">\n                  <a name=\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n" + "                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FileConnector.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Add\",\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "FileConnector.AddNewMatchForPath") + Integer.toString(k) + "\"/>\n" + "                  </a>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + seqPrefix + "specflavor" + pathDescription + "\">\n" + "                      <option value=\"include\">" + Messages.getBodyString(locale, "FileConnector.include") + "</option>\n" + "                      <option value=\"exclude\">" + Messages.getBodyString(locale, "FileConnector.exclude") + "</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <select name=\"" + seqPrefix + "spectype" + pathDescription + "\">\n" + "                      <option value=\"file\">" + Messages.getBodyString(locale, "FileConnector.File") + "</option>\n" + "                      <option value=\"directory\">" + Messages.getBodyString(locale, "FileConnector.Directory") + "</option>\n" + "                    </select>\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    <input type=\"text\" size=\"10\" name=\"" + seqPrefix + "specmatch" + pathDescription + "\" value=\"\"/>\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n" + "            </table>\n" + "          </td>\n" + "        </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formcolumnmessage\" colspan=\"4\">" + Messages.getBodyString(locale, "FileConnector.NoDocumentsSpecified") + "</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n" + "                <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FileConnector.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specop\",\"Add\",\"" + seqPrefix + "path_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "FileConnector.AddNewPath") + "\"/>\n" + "                <input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n" + "                <input type=\"hidden\" name=\"" + seqPrefix + "specop\" value=\"\"/>\n" + "              </a>\n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "specpath\" value=\"\"/>\n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              <input name=\"" + seqPrefix + "converttouri\" type=\"checkbox\" value=\"true\"/>\n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            int i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
                String pathDescription = "_" + Integer.toString(k);
                String path = sn.getAttributeValue("path");
                String convertToURIString = sn.getAttributeValue("converttouri");
                boolean convertToURI = false;
                if (convertToURIString != null && convertToURIString.equals("true")) {
                    convertToURI = true;
                }
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)path) + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "converttouri" + pathDescription + "\" value=\"" + (convertToURI ? "true" : "false") + "\">\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(sn.getChildCount()) + "\"/>\n");
                for (int j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue("type");
                    String nodeMatch = excludeNode.getAttributeValue("match");
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "specma" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)nodeMatch) + "\"/>\n");
                }
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "pathcount");
        if (x != null) {
            ds.clearChildren();
            int pathCount = Integer.parseInt(x);
            int i = 0;
            int k = 0;
            while (i < pathCount) {
                String pathDescription = "_" + Integer.toString(i);
                String pathOpName = seqPrefix + "specop" + pathDescription;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path = variableContext.getParameter(seqPrefix + "specpath" + pathDescription);
                String convertToURI = variableContext.getParameter(seqPrefix + "converttouri" + pathDescription);
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path);
                if (convertToURI != null) {
                    node.setAttribute("converttouri", convertToURI);
                }
                String y = variableContext.getParameter(seqPrefix + "specchildcount" + pathDescription);
                int childCount = Integer.parseInt(y);
                int j = 0;
                int w = 0;
                while (j < childCount) {
                    SpecificationNode sn;
                    String match;
                    String type;
                    String flavor;
                    String instanceDescription = "_" + Integer.toString(i) + "_" + Integer.toString(j);
                    String instanceOp = seqPrefix + "specop" + instanceDescription;
                    String z = variableContext.getParameter(instanceOp);
                    if (z != null && z.equals("Delete")) {
                        ++j;
                        continue;
                    }
                    if (z != null && z.equals("Insert Here")) {
                        flavor = variableContext.getParameter(seqPrefix + "specflavor" + instanceDescription);
                        type = variableContext.getParameter(seqPrefix + "spectype" + instanceDescription);
                        match = variableContext.getParameter(seqPrefix + "specmatch" + instanceDescription);
                        sn = new SpecificationNode(flavor);
                        sn.setAttribute("type", type);
                        sn.setAttribute("match", match);
                        node.addChild(w++, (ConfigurationNode)sn);
                    }
                    flavor = variableContext.getParameter(seqPrefix + "specfl" + instanceDescription);
                    type = variableContext.getParameter(seqPrefix + "specty" + instanceDescription);
                    match = variableContext.getParameter(seqPrefix + "specma" + instanceDescription);
                    sn = new SpecificationNode(flavor);
                    sn.setAttribute("type", type);
                    sn.setAttribute("match", match);
                    node.addChild(w++, (ConfigurationNode)sn);
                    ++j;
                }
                if (x != null && x.equals("Add")) {
                    String match = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription);
                    String type = variableContext.getParameter(seqPrefix + "spectype" + pathDescription);
                    String flavor = variableContext.getParameter(seqPrefix + "specflavor" + pathDescription);
                    SpecificationNode sn = new SpecificationNode(flavor);
                    sn.setAttribute("type", type);
                    sn.setAttribute("match", match);
                    node.addChild(w, (ConfigurationNode)sn);
                }
                ds.addChild(k++, (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "specop");
            if (op != null && op.equals("Add")) {
                String path = variableContext.getParameter(seqPrefix + "specpath");
                String convertToURI = variableContext.getParameter(seqPrefix + "converttouri");
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path);
                if (convertToURI != null) {
                    node.setAttribute("converttouri", convertToURI);
                }
                SpecificationNode sn = new SpecificationNode("include");
                sn.setAttribute("type", "file");
                sn.setAttribute("match", "*");
                node.addChild(node.getChildCount(), (ConfigurationNode)sn);
                sn = new SpecificationNode("include");
                sn.setAttribute("type", "directory");
                sn.setAttribute("match", "*");
                node.addChild(node.getChildCount(), (ConfigurationNode)sn);
                ds.addChild(k, (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\">" + Messages.getAttributeString(locale, "FileConnector.Paths2") + "</td>\n" + "    <td class=\"boxcell\">\n" + "      <table class=\"formtable\">\n" + "        <tr class=\"formheaderrow\">\n" + "          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.RootPath") + "</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.ConvertToURI") + "<br/>" + Messages.getBodyString(locale, "FileConnector.ConvertToURIExample") + "</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.Rules") + "</nobr></td>\n" + "        </tr>\n");
        int k = 0;
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals("startpoint")) continue;
            String path = sn.getAttributeValue("path");
            String convertToURIString = sn.getAttributeValue("converttouri");
            boolean convertToURI = false;
            if (convertToURIString != null && convertToURIString.equals("true")) {
                convertToURI = true;
            }
            out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              " + Encoder.bodyEscape((String)path) + " \n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>\n" + "              " + (convertToURI ? Messages.getBodyString(locale, "FileConnector.Yes") : Messages.getBodyString(locale, "FileConnector.No")) + " \n" + "            </nobr>\n" + "          </td>\n" + "          <td class=\"boxcell\">\n" + "            <table class=\"formtable\">\n" + "              <tr class=\"formheaderrow\">\n" + "                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.IncludeExclude") + "</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.FileDirectory") + "</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "FileConnector.Match") + "</nobr></td>\n" + "              </tr>\n");
            int l = 0;
            for (int j = 0; j < sn.getChildCount(); ++j) {
                SpecificationNode excludeNode = sn.getChild(j);
                String nodeFlavor = excludeNode.getType();
                String nodeType = excludeNode.getAttributeValue("type");
                String nodeMatch = excludeNode.getAttributeValue("match");
                out.print("              <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + nodeFlavor + "\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + nodeType + "\n" + "                  </nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr>\n" + "                    " + Encoder.bodyEscape((String)nodeMatch) + "\n" + "                  </nobr>\n" + "                </td>\n" + "              </tr>\n");
                ++l;
            }
            if (l == 0) {
                out.print("              <tr><td class=\"formcolumnmessage\" colspan=\"3\">" + Messages.getBodyString(locale, "FileConnector.NoRulesDefined") + "</td></tr>\n");
            }
            out.print("            </table>\n           </td>\n");
            out.print("        </tr>\n");
            ++k;
        }
        if (k == 0) {
            out.print("        <tr><td class=\"formcolumnmessage\" colspan=\"3\">" + Messages.getBodyString(locale, "FileConnector.NoDocumentsSpecified") + "</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n");
        out.print("</table>\n");
    }

    protected static boolean checkInclude(File file, String fileName, Specification documentSpecification) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Checking whether to include file '" + fileName + "'"));
        }
        try {
            String filePart;
            String pathPart;
            if (file.isDirectory()) {
                pathPart = fileName;
                filePart = null;
            } else {
                pathPart = file.getParentFile().getCanonicalPath();
                filePart = file.getName();
            }
            int i = 0;
            while (i < documentSpecification.getChildCount()) {
                int matchEnd;
                SpecificationNode sn;
                if (!(sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) continue;
                String path = new File(sn.getAttributeValue("path")).getCanonicalPath();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Checking path '" + path + "' against canonical '" + pathPart + "'"));
                }
                if ((matchEnd = FileConnector.matchSubPath(path, pathPart)) == -1) {
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("Match check '" + path + "' against canonical '" + pathPart + "' failed"));
                    continue;
                }
                int j = 0;
                while (j < sn.getChildCount()) {
                    int sourceIndex;
                    String sourceMatch;
                    SpecificationNode node = sn.getChild(j++);
                    String flavor = node.getType();
                    String match = node.getAttributeValue("match");
                    String type = node.getAttributeValue("type");
                    if (type.equals("file")) {
                        if (filePart == null) continue;
                        sourceMatch = filePart;
                        sourceIndex = 0;
                    } else {
                        if (filePart != null) continue;
                        sourceMatch = pathPart;
                        sourceIndex = matchEnd;
                    }
                    if (flavor.equals("include")) {
                        if (!FileConnector.checkMatch(sourceMatch, sourceIndex, match)) continue;
                        return true;
                    }
                    if (!flavor.equals("exclude") || !FileConnector.checkMatch(sourceMatch, sourceIndex, match)) continue;
                    return false;
                }
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Not including '" + fileName + "' because no matching rules"));
            }
            return false;
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO Error", (Throwable)e);
        }
    }

    protected static boolean checkIngest(File file, Specification documentSpecification) throws ManifoldCFException {
        return true;
    }

    protected static int matchSubPath(String subPath, String fullPath) {
        if (subPath.length() > fullPath.length()) {
            return -1;
        }
        if (!fullPath.startsWith(subPath)) {
            return -1;
        }
        int rval = subPath.length();
        if (fullPath.length() == rval) {
            return rval;
        }
        char x = fullPath.charAt(rval);
        if (x == File.separatorChar) {
            ++rval;
        }
        return rval;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = true;
        return FileConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return FileConnector.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || FileConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }
}

