/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorPool;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorPoolFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobNotifyRecord;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.NotificationResetManager;
import org.apache.manifoldcf.crawler.system.PipelineSpecificationBasic;

public class JobNotificationThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: JobNotificationThread.java 998081 2010-09-17 11:33:15Z kwright $";
    protected final NotificationResetManager resetManager;
    protected final String processID;

    public JobNotificationThread(NotificationResetManager resetManager, String processID) throws ManifoldCFException {
        this.resetManager = resetManager;
        this.processID = processID;
        this.setName("Job notification thread");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
            IRepositoryConnectionManager repositoryConnectionManager = RepositoryConnectionManagerFactory.make(threadContext);
            IOutputConnectorPool outputConnectorPool = OutputConnectorPoolFactory.make((IThreadContext)threadContext);
            while (true) {
                try {
                    while (true) {
                        String repositoryConnectionName;
                        IJobDescription job;
                        Long jobID;
                        this.resetManager.waitForReset(threadContext);
                        JobNotifyRecord[] jobsNeedingNotification = jobManager.getJobsReadyForInactivity(this.processID);
                        try {
                            HashSet<OutputAndRepositoryConnection> connectionNames = new HashSet<OutputAndRepositoryConnection>();
                            for (JobNotifyRecord jsr : jobsNeedingNotification) {
                                Long jobID2 = jsr.getJobID();
                                IJobDescription job2 = jobManager.load(jobID2, true);
                                if (job2 == null) continue;
                                String repositoryConnectionName2 = job2.getConnectionName();
                                PipelineSpecificationBasic basicSpec = new PipelineSpecificationBasic(job2);
                                for (int i = 0; i < basicSpec.getOutputCount(); ++i) {
                                    String outputConnectionName = basicSpec.getStageConnectionName(basicSpec.getOutputStage(i));
                                    OutputAndRepositoryConnection c = new OutputAndRepositoryConnection(outputConnectionName, repositoryConnectionName2);
                                    connectionNames.add(c);
                                }
                            }
                            HashMap<OutputAndRepositoryConnection, Disposition> notifiedConnections = new HashMap<OutputAndRepositoryConnection, Disposition>();
                            for (OutputAndRepositoryConnection connections : connectionNames) {
                                IOutputConnector connector;
                                String outputConnectionName = connections.getOutputConnectionName();
                                String repositoryConnectionName3 = connections.getRepositoryConnectionName();
                                OutputNotifyActivity activity = new OutputNotifyActivity(repositoryConnectionName3, repositoryConnectionManager, outputConnectionName);
                                IOutputConnection connection = connectionManager.load(outputConnectionName);
                                if (connection == null || (connector = outputConnectorPool.grab(connection)) == null) continue;
                                try {
                                    try {
                                        connector.noteJobComplete((IOutputNotifyActivity)activity);
                                        notifiedConnections.put(connections, new Disposition());
                                    }
                                    catch (ServiceInterruption e) {
                                        notifiedConnections.put(connections, new Disposition(e));
                                    }
                                    catch (ManifoldCFException e) {
                                        if (e.getErrorCode() == 2) {
                                            throw e;
                                        }
                                        if (e.getErrorCode() == 4) {
                                            throw e;
                                        }
                                        if (e.getErrorCode() == 3) {
                                            throw e;
                                        }
                                        Logging.threads.error((Object)e.getMessage(), (Throwable)e);
                                    }
                                }
                                finally {
                                    outputConnectorPool.release(connection, connector);
                                }
                            }
                            for (JobNotifyRecord jsr : jobsNeedingNotification) {
                                jobID = jsr.getJobID();
                                job = jobManager.load(jobID, true);
                                if (job == null) continue;
                                repositoryConnectionName = job.getConnectionName();
                                PipelineSpecificationBasic basicSpec = new PipelineSpecificationBasic(job);
                                boolean allOK = true;
                                for (int i = 0; i < basicSpec.getOutputCount(); ++i) {
                                    String outputConnectionName = basicSpec.getStageConnectionName(basicSpec.getOutputStage(i));
                                    OutputAndRepositoryConnection c = new OutputAndRepositoryConnection(outputConnectionName, repositoryConnectionName);
                                    Disposition d = (Disposition)notifiedConnections.get(c);
                                    if (d == null) continue;
                                    ServiceInterruption e = d.getServiceInterruption();
                                    if (e == null) break;
                                    if (!e.jobInactiveAbort()) {
                                        Logging.jobs.warn((Object)("Notification service interruption reported for job " + jobID + " output connection '" + outputConnectionName + "': " + e.getMessage()), (Throwable)e);
                                    }
                                    if (!e.jobInactiveAbort() && (jsr.getFailTime() != -1L && jsr.getFailTime() < e.getRetryTime() || jsr.getFailRetryCount() == 0)) {
                                        if (e.isAbortOnFail()) {
                                            String message;
                                            String string = e.jobInactiveAbort() ? "" : (message = "Repeated service interruptions during notification" + (e.getCause() != null ? ": " + e.getCause().getMessage() : ""));
                                            if (jobManager.errorAbort(jobID, message) && message.length() > 0) {
                                                Logging.jobs.error((Object)message, e.getCause());
                                            }
                                            jsr.noteStarted();
                                        } else {
                                            jobManager.inactivateJob(jobID);
                                            jsr.noteStarted();
                                        }
                                    } else {
                                        jobManager.retryNotification(jsr, e.getFailTime(), e.getFailRetryCount());
                                        jsr.noteStarted();
                                    }
                                    allOK = false;
                                    break;
                                }
                                if (!allOK) continue;
                                jobManager.inactivateJob(jobID);
                                jsr.noteStarted();
                            }
                        }
                        finally {
                            ManifoldCFException exception = null;
                            int i = 0;
                            while (i < jobsNeedingNotification.length) {
                                JobNotifyRecord jsr;
                                if ((jsr = jobsNeedingNotification[i++]).wasStarted()) continue;
                                try {
                                    jobManager.resetNotifyJob(jsr.getJobID());
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw e;
                                    }
                                    exception = e;
                                }
                            }
                            if (exception != null) {
                                throw exception;
                            }
                        }
                        JobNotifyRecord[] jobsNeedingDeleteNotification = jobManager.getJobsReadyForDelete(this.processID);
                        try {
                            HashSet<OutputAndRepositoryConnection> connectionNames = new HashSet<OutputAndRepositoryConnection>();
                            for (JobNotifyRecord jsr : jobsNeedingDeleteNotification) {
                                jobID = jsr.getJobID();
                                job = jobManager.load(jobID, true);
                                if (job == null) continue;
                                repositoryConnectionName = job.getConnectionName();
                                PipelineSpecificationBasic basicSpec = new PipelineSpecificationBasic(job);
                                for (int i = 0; i < basicSpec.getOutputCount(); ++i) {
                                    String outputConnectionName = basicSpec.getStageConnectionName(basicSpec.getOutputStage(i));
                                    OutputAndRepositoryConnection c = new OutputAndRepositoryConnection(outputConnectionName, repositoryConnectionName);
                                    connectionNames.add(c);
                                }
                            }
                            HashMap<OutputAndRepositoryConnection, Disposition> notifiedConnections = new HashMap<OutputAndRepositoryConnection, Disposition>();
                            for (OutputAndRepositoryConnection connections : connectionNames) {
                                IOutputConnector connector;
                                String outputConnectionName = connections.getOutputConnectionName();
                                String repositoryConnectionName4 = connections.getRepositoryConnectionName();
                                OutputNotifyActivity activity = new OutputNotifyActivity(repositoryConnectionName4, repositoryConnectionManager, outputConnectionName);
                                IOutputConnection connection = connectionManager.load(outputConnectionName);
                                if (connection == null || (connector = outputConnectorPool.grab(connection)) == null) continue;
                                try {
                                    try {
                                        connector.noteJobComplete((IOutputNotifyActivity)activity);
                                        notifiedConnections.put(connections, new Disposition());
                                    }
                                    catch (ServiceInterruption e) {
                                        notifiedConnections.put(connections, new Disposition(e));
                                    }
                                    catch (ManifoldCFException e) {
                                        if (e.getErrorCode() == 2) {
                                            throw e;
                                        }
                                        if (e.getErrorCode() == 4) {
                                            throw e;
                                        }
                                        if (e.getErrorCode() == 3) {
                                            throw e;
                                        }
                                        Logging.threads.error((Object)e.getMessage(), (Throwable)e);
                                    }
                                }
                                finally {
                                    outputConnectorPool.release(connection, connector);
                                }
                            }
                            for (JobNotifyRecord jsr : jobsNeedingDeleteNotification) {
                                Long jobID3 = jsr.getJobID();
                                IJobDescription job3 = jobManager.load(jobID3, true);
                                if (job3 == null) continue;
                                String repositoryConnectionName5 = job3.getConnectionName();
                                PipelineSpecificationBasic basicSpec = new PipelineSpecificationBasic(job3);
                                boolean allOK = true;
                                for (int i = 0; i < basicSpec.getOutputCount(); ++i) {
                                    String outputConnectionName = basicSpec.getStageConnectionName(basicSpec.getOutputStage(i));
                                    OutputAndRepositoryConnection c = new OutputAndRepositoryConnection(outputConnectionName, repositoryConnectionName5);
                                    Disposition d = (Disposition)notifiedConnections.get(c);
                                    if (d == null) continue;
                                    ServiceInterruption e = d.getServiceInterruption();
                                    if (e == null) break;
                                    if (!e.jobInactiveAbort()) {
                                        Logging.jobs.warn((Object)("Delete notification service interruption reported for job " + jobID3 + " output connection '" + outputConnectionName + "': " + e.getMessage()), (Throwable)e);
                                    }
                                    if (!e.jobInactiveAbort() && (jsr.getFailTime() != -1L && jsr.getFailTime() < e.getRetryTime() || jsr.getFailRetryCount() == 0)) {
                                        if (e.isAbortOnFail()) {
                                            String message;
                                            String string = e.jobInactiveAbort() ? "" : (message = "Repeated service interruptions during delete notification" + (e.getCause() != null ? ": " + e.getCause().getMessage() : ""));
                                            if (message.length() > 0) {
                                                Logging.jobs.error((Object)message, e.getCause());
                                            }
                                            jobManager.removeJob(jobID3);
                                            jsr.noteStarted();
                                        } else {
                                            jobManager.removeJob(jobID3);
                                            jsr.noteStarted();
                                        }
                                    } else {
                                        jobManager.retryDeleteNotification(jsr, e.getFailTime(), e.getFailRetryCount());
                                        jsr.noteStarted();
                                    }
                                    allOK = false;
                                    break;
                                }
                                if (!allOK) continue;
                                jobManager.removeJob(jobID3);
                                jsr.noteStarted();
                            }
                        }
                        finally {
                            ManifoldCFException exception = null;
                            int i = 0;
                            while (i < jobsNeedingDeleteNotification.length) {
                                JobNotifyRecord jsr;
                                if ((jsr = jobsNeedingDeleteNotification[i++]).wasStarted()) continue;
                                try {
                                    jobManager.resetDeleteNotifyJob(jsr.getJobID());
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw e;
                                    }
                                    exception = e;
                                }
                            }
                            if (exception != null) {
                                throw exception;
                            }
                        }
                        ManifoldCF.sleep((long)10000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Job notification thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("JobNotificationThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }

    protected static class OutputNotifyActivity
    implements IOutputNotifyActivity {
        protected String connectionName;
        protected IRepositoryConnectionManager connMgr;
        protected String outputConnectionName;

        public OutputNotifyActivity(String connectionName, IRepositoryConnectionManager connMgr, String outputConnectionName) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
            this.outputConnectionName = outputConnectionName;
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, ManifoldCF.qualifyOutputActivityName((String)activityType, (String)this.outputConnectionName), dataSize, entityURI, resultCode, resultDescription, null);
        }
    }

    protected static class OutputAndRepositoryConnection {
        protected final String outputConnectionName;
        protected final String repositoryConnectionName;

        public OutputAndRepositoryConnection(String outputConnectionName, String repositoryConnectionName) {
            this.outputConnectionName = outputConnectionName;
            this.repositoryConnectionName = repositoryConnectionName;
        }

        public String getOutputConnectionName() {
            return this.outputConnectionName;
        }

        public String getRepositoryConnectionName() {
            return this.repositoryConnectionName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof OutputAndRepositoryConnection)) {
                return false;
            }
            OutputAndRepositoryConnection x = (OutputAndRepositoryConnection)o;
            return this.outputConnectionName.equals(x.outputConnectionName) && this.repositoryConnectionName.equals(x.repositoryConnectionName);
        }

        public int hashCode() {
            return this.outputConnectionName.hashCode() + this.repositoryConnectionName.hashCode();
        }
    }

    protected static class Disposition {
        protected final ServiceInterruption serviceInterruption;

        public Disposition(ServiceInterruption serviceInterruption) {
            this.serviceInterruption = serviceInterruption;
        }

        public Disposition() {
            this.serviceInterruption = null;
        }

        public ServiceInterruption getServiceInterruption() {
            return this.serviceInterruption;
        }
    }
}

