/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.global.ThreadSafeRequestDelayControl;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.jetty.DelayableSocketConnector;
import com.github.tomakehurst.wiremock.jetty.DelayableSslSocketConnector;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.HandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsLoader;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.StubMappingJsonRecorder;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;

public class WireMockServer {
    public static final String FILES_ROOT = "__files";
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final WireMockApp wireMockApp;
    private final AdminRequestHandler adminRequestHandler;
    private final StubRequestHandler stubRequestHandler;
    private Server jettyServer;
    private final RequestDelayControl requestDelayControl;
    private final FileSource fileSource;
    private final Notifier notifier;
    private final int port;
    private final Options options;

    public WireMockServer(Options options) {
        this.options = options;
        this.fileSource = options.filesRoot();
        this.port = options.portNumber();
        this.notifier = options.notifier();
        this.requestDelayControl = new ThreadSafeRequestDelayControl();
        MappingsLoader defaultMappingsLoader = this.makeDefaultMappingsLoader();
        this.wireMockApp = new WireMockApp(this.requestDelayControl, options.browserProxyingEnabled(), defaultMappingsLoader, options.requestJournalDisabled());
        this.adminRequestHandler = new AdminRequestHandler(this.wireMockApp, new BasicResponseRenderer());
        this.stubRequestHandler = new StubRequestHandler(this.wireMockApp, new StubResponseRenderer(this.fileSource.child(FILES_ROOT), this.wireMockApp.getGlobalSettingsHolder(), new ProxyResponseRenderer(options.proxyVia())));
    }

    private MappingsLoader makeDefaultMappingsLoader() {
        FileSource mappingsFileSource = this.fileSource.child("mappings");
        if (mappingsFileSource.exists()) {
            return new JsonFileMappingsLoader(mappingsFileSource);
        }
        return new NoOpMappingsLoader();
    }

    public WireMockServer(int port, Integer httpsPort, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings, Notifier notifier) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings).notifier(notifier));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying));
    }

    public WireMockServer(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockServer(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockServer() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        this.wireMockApp.loadMappingsUsing(mappingsLoader);
    }

    public void addMockServiceRequestListener(RequestListener listener) {
        this.stubRequestHandler.addRequestListener(listener);
    }

    public void enableRecordMappings(FileSource mappingsFileSource, FileSource filesFileSource) {
        this.addMockServiceRequestListener(new StubMappingJsonRecorder(mappingsFileSource, filesFileSource, this.wireMockApp));
        this.notifier.info("Recording mappings to " + mappingsFileSource.getPath());
    }

    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            this.jettyServer = new Server();
            this.jettyServer.addConnector((Connector)this.createHttpConnector());
            if (this.options.httpsSettings().enabled()) {
                this.jettyServer.addConnector((Connector)this.createHttpsConnector());
            }
            this.addAdminContext();
            this.addMockServiceContext();
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DelayableSocketConnector createHttpConnector() {
        DelayableSocketConnector connector = new DelayableSocketConnector(this.requestDelayControl);
        connector.setPort(this.port);
        connector.setHeaderBufferSize(8192);
        return connector;
    }

    private DelayableSslSocketConnector createHttpsConnector() {
        DelayableSslSocketConnector connector = new DelayableSslSocketConnector(this.requestDelayControl);
        connector.setPort(this.options.httpsSettings().port());
        connector.setHeaderBufferSize(8192);
        connector.setKeystore(this.options.httpsSettings().keyStorePath());
        connector.setKeyPassword("password");
        return connector;
    }

    public boolean isRunning() {
        return this.jettyServer != null && this.jettyServer.isRunning();
    }

    private void addMockServiceContext() {
        Context mockServiceContext = new Context((HandlerContainer)this.jettyServer, "/");
        HashMap initParams = Maps.newHashMap();
        initParams.put("org.mortbay.jetty.servlet.Default.maxCacheSize", "0");
        initParams.put("org.mortbay.jetty.servlet.Default.resourceBase", this.fileSource.getPath());
        initParams.put("org.mortbay.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.setInitParams((Map)initParams);
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)this.stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)this.notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, 2);
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, 15);
        this.jettyServer.addHandler((Handler)mockServiceContext);
    }

    private void addAdminContext() {
        Context adminContext = new Context((HandlerContainer)this.jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)this.adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)this.notifier);
        this.jettyServer.addHandler((Handler)adminContext);
    }

    private static class NoOpMappingsLoader
    implements MappingsLoader {
        private NoOpMappingsLoader() {
        }

        @Override
        public void loadMappingsInto(StubMappings stubMappings) {
        }
    }
}

