/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ByteUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateReader
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(ZkStateReader.class);
    public static final String BASE_URL_PROP = "base_url";
    public static final String NODE_NAME_PROP = "node_name";
    public static final String CORE_NODE_NAME_PROP = "core_node_name";
    public static final String ROLES_PROP = "roles";
    public static final String STATE_PROP = "state";
    public static final String CORE_NAME_PROP = "core";
    public static final String COLLECTION_PROP = "collection";
    public static final String ELECTION_NODE_PROP = "election_node";
    public static final String SHARD_ID_PROP = "shard";
    public static final String REPLICA_PROP = "replica";
    public static final String SHARD_RANGE_PROP = "shard_range";
    public static final String SHARD_STATE_PROP = "shard_state";
    public static final String SHARD_PARENT_PROP = "shard_parent";
    public static final String NUM_SHARDS_PROP = "numShards";
    public static final String LEADER_PROP = "leader";
    public static final String PROPERTY_PROP = "property";
    public static final String PROPERTY_VALUE_PROP = "property.value";
    public static final String MAX_AT_ONCE_PROP = "maxAtOnce";
    public static final String MAX_WAIT_SECONDS_PROP = "maxWaitSeconds";
    public static final String COLLECTIONS_ZKNODE = "/collections";
    public static final String LIVE_NODES_ZKNODE = "/live_nodes";
    public static final String ALIASES = "/aliases.json";
    public static final String CLUSTER_STATE = "/clusterstate.json";
    public static final String CLUSTER_PROPS = "/clusterprops.json";
    public static final String REJOIN_AT_HEAD_PROP = "rejoinAtHead";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String AUTO_ADD_REPLICAS = "autoAddReplicas";
    public static final String ROLES = "/roles.json";
    public static final String RECOVERING = "recovering";
    public static final String RECOVERY_FAILED = "recovery_failed";
    public static final String ACTIVE = "active";
    public static final String DOWN = "down";
    public static final String SYNC = "sync";
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String CONFIGNAME_PROP = "configName";
    public static final String LEGACY_CLOUD = "legacyCloud";
    public static final String URL_SCHEME = "urlScheme";
    protected volatile ClusterState clusterState;
    private static final long SOLRCLOUD_UPDATE_DELAY = Long.parseLong(System.getProperty("solrcloud.update.delay", "5000"));
    private static final int GET_LEADER_RETRY_INTERVAL_MS = 50;
    private static final int GET_LEADER_RETRY_DEFAULT_TIMEOUT = 4000;
    public static final String LEADER_ELECT_ZKNODE = "leader_elect";
    public static final String SHARD_LEADERS_ZKNODE = "leaders";
    public static final String ELECTION_NODE = "election";
    private final Set<String> watchedCollections = new HashSet<String>();
    private Map<String, DocCollection> watchedCollectionStates = new ConcurrentHashMap<String, DocCollection>();
    private final ZkConfigManager configManager;
    private ScheduledExecutorService updateCloudExecutor = Executors.newScheduledThreadPool(1, new ZKTF());
    private boolean clusterStateUpdateScheduled;
    private final SolrZkClient zkClient;
    private final boolean closeClient;
    private final ZkCmdExecutor cmdExecutor;
    private volatile Aliases aliases = new Aliases();
    private volatile boolean closed = false;

    public static byte[] toJSON(Object o) {
        CharArr out = new CharArr();
        new JSONWriter(out, 2).write(o);
        return ZkStateReader.toUTF8(out);
    }

    public static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() << 2];
        int nBytes = ByteUtils.UTF16toUTF8((CharSequence)out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        CharArr chars = new CharArr();
        ByteUtils.UTF8toUTF16(utf8, 0, utf8.length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        try {
            return ObjectBuilder.getVal((JSONParser)parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readConfigName(String collection) {
        String configName;
        block8: {
            configName = null;
            String path = "/collections/" + collection;
            if (log.isInfoEnabled()) {
                log.info("Load collection config from:" + path);
            }
            try {
                byte[] data = this.zkClient.getData(path, null, null, true);
                if (data != null) {
                    ZkNodeProps props = ZkNodeProps.load(data);
                    configName = props.getStr(CONFIGNAME_PROP);
                }
                if (configName != null) {
                    if (!this.zkClient.exists("/configs/" + configName, true).booleanValue()) {
                        log.error("Specified config does not exist in ZooKeeper:" + configName);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Specified config does not exist in ZooKeeper:" + configName);
                    }
                    if (log.isInfoEnabled()) {
                        log.info("path={} {}={} specified config exists in ZooKeeper", new Object[]{path, CONFIGNAME_PROP, configName});
                    }
                    break block8;
                }
                throw new ZooKeeperException(SolrException.ErrorCode.INVALID_STATE, "No config data found at path: " + path);
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading config name for collection " + collection, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading config name for collection " + collection, (Throwable)e);
            }
        }
        return configName;
    }

    public ZkStateReader(SolrZkClient zkClient) {
        this.zkClient = zkClient;
        this.cmdExecutor = new ZkCmdExecutor(zkClient.getZkClientTimeout());
        this.configManager = new ZkConfigManager(zkClient);
        this.closeClient = false;
    }

    public ZkStateReader(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) {
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new OnReconnect(){

            @Override
            public void command() {
                try {
                    ZkStateReader.this.createClusterStateWatchersAndUpdate();
                }
                catch (KeeperException e) {
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
            }
        });
        this.cmdExecutor = new ZkCmdExecutor(zkClientTimeout);
        this.configManager = new ZkConfigManager(this.zkClient);
        this.closeClient = true;
    }

    public ZkConfigManager getConfigManager() {
        return this.configManager;
    }

    public void updateClusterState(boolean immediate) throws KeeperException, InterruptedException {
        this.updateClusterState(immediate, false);
    }

    public void updateLiveNodes() throws KeeperException, InterruptedException {
        this.updateClusterState(true, true);
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public Integer compareStateVersions(String coll, int version) {
        DocCollection collection = this.clusterState.getCollectionOrNull(coll);
        if (collection == null) {
            return null;
        }
        if (collection.getZNodeVersion() < version) {
            log.debug("server older than client {}<{}", (Object)collection.getZNodeVersion(), (Object)version);
            DocCollection nu = ZkStateReader.getCollectionLive(this, coll);
            if (nu == null) {
                return -1;
            }
            if (nu.getZNodeVersion() > collection.getZNodeVersion()) {
                this.updateWatchedCollection(nu);
                collection = nu;
            }
        }
        if (collection.getZNodeVersion() == version) {
            return null;
        }
        log.debug("wrong version from client {}!={} ", (Object)version, (Object)collection.getZNodeVersion());
        return collection.getZNodeVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createClusterStateWatchersAndUpdate() throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            log.info("Updating cluster state from ZooKeeper... ");
            Stat stat = this.zkClient.exists(CLUSTER_STATE, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    log.info("A cluster state change: {}, has occurred - updating... (live nodes size: {})", (Object)event, (Object)(ZkStateReader.this.clusterState == null ? 0 : ZkStateReader.this.clusterState.getLiveNodes().size()));
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            2 thisWatch = this;
                            Set<String> ln = ZkStateReader.this.clusterState.getLiveNodes();
                            ZkStateReader.this.clusterState = ZkStateReader.this.constructState(ln, thisWatch);
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                        return;
                    }
                }
            }, true);
            if (stat == null) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot connect to cluster at " + this.zkClient.getZkServerAddress() + ": cluster not found/not ready");
            }
        }
        object = this.getUpdateLock();
        synchronized (object) {
            List<String> liveNodes = this.zkClient.getChildren(LIVE_NODES_ZKNODE, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            List<String> liveNodes = ZkStateReader.this.zkClient.getChildren(ZkStateReader.LIVE_NODES_ZKNODE, this, true);
                            log.debug("Updating live nodes... ({})", (Object)liveNodes.size());
                            HashSet<String> liveNodesSet = new HashSet<String>();
                            liveNodesSet.addAll(liveNodes);
                            ClusterState clusterState = ZkStateReader.this.clusterState;
                            clusterState.setLiveNodes(liveNodesSet);
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                        return;
                    }
                }
            }, true);
            HashSet<String> liveNodeSet = new HashSet<String>();
            liveNodeSet.addAll(liveNodes);
            this.clusterState = this.constructState(liveNodeSet, null);
            this.zkClient.exists(ALIASES, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            log.info("Updating aliases... ");
                            4 thisWatch = this;
                            Stat stat = new Stat();
                            byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, thisWatch, stat, true);
                            Aliases aliases = ClusterState.load(data);
                            ZkStateReader.this.aliases = aliases;
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                        return;
                    }
                }
            }, true);
        }
        this.updateAliases();
        object = this;
        synchronized (object) {
            for (String watchedCollection : this.watchedCollections) {
                this.addZkWatch(watchedCollection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterState constructState(Set<String> ln, Watcher watcher) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        byte[] data = this.zkClient.getData(CLUSTER_STATE, watcher, stat, true);
        ClusterState loadedData = ClusterState.load(stat.getVersion(), data, ln, CLUSTER_STATE);
        LinkedHashMap<String, ClusterState.CollectionRef> result = new LinkedHashMap<String, ClusterState.CollectionRef>();
        result.putAll(loadedData.getCollectionStates());
        for (String s : this.getIndividualColls()) {
            ZkStateReader zkStateReader = this;
            synchronized (zkStateReader) {
                if (this.watchedCollections.contains(s)) {
                    DocCollection live = ZkStateReader.getCollectionLive(this, s);
                    if (live != null) {
                        this.watchedCollectionStates.put(s, live);
                        result.put(s, new ClusterState.CollectionRef(live));
                    }
                } else {
                    final String collName = s;
                    result.put(s, new ClusterState.CollectionRef(null){

                        @Override
                        public DocCollection get() {
                            return ZkStateReader.getCollectionLive(ZkStateReader.this, collName);
                        }

                        @Override
                        public boolean isLazilyLoaded() {
                            return true;
                        }
                    });
                }
            }
        }
        return new ClusterState(ln, result, stat.getVersion());
    }

    private Set<String> getIndividualColls() throws KeeperException, InterruptedException {
        List<String> children = null;
        try {
            children = this.zkClient.getChildren(COLLECTIONS_ZKNODE, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("Error fetching collection names");
            return new HashSet<String>();
        }
        if (children == null || children.isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> result = new HashSet<String>(children.size());
        for (String c : children) {
            try {
                if (!this.zkClient.exists(ZkStateReader.getCollectionPath(c), true).booleanValue()) continue;
                result.add(c);
            }
            catch (Exception e) {
                log.warn("Error reading collections nodes", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateClusterState(boolean immediate, final boolean onlyLiveNodes) throws KeeperException, InterruptedException {
        if (immediate) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                ClusterState clusterState;
                List<String> liveNodes = this.zkClient.getChildren(LIVE_NODES_ZKNODE, null, true);
                HashSet<String> liveNodesSet = new HashSet<String>();
                liveNodesSet.addAll(liveNodes);
                if (!onlyLiveNodes) {
                    log.debug("Updating cloud state from ZooKeeper... ");
                    clusterState = this.constructState(liveNodesSet, null);
                } else {
                    log.debug("Updating live nodes from ZooKeeper... ({})", (Object)liveNodesSet.size());
                    clusterState = this.clusterState;
                    clusterState.setLiveNodes(liveNodesSet);
                }
                this.clusterState = clusterState;
            }
            object = this;
            synchronized (object) {
                for (String watchedCollection : this.watchedCollections) {
                    DocCollection live = ZkStateReader.getCollectionLive(this, watchedCollection);
                    if (live == null) continue;
                    this.updateWatchedCollection(live);
                }
            }
        }
        if (this.clusterStateUpdateScheduled) {
            log.debug("Cloud state update for ZooKeeper already scheduled");
            return;
        }
        log.debug("Scheduling cloud state update from ZooKeeper...");
        this.clusterStateUpdateScheduled = true;
        this.updateCloudExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.debug("Updating cluster state from ZooKeeper...");
                Object object = ZkStateReader.this.getUpdateLock();
                synchronized (object) {
                    ClusterState clusterState;
                    ZkStateReader.this.clusterStateUpdateScheduled = false;
                    try {
                        List<String> liveNodes = ZkStateReader.this.zkClient.getChildren(ZkStateReader.LIVE_NODES_ZKNODE, null, true);
                        HashSet<String> liveNodesSet = new HashSet<String>();
                        liveNodesSet.addAll(liveNodes);
                        if (!onlyLiveNodes) {
                            log.debug("Updating cloud state from ZooKeeper... ");
                            clusterState = ZkStateReader.this.constructState(liveNodesSet, null);
                        } else {
                            log.debug("Updating live nodes from ZooKeeper... ");
                            clusterState = ZkStateReader.this.clusterState;
                            clusterState.setLiveNodes(liveNodesSet);
                        }
                        ZkStateReader.this.clusterState = clusterState;
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    ZkStateReader.this.clusterState = clusterState;
                    ZkStateReader zkStateReader = ZkStateReader.this;
                    synchronized (zkStateReader) {
                        for (String watchedCollection : ZkStateReader.this.watchedCollections) {
                            DocCollection live = ZkStateReader.getCollectionLive(ZkStateReader.this, watchedCollection);
                            assert (live != null);
                            if (live == null) continue;
                            ZkStateReader.this.updateWatchedCollection(live);
                        }
                    }
                }
            }
        }, SOLRCLOUD_UPDATE_DELAY, TimeUnit.MILLISECONDS);
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Object getUpdateLock() {
        return this;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.closeClient) {
            this.zkClient.close();
        }
    }

    public String getLeaderUrl(String collection, String shard, int timeout) throws InterruptedException, KeeperException {
        ZkCoreNodeProps props = new ZkCoreNodeProps(this.getLeaderRetry(collection, shard, timeout));
        return props.getCoreUrl();
    }

    public Replica getLeader(String collection, String shard) throws InterruptedException {
        Replica replica;
        if (this.clusterState != null && (replica = this.clusterState.getLeader(collection, shard)) != null && this.getClusterState().liveNodesContain(replica.getNodeName())) {
            return replica;
        }
        return null;
    }

    public Replica getLeaderRetry(String collection, String shard) throws InterruptedException {
        return this.getLeaderRetry(collection, shard, 4000);
    }

    public Replica getLeaderRetry(String collection, String shard, int timeout) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        while (true) {
            Replica leader;
            if ((leader = this.getLeader(collection, shard)) != null) {
                return leader;
            }
            if (System.nanoTime() >= timeoutAt || this.closed) break;
            Thread.sleep(50L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No registered leader was found after waiting for " + timeout + "ms " + ", collection: " + collection + " slice: " + shard);
    }

    public static String getShardLeadersPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + SHARD_LEADERS_ZKNODE + (shardId != null ? "/" + shardId : "");
    }

    public static String getShardLeadersElectPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + LEADER_ELECT_ZKNODE + (shardId != null ? "/" + shardId + "/" + ELECTION_NODE : "");
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, String mustMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, mustMatchStateFilter, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, String mustMatchStateFilter, String mustNotMatchStateFilter) {
        assert (thisCoreNodeName != null);
        ClusterState clusterState = this.clusterState;
        if (clusterState == null) {
            return null;
        }
        Map<String, Slice> slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + collection + " " + clusterState.getCollections());
        }
        Slice replicas = slices.get(shardId);
        if (replicas == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find shardId in zk: " + shardId);
        }
        Map<String, Replica> shardMap = replicas.getReplicasMap();
        ArrayList<ZkCoreNodeProps> nodes = new ArrayList<ZkCoreNodeProps>(shardMap.size());
        for (Map.Entry<String, Replica> entry : shardMap.entrySet()) {
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps(entry.getValue());
            String coreNodeName = entry.getValue().getName();
            if (!clusterState.liveNodesContain(nodeProps.getNodeName()) || coreNodeName.equals(thisCoreNodeName) || mustMatchStateFilter != null && !mustMatchStateFilter.equals(nodeProps.getState()) || mustNotMatchStateFilter != null && mustNotMatchStateFilter.equals(nodeProps.getState())) continue;
            nodes.add(nodeProps);
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public void updateAliases() throws KeeperException, InterruptedException {
        Aliases aliases;
        byte[] data = this.zkClient.getData(ALIASES, null, null, true);
        this.aliases = aliases = ClusterState.load(data);
    }

    public Map getClusterProps() {
        Map result = null;
        try {
            result = this.getZkClient().exists(CLUSTER_PROPS, true) != false ? (Map)ZkStateReader.fromJSON(this.getZkClient().getData(CLUSTER_PROPS, null, new Stat(), true)) : new LinkedHashMap();
            return result;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading cluster properties", (Throwable)e);
        }
    }

    public String getBaseUrlForNodeName(String nodeName) {
        int _offset = nodeName.indexOf("_");
        if (_offset < 0) {
            throw new IllegalArgumentException("nodeName does not contain expected '_' seperator: " + nodeName);
        }
        String hostAndPort = nodeName.substring(0, _offset);
        try {
            String path = URLDecoder.decode(nodeName.substring(1 + _offset), "UTF-8");
            String urlScheme = (String)this.getClusterProps().get(URL_SCHEME);
            if (urlScheme == null) {
                urlScheme = "http";
            }
            return urlScheme + "://" + hostAndPort + (path.isEmpty() ? "" : "/" + path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM Does not seem to support UTF-8", e);
        }
    }

    public static DocCollection getCollectionLive(ZkStateReader zkStateReader, String coll) {
        String collectionPath = ZkStateReader.getCollectionPath(coll);
        try {
            if (!zkStateReader.getZkClient().exists(collectionPath, true).booleanValue()) {
                return null;
            }
            Stat stat = new Stat();
            byte[] data = zkStateReader.getZkClient().getData(collectionPath, null, stat, true);
            ClusterState state = ClusterState.load(stat.getVersion(), data, Collections.emptySet(), collectionPath);
            ClusterState.CollectionRef collectionRef = state.getCollectionStates().get(coll);
            return collectionRef == null ? null : collectionRef.get();
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("No node available : " + collectionPath, (Throwable)e);
            return null;
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK:" + coll, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK:" + coll, (Throwable)e);
        }
    }

    public static String getCollectionPath(String coll) {
        return "/collections/" + coll + "/state.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollectionWatch(String coll) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = this;
        synchronized (zkStateReader) {
            if (this.watchedCollections.contains(coll)) {
                return;
            }
            this.watchedCollections.add(coll);
            this.addZkWatch(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZkWatch(final String coll) throws KeeperException, InterruptedException {
        log.info("addZkWatch {}", (Object)coll);
        final String fullpath = ZkStateReader.getCollectionPath(coll);
        Object object = this.getUpdateLock();
        synchronized (object) {
            this.cmdExecutor.ensureExists(fullpath, this.zkClient);
            log.info("Updating collection state at {} from ZooKeeper... ", (Object)fullpath);
            Watcher watcher = new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    log.info("A cluster state change: {} for collection {} has occurred - updating... (live nodes size: {})", new Object[]{event, coll, ZkStateReader.this.clusterState == null ? 0 : ZkStateReader.this.clusterState.getLiveNodes().size()});
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            if (!ZkStateReader.this.watchedCollections.contains(coll)) {
                                log.info("Unwatched collection {}", (Object)coll);
                                return;
                            }
                            7 thisWatch = this;
                            Stat stat = new Stat();
                            byte[] data = ZkStateReader.this.zkClient.getData(fullpath, thisWatch, stat, true);
                            if (data == null || data.length == 0) {
                                log.warn("No value set for collection state : {}", (Object)coll);
                                return;
                            }
                            ClusterState clusterState = ClusterState.load(stat.getVersion(), data, Collections.emptySet(), fullpath);
                            DocCollection newState = clusterState.getCollectionStates().get(coll).get();
                            ZkStateReader.this.updateWatchedCollection(newState);
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("Unwatched collection :" + coll, (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("Unwatched collection :" + coll, (Throwable)e);
                        return;
                    }
                }
            };
            this.zkClient.exists(fullpath, watcher, true);
        }
        DocCollection collection = ZkStateReader.getCollectionLive(this, coll);
        if (collection != null) {
            this.updateWatchedCollection(collection);
        }
    }

    private void updateWatchedCollection(DocCollection newState) {
        this.watchedCollectionStates.put(newState.getName(), newState);
        log.info("Updating data for {} to ver {} ", (Object)newState.getName(), (Object)newState.getZNodeVersion());
        this.clusterState = this.clusterState.copyWith(newState.getName(), newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeZKWatch(String coll) {
        ZkStateReader zkStateReader = this;
        synchronized (zkStateReader) {
            this.watchedCollections.remove(coll);
            this.watchedCollectionStates.remove(coll);
            try {
                this.updateClusterState(true);
            }
            catch (KeeperException e) {
                log.error("Error updating state", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("Error updating state", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    abstract class RunnableWatcher
    implements Runnable {
        Watcher watcher;

        public RunnableWatcher(Watcher watcher) {
            this.watcher = watcher;
        }
    }

    private static class ZKTF
    implements ThreadFactory {
        private static ThreadGroup tg = new ThreadGroup("ZkStateReader");

        private ZKTF() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread td = new Thread(tg, r);
            td.setDaemon(true);
            return td;
        }
    }
}

