/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IThrottledConnection;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class DataCache {
    public static final String _rcsid = "@(#)$Id: DataCache.java 988245 2010-08-23 18:39:35Z kwright $";
    protected Map<String, DocumentData> cacheData = new HashMap<String, DocumentData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String addData(IVersionActivity activities, String documentIdentifier, IThrottledConnection connection) throws ManifoldCFException, ServiceInterruption {
        int responseCode = connection.getResponseCode();
        String contentType = connection.getResponseHeader("Content-Type");
        String referralURI = connection.getResponseHeader("Location");
        try {
            InputStream dataStream = connection.getResponseBodyStream();
            if (dataStream == null) {
                return null;
            }
            try {
                File tempFile = File.createTempFile("_webcache_", "tmp");
                ManifoldCF.addFile((File)tempFile);
                long checkSum = 0L;
                try (FileOutputStream os = new FileOutputStream(tempFile);){
                    byte[] byteArray = new byte[65536];
                    while (true) {
                        int amt;
                        try {
                            amt = dataStream.read(byteArray, 0, byteArray.length);
                        }
                        catch (SocketTimeoutException e) {
                            Logging.connectors.warn((Object)("Socket timeout exception reading socket stream: " + e.getMessage()), (Throwable)e);
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Socket timeout: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, false);
                        }
                        catch (ConnectTimeoutException e) {
                            Logging.connectors.warn((Object)("Socket connect timeout exception reading socket stream: " + e.getMessage()), (Throwable)e);
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Socket timeout: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, false);
                        }
                        catch (InterruptedIOException e) {
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                        }
                        catch (IOException e) {
                            Logging.connectors.warn((Object)("IO exception reading socket stream: " + e.getMessage()), (Throwable)e);
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Read timeout: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, false);
                        }
                        if (amt == -1) {
                            break;
                        }
                        int i = 0;
                        while (i < amt) {
                            byte x = byteArray[i++];
                            long bytevalue = x;
                            checkSum = checkSum << 5 ^ checkSum >> 3 ^ bytevalue << 2 ^ bytevalue >> 3;
                        }
                        ((OutputStream)os).write(byteArray, 0, amt);
                        activities.checkJobStillActive();
                    }
                }
                DataCache dataCache = this;
                synchronized (dataCache) {
                    try {
                        this.deleteData(documentIdentifier);
                        this.cacheData.put(documentIdentifier, new DocumentData(tempFile, responseCode, contentType, referralURI));
                        String string = new Long(checkSum).toString();
                        return string;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (IOException e) {
                            ManifoldCF.deleteFile((File)tempFile);
                            throw e;
                        }
                        catch (ManifoldCFException e) {
                            ManifoldCF.deleteFile((File)tempFile);
                            throw e;
                        }
                        catch (ServiceInterruption e) {
                            ManifoldCF.deleteFile((File)tempFile);
                            throw e;
                        }
                        catch (Error e) {
                            ManifoldCF.deleteFile((File)tempFile);
                            throw e;
                        }
                    }
                }
            }
            finally {
                try {
                    dataStream.close();
                }
                catch (SocketTimeoutException e) {
                    Logging.connectors.warn((Object)("WEB: Socket timeout exception closing data stream, ignoring: " + e.getMessage()), (Throwable)e);
                }
                catch (ConnectTimeoutException e) {
                    Logging.connectors.warn((Object)("WEB: Socket connect timeout exception closing data stream, ignoring: " + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    Logging.connectors.warn((Object)("WEB: IO exception closing data stream, ignoring: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception creating temporary file: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout exception creating temporary file: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception creating temporary file: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized int getResponseCode(String documentIdentifier) {
        DocumentData dd = this.cacheData.get(documentIdentifier);
        if (dd == null) {
            return -1;
        }
        return dd.getResponseCode();
    }

    public synchronized String getContentType(String documentIdentifier) {
        DocumentData dd = this.cacheData.get(documentIdentifier);
        if (dd == null) {
            return null;
        }
        return dd.getContentType();
    }

    public synchronized String getReferralURI(String documentIdentifier) {
        DocumentData dd = this.cacheData.get(documentIdentifier);
        if (dd == null) {
            return null;
        }
        return dd.getReferralURI();
    }

    public synchronized long getDataLength(String documentIdentifier) {
        DocumentData dd = this.cacheData.get(documentIdentifier);
        if (dd == null) {
            return 0L;
        }
        return dd.getData().length();
    }

    public synchronized InputStream getData(String documentIdentifier) throws ManifoldCFException {
        DocumentData dd = this.cacheData.get(documentIdentifier);
        if (dd == null) {
            return null;
        }
        try {
            return new FileInputStream(dd.getData());
        }
        catch (FileNotFoundException e) {
            throw new ManifoldCFException("File not found exception opening data: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void deleteData(String documentIdentifier) {
        DocumentData dd = this.cacheData.remove(documentIdentifier);
        if (dd != null) {
            ManifoldCF.deleteFile((File)dd.getData());
        }
    }

    protected static class DocumentData {
        protected File data;
        protected int responseCode;
        protected String contentType;
        protected String referralURI;

        public DocumentData(File data, int responseCode, String contentType, String referralURI) {
            this.data = data;
            this.responseCode = responseCode;
            this.contentType = contentType;
            this.referralURI = referralURI;
        }

        public File getData() {
            return this.data;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getReferralURI() {
            return this.referralURI;
        }
    }
}

