/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoiceField;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;
import org.apache.pdfbox.util.PDFOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDAppearance {
    private final PDVariableText parent;
    private String value;
    private final COSString defaultAppearance;
    private final PDAcroForm acroForm;
    private List<COSObjectable> widgets = new ArrayList<COSObjectable>();
    private static final String HIGHLIGHT_COLOR = "0.600006 0.756866 0.854904 rg";
    private static final int DEFAULT_PADDING = 1;
    private PDRectangle paddingEdge = null;
    private PDRectangle contentArea = null;

    public PDAppearance(PDAcroForm theAcroForm, PDVariableText field) throws IOException {
        this.acroForm = theAcroForm;
        this.parent = field;
        this.widgets = field.getKids();
        if (this.widgets == null) {
            this.widgets = new ArrayList<COSObjectable>();
            this.widgets.add(field.getWidget());
        }
        this.defaultAppearance = this.getDefaultAppearance();
    }

    private COSString getDefaultAppearance() {
        COSString dap = this.parent.getDefaultAppearance();
        if (dap == null) {
            COSArray kids = (COSArray)this.parent.getDictionary().getDictionaryObject(COSName.KIDS);
            if (kids != null && kids.size() > 0) {
                COSDictionary firstKid = (COSDictionary)kids.getObject(0);
                dap = (COSString)firstKid.getDictionaryObject(COSName.DA);
            }
            if (dap == null) {
                dap = (COSString)this.acroForm.getDictionary().getDictionaryObject(COSName.DA);
            }
        }
        return dap;
    }

    private int getQ() {
        COSDictionary firstKid;
        COSNumber qNum;
        COSArray kids;
        int q = this.parent.getQ();
        if (this.parent.getDictionary().getDictionaryObject(COSName.Q) == null && (kids = (COSArray)this.parent.getDictionary().getDictionaryObject(COSName.KIDS)) != null && kids.size() > 0 && (qNum = (COSNumber)(firstKid = (COSDictionary)kids.getObject(0)).getDictionaryObject(COSName.Q)) != null) {
            q = qNum.intValue();
        }
        return q;
    }

    private List getStreamTokens(PDAppearanceStream appearanceStream) throws IOException {
        List tokens = null;
        if (appearanceStream != null) {
            tokens = this.getStreamTokens(appearanceStream.getStream());
        }
        return tokens;
    }

    private List getStreamTokens(COSString string) throws IOException {
        List<Object> tokens = null;
        if (string != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
            PDFStreamParser parser = new PDFStreamParser((InputStream)stream, this.acroForm.getDocument().getDocument().getScratchFile());
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private List getStreamTokens(COSStream stream) throws IOException {
        List<Object> tokens = null;
        if (stream != null) {
            PDFStreamParser parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private boolean containsMarkedContent(List stream) {
        return stream.contains(PDFOperator.getOperator("BMC"));
    }

    private PDRectangle applyPadding(PDRectangle bbox, float padding) {
        PDRectangle area = new PDRectangle(bbox.getCOSArray());
        area.setLowerLeftX(area.getLowerLeftX() + padding);
        area.setLowerLeftY(area.getLowerLeftY() + padding);
        area.setUpperRightX(area.getUpperRightX() - padding);
        area.setUpperRightY(area.getUpperRightY() - padding);
        return area;
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        for (COSObjectable next : this.widgets) {
            ContentStreamWriter writer;
            ByteArrayOutputStream output;
            Map<String, PDAppearanceStream> normalAppearance;
            PDAppearanceStream appearanceStream;
            PDAnnotationWidget widget;
            PDField field = null;
            if (next instanceof PDField) {
                field = (PDField)next;
                widget = field.getWidget();
            } else {
                widget = (PDAnnotationWidget)next;
            }
            PDFormFieldAdditionalActions actions = null;
            if (field != null) {
                actions = field.getActions();
            }
            if (actions != null && actions.getF() != null && widget.getDictionary().getDictionaryObject(COSName.AP) == null) continue;
            PDAppearanceDictionary appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new PDAppearanceDictionary();
                widget.setAppearance(appearance);
            }
            if ((appearanceStream = (normalAppearance = appearance.getNormalAppearance()).get("default")) == null) {
                COSStream cosStream = this.acroForm.getDocument().getDocument().createCOSStream();
                appearanceStream = new PDAppearanceStream(cosStream);
                appearanceStream.setBoundingBox(widget.getRectangle().createRetranslatedRectangle());
                appearance.setNormalAppearance(appearanceStream);
            }
            List tokens = this.getStreamTokens(appearanceStream);
            List daTokens = this.getStreamTokens(this.getDefaultAppearance());
            PDFont pdFont = this.getFontAndUpdateResources(tokens, appearanceStream);
            if (this.parent instanceof PDChoiceField) {
                PDChoiceField cfr_ignored_0 = (PDChoiceField)this.parent;
                if ((this.parent.getFieldFlags() & 0x20000) == 0) {
                    this.generateListboxAppearance(widget, pdFont, tokens, daTokens, appearanceStream, this.value);
                    continue;
                }
            }
            if (!this.containsMarkedContent(tokens)) {
                output = new ByteArrayOutputStream();
                writer = new ContentStreamWriter(output);
                writer.writeTokens(tokens);
                output.write(" /Tx BMC\n".getBytes("ISO-8859-1"));
                this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
                output.write(" EMC".getBytes("ISO-8859-1"));
                this.writeToStream(output.toByteArray(), appearanceStream);
                continue;
            }
            if (tokens == null) continue;
            if (daTokens != null) {
                int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
                int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
                if (bmcIndex != -1 && emcIndex != -1 && emcIndex == bmcIndex + 1) {
                    tokens.addAll(emcIndex, daTokens);
                }
            }
            output = new ByteArrayOutputStream();
            writer = new ContentStreamWriter(output);
            float fontSize = this.calculateFontSize(pdFont, appearanceStream.getBoundingBox(), tokens, daTokens);
            boolean foundString = false;
            int indexOfString = -1;
            int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
            tokens.set(setFontIndex - 1, new COSFloat(fontSize));
            int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
            int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
            if (bmcIndex != -1) {
                writer.writeTokens(tokens, 0, bmcIndex + 1);
            } else {
                writer.writeTokens(tokens);
            }
            output.write("\n".getBytes("ISO-8859-1"));
            this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
            if (emcIndex != -1) {
                writer.writeTokens(tokens, emcIndex, tokens.size());
            }
            this.writeToStream(output.toByteArray(), appearanceStream);
        }
    }

    private void generateListboxAppearance(PDAnnotationWidget fieldWidget, PDFont pdFont, List tokens, List daTokens, PDAppearanceStream appearanceStream, String fieldValue) throws IOException {
        this.paddingEdge = this.applyPadding(appearanceStream.getBoundingBox(), 1.0f);
        this.contentArea = this.applyPadding(this.paddingEdge, 1.0f);
        if (!this.containsMarkedContent(tokens)) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ContentStreamWriter writer = new ContentStreamWriter(output);
            writer.writeTokens(tokens);
            output.write(" /Tx BMC\n".getBytes("ISO-8859-1"));
            this.insertGeneratedListboxAppearance(fieldWidget, output, pdFont, tokens, appearanceStream);
            output.write(" EMC".getBytes("ISO-8859-1"));
            this.writeToStream(output.toByteArray(), appearanceStream);
        } else if (tokens != null) {
            if (daTokens != null) {
                int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
                int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
                if (bmcIndex != -1 && emcIndex != -1 && emcIndex == bmcIndex + 1) {
                    tokens.addAll(emcIndex, daTokens);
                }
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ContentStreamWriter writer = new ContentStreamWriter(output);
            float fontSize = this.calculateListboxFontSize(pdFont, appearanceStream.getBoundingBox(), tokens, daTokens);
            boolean foundString = false;
            int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
            tokens.set(setFontIndex - 1, new COSFloat(fontSize));
            int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
            int beginTextIndex = tokens.indexOf(PDFOperator.getOperator("BT"));
            if (beginTextIndex != -1) {
                ListIterator innerTokens = tokens.listIterator(bmcIndex);
                while (innerTokens.hasNext()) {
                    if (innerTokens.next() != PDFOperator.getOperator("re") || innerTokens.next() != PDFOperator.getOperator("W")) continue;
                    COSArray array = new COSArray();
                    array.add((COSNumber)tokens.get(innerTokens.previousIndex() - 5));
                    array.add((COSNumber)tokens.get(innerTokens.previousIndex() - 4));
                    array.add((COSNumber)tokens.get(innerTokens.previousIndex() - 3));
                    array.add((COSNumber)tokens.get(innerTokens.previousIndex() - 2));
                    this.paddingEdge = new PDRectangle(array);
                    this.paddingEdge.setUpperRightX(this.paddingEdge.getLowerLeftX() + this.paddingEdge.getUpperRightX());
                    this.paddingEdge.setUpperRightY(this.paddingEdge.getLowerLeftY() + this.paddingEdge.getUpperRightY());
                    this.contentArea = this.applyPadding(this.paddingEdge, this.paddingEdge.getLowerLeftX() - appearanceStream.getBoundingBox().getLowerLeftX());
                    break;
                }
            }
            int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
            if (bmcIndex != -1) {
                writer.writeTokens(tokens, 0, bmcIndex + 1);
            } else {
                writer.writeTokens(tokens);
            }
            output.write("\n".getBytes("ISO-8859-1"));
            this.insertGeneratedListboxAppearance(fieldWidget, output, pdFont, tokens, appearanceStream);
            if (emcIndex != -1) {
                writer.writeTokens(tokens, emcIndex, tokens.size());
            }
            this.writeToStream(output.toByteArray(), appearanceStream);
        }
    }

    private void insertGeneratedAppearance(PDAnnotationWidget fieldWidget, OutputStream output, PDFont pdFont, List tokens, PDAppearanceStream appearanceStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(output, true);
        float fontSize = 0.0f;
        PDRectangle boundingBox = appearanceStream.getBoundingBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        if (this.parent.shouldComb()) {
            this.insertGeneratedPaddingEdge(printWriter, appearanceStream);
        }
        printWriter.println("BT");
        if (this.defaultAppearance != null) {
            String daString = this.defaultAppearance.getString();
            PDFStreamParser daParser = new PDFStreamParser((InputStream)new ByteArrayInputStream(daString.getBytes("ISO-8859-1")), null);
            daParser.parse();
            List<Object> daTokens = daParser.getTokens();
            fontSize = this.calculateFontSize(pdFont, boundingBox, tokens, daTokens);
            int fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"));
            if (fontIndex != -1) {
                daTokens.set(fontIndex - 1, new COSFloat(fontSize));
            }
            ContentStreamWriter daWriter = new ContentStreamWriter(output);
            daWriter.writeTokens(daTokens);
        }
        if (this.parent.shouldComb() && this.parent.getDictionary().getInt("MaxLen") != -1) {
            this.insertGeneratedCombAppearance(printWriter, pdFont, appearanceStream, fontSize);
        } else {
            printWriter.println(this.getTextPosition(boundingBox, pdFont, fontSize, tokens));
            int q = this.getQ();
            if (q != 0) {
                if (q == 1 || q == 2) {
                    float fieldWidth = boundingBox.getWidth();
                    float stringWidth = pdFont.getStringWidth(this.value) / 1000.0f * fontSize;
                    float adjustAmount = fieldWidth - stringWidth - 4.0f;
                    if (q == 1) {
                        adjustAmount /= 2.0f;
                    }
                    printWriter.println(adjustAmount + " 0 Td");
                } else {
                    throw new IOException("Error: Unknown justification value:" + q);
                }
            }
            if (!this.isMultiLineValue(this.value)) {
                printWriter.println("<" + new COSString(this.value).getHexString() + "> Tj");
            } else {
                String[] lines = this.value.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    boolean lastLine = i == lines.length - 1;
                    String endingTag = lastLine ? "> Tj\n" : "> Tj 0 -13 Td";
                    printWriter.print("<" + new COSString(lines[i]).getHexString() + endingTag);
                }
            }
        }
        printWriter.println("ET");
        printWriter.flush();
    }

    private void insertGeneratedPaddingEdge(PrintWriter printWriter, PDAppearanceStream appearanceStream) {
        this.paddingEdge = this.applyPadding(appearanceStream.getBoundingBox(), 1.0f);
        printWriter.println("q");
        printWriter.println(this.paddingEdge.getLowerLeftX() + " " + this.paddingEdge.getLowerLeftY() + " " + this.paddingEdge.getWidth() + " " + this.paddingEdge.getHeight() + " " + " re");
        printWriter.println("W");
        printWriter.println("n");
    }

    private void insertGeneratedCombAppearance(PrintWriter printWriter, PDFont pdFont, PDAppearanceStream appearanceStream, float fontSize) throws IOException {
        int maxLen;
        int numChars = maxLen = this.parent.getDictionary().getInt("MaxLen");
        if (this.value.length() < maxLen) {
            numChars = this.value.length();
        }
        float combWidth = appearanceStream.getBoundingBox().getWidth() / (float)maxLen;
        float ascentAtFontSize = pdFont.getFontDescriptor().getAscent() / 1000.0f * fontSize;
        float baselineOffset = this.paddingEdge.getLowerLeftY() + (appearanceStream.getBoundingBox().getHeight() - ascentAtFontSize) / 2.0f;
        float prevCharWidth = 0.0f;
        float currCharWidth = 0.0f;
        float xOffset = combWidth / 2.0f;
        String combString = "";
        for (int i = 0; i < numChars; ++i) {
            combString = this.value.substring(i, i + 1);
            currCharWidth = pdFont.getStringWidth(combString) / 1000.0f * fontSize / 2.0f;
            xOffset = xOffset + prevCharWidth / 2.0f - currCharWidth / 2.0f;
            printWriter.println(xOffset + " " + baselineOffset + " Td");
            printWriter.println("<" + new COSString(combString).getHexString() + "> Tj");
            baselineOffset = 0.0f;
            prevCharWidth = currCharWidth;
            xOffset = combWidth;
        }
    }

    private void insertGeneratedListboxAppearance(PDAnnotationWidget fieldWidget, OutputStream output, PDFont pdFont, List tokens, PDAppearanceStream appearanceStream) throws IOException {
        int q;
        PrintWriter printWriter = new PrintWriter(output, true);
        float fontSize = 0.0f;
        PDRectangle boundingBox = appearanceStream.getBoundingBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        List<Object> daTokens = null;
        if (this.defaultAppearance != null) {
            String daString = this.defaultAppearance.getString();
            PDFStreamParser daParser = new PDFStreamParser((InputStream)new ByteArrayInputStream(daString.getBytes("ISO-8859-1")), null);
            daParser.parse();
            daTokens = daParser.getTokens();
            fontSize = this.calculateListboxFontSize(pdFont, this.contentArea, tokens, daTokens);
            int fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"));
            if (fontIndex != -1) {
                daTokens.set(fontIndex - 1, new COSFloat(fontSize));
            }
        }
        printWriter.println("q");
        printWriter.println(this.paddingEdge.getLowerLeftX() + " " + this.paddingEdge.getLowerLeftY() + " " + this.paddingEdge.getWidth() + " " + this.paddingEdge.getHeight() + " " + " re");
        printWriter.println("W");
        printWriter.println("n");
        printWriter.println(HIGHLIGHT_COLOR);
        COSArray indexEntries = ((PDChoiceField)this.parent).getSelectedOptions();
        int selectedIndex = ((COSInteger)indexEntries.get(0)).intValue();
        int topIndex = ((PDChoiceField)this.parent).getTopIndex();
        float highlightBoxHeight = pdFont.getFontBoundingBox().getHeight() / 1000.0f * fontSize;
        printWriter.println(this.paddingEdge.getLowerLeftX() + " " + (this.paddingEdge.getUpperRightY() - highlightBoxHeight * (float)(selectedIndex - topIndex + 1)) + " " + this.paddingEdge.getWidth() + " " + highlightBoxHeight + " re");
        printWriter.println("f");
        printWriter.println("0 g");
        printWriter.println("0 G");
        printWriter.println("1 w");
        printWriter.println("BT");
        if (this.defaultAppearance != null) {
            ContentStreamWriter daWriter = new ContentStreamWriter(output);
            daWriter.writeTokens(daTokens);
        }
        if ((q = this.getQ()) != 0) {
            if (q == 1 || q == 2) {
                float fieldWidth = boundingBox.getWidth();
                float stringWidth = pdFont.getStringWidth(this.value) / 1000.0f * fontSize;
                float adjustAmount = fieldWidth - stringWidth - 4.0f;
                if (q == 1) {
                    adjustAmount /= 2.0f;
                }
                printWriter.println(adjustAmount + " 0 Td");
            } else {
                throw new IOException("Error: Unknown justification value:" + q);
            }
        }
        COSArray options = ((PDChoiceField)this.parent).getOptions();
        float yTextPos = this.contentArea.getUpperRightY();
        for (int i = topIndex; i < options.size(); ++i) {
            COSBase option = options.getObject(i);
            COSArray optionPair = (COSArray)option;
            COSString optionKey = (COSString)optionPair.getObject(0);
            COSString optionValue = (COSString)optionPair.getObject(1);
            if (i == topIndex) {
                yTextPos -= pdFont.getFontDescriptor().getAscent() / 1000.0f * fontSize;
            } else {
                yTextPos -= pdFont.getFontBoundingBox().getHeight() / 1000.0f * fontSize;
                printWriter.println("BT");
            }
            printWriter.println(this.contentArea.getLowerLeftX() + " " + yTextPos + " Td");
            printWriter.println("<" + optionValue.getHexString() + "> Tj");
            if (i - topIndex == options.size() - 1) continue;
            printWriter.println("ET");
        }
        printWriter.println("ET");
        printWriter.println("Q");
        printWriter.flush();
    }

    private PDFont getFontAndUpdateResources(List tokens, PDAppearanceStream appearanceStream) throws IOException {
        PDFont retval = null;
        PDResources streamResources = appearanceStream.getResources();
        PDResources formResources = this.acroForm.getDefaultResources();
        if (formResources != null) {
            COSString da;
            if (streamResources == null) {
                streamResources = new PDResources();
                appearanceStream.setResources(streamResources);
            }
            if ((da = this.getDefaultAppearance()) != null) {
                String data = da.getString();
                PDFStreamParser streamParser = new PDFStreamParser((InputStream)new ByteArrayInputStream(data.getBytes("ISO-8859-1")), null);
                streamParser.parse();
                tokens = streamParser.getTokens();
            }
            int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
            COSName cosFontName = (COSName)tokens.get(setFontIndex - 2);
            String fontName = cosFontName.getName();
            retval = streamResources.getFonts().get(fontName);
            if (retval == null) {
                retval = formResources.getFonts().get(fontName);
                streamResources.addFont(retval, fontName);
            }
        }
        return retval;
    }

    private boolean isMultiLineValue(String value) {
        return this.parent.isMultiline() && value.contains("\n");
    }

    private void writeToStream(byte[] data, PDAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getStream().createUnfilteredStream();
        out.write(data);
        out.flush();
    }

    private float getLineWidth(List tokens) {
        float retval = 1.0f;
        if (tokens != null) {
            int btIndex = tokens.indexOf(PDFOperator.getOperator("BT"));
            int wIndex = tokens.indexOf(PDFOperator.getOperator("w"));
            if (wIndex > 0 && wIndex < btIndex) {
                retval = ((COSNumber)tokens.get(wIndex - 1)).floatValue();
            }
        }
        return retval;
    }

    private PDRectangle getSmallestDrawnRectangle(PDRectangle boundingBox, List tokens) {
        PDRectangle smallest = boundingBox;
        for (int i = 0; i < tokens.size(); ++i) {
            Object next = tokens.get(i);
            if (next != PDFOperator.getOperator("re")) continue;
            COSNumber x = (COSNumber)tokens.get(i - 4);
            COSNumber y = (COSNumber)tokens.get(i - 3);
            COSNumber width = (COSNumber)tokens.get(i - 2);
            COSNumber height = (COSNumber)tokens.get(i - 1);
            PDRectangle potentialSmallest = new PDRectangle();
            potentialSmallest.setLowerLeftX(x.floatValue());
            potentialSmallest.setLowerLeftY(y.floatValue());
            potentialSmallest.setUpperRightX(x.floatValue() + width.floatValue());
            potentialSmallest.setUpperRightY(y.floatValue() + height.floatValue());
            if (smallest != null && !(smallest.getLowerLeftX() < potentialSmallest.getLowerLeftX()) && !(smallest.getUpperRightY() > potentialSmallest.getUpperRightY())) continue;
            smallest = potentialSmallest;
        }
        return smallest;
    }

    private float calculateFontSize(PDFont pdFont, PDRectangle boundingBox, List<Object> tokens, List<Object> daTokens) throws IOException {
        int fontIndex;
        float fontSize = 0.0f;
        if (daTokens != null && (fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"))) != -1) {
            fontSize = ((COSNumber)daTokens.get(fontIndex - 1)).floatValue();
        }
        float widthBasedFontSize = Float.MAX_VALUE;
        if (this.parent.doNotScroll()) {
            float widthAtFontSize1 = pdFont.getStringWidth(this.value) / 1000.0f;
            float availableWidth = this.getAvailableWidth(boundingBox, this.getLineWidth(tokens));
            widthBasedFontSize = availableWidth / widthAtFontSize1;
        } else if (fontSize == 0.0f) {
            float lineWidth = this.getLineWidth(tokens);
            float stringWidth = pdFont.getStringWidth(this.value);
            float height = 0.0f;
            height = pdFont instanceof PDSimpleFont ? ((PDSimpleFont)pdFont).getFontBoundingBox().getHeight() : pdFont.getAverageFontWidth();
            float availHeight = this.getAvailableHeight(boundingBox, lineWidth);
            fontSize = Math.min(availHeight / (height /= 1000.0f), widthBasedFontSize);
        }
        return fontSize;
    }

    private float calculateListboxFontSize(PDFont pdFont, PDRectangle contentArea, List tokens, List daTokens) throws IOException {
        int fontIndex;
        float fontSize = 0.0f;
        if (daTokens != null && (fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"))) != -1) {
            fontSize = ((COSNumber)daTokens.get(fontIndex - 1)).floatValue();
        }
        if (fontSize == 0.0f) {
            COSArray options = ((PDChoiceField)this.parent).getOptions();
            float maxOptWidth = 0.0f;
            for (int i = 0; i < options.size(); ++i) {
                COSBase option = options.getObject(i);
                COSArray optionPair = (COSArray)option;
                COSString optionValue = (COSString)optionPair.getObject(1);
                maxOptWidth = Math.max(pdFont.getStringWidth(optionValue.getString()) / 1000.0f, maxOptWidth);
            }
            float availableWidth = this.getAvailableWidth(contentArea, this.getLineWidth(tokens));
            fontSize = availableWidth / maxOptWidth;
        }
        return fontSize;
    }

    private String getTextPosition(PDRectangle boundingBox, PDFont pdFont, float fontSize, List tokens) throws IOException {
        float lineWidth = this.getLineWidth(tokens);
        float pos = 0.0f;
        if (this.parent.isMultiline()) {
            int rows = (int)(this.getAvailableHeight(boundingBox, lineWidth) / (float)((int)fontSize));
            pos = (float)rows * fontSize - fontSize;
        } else if (pdFont instanceof PDSimpleFont) {
            PDFontDescriptor fd = ((PDSimpleFont)pdFont).getFontDescriptor();
            float bBoxHeight = boundingBox.getHeight();
            float fontHeight = fd.getFontBoundingBox().getHeight() + 2.0f * fd.getDescent();
            fontHeight = fontHeight / 1000.0f * fontSize;
            pos = (bBoxHeight - fontHeight) / 2.0f;
        } else {
            throw new IOException("Error: Don't know how to calculate the position for non-simple fonts");
        }
        PDRectangle innerBox = this.getSmallestDrawnRectangle(boundingBox, tokens);
        float xInset = 2.0f + 2.0f * (boundingBox.getWidth() - innerBox.getWidth());
        return Math.round(xInset) + " " + pos + " Td";
    }

    private float getAvailableWidth(PDRectangle boundingBox, float lineWidth) {
        return boundingBox.getWidth() - 2.0f * lineWidth;
    }

    private float getAvailableHeight(PDRectangle boundingBox, float lineWidth) {
        return boundingBox.getHeight() - 2.0f * lineWidth;
    }
}

