/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MultiTermQuery;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;

public class QueryParserSettings {
    public static final boolean DEFAULT_ALLOW_LEADING_WILDCARD = true;
    public static final boolean DEFAULT_ANALYZE_WILDCARD = false;
    public static final float DEFAULT_BOOST = 1.0f;
    private String queryString;
    private String defaultField;
    private float boost = 1.0f;
    private QueryParser.Operator defaultOperator = QueryParser.Operator.OR;
    private boolean autoGeneratePhraseQueries = false;
    private boolean allowLeadingWildcard = true;
    private boolean lowercaseExpandedTerms = true;
    private boolean enablePositionIncrements = true;
    private int phraseSlop = 0;
    private float fuzzyMinSim = 2.0f;
    private int fuzzyPrefixLength = 0;
    private int fuzzyMaxExpansions = 50;
    private MultiTermQuery.RewriteMethod fuzzyRewriteMethod = null;
    private boolean analyzeWildcard = false;
    private boolean escape = false;
    private Analyzer defaultAnalyzer = null;
    private Analyzer defaultQuoteAnalyzer = null;
    private Analyzer forcedAnalyzer = null;
    private Analyzer forcedQuoteAnalyzer = null;
    private String quoteFieldSuffix = null;
    private MultiTermQuery.RewriteMethod rewriteMethod = MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    private String minimumShouldMatch;
    private boolean lenient;
    List<String> fields = null;
    Collection<String> queryTypes = null;
    ObjectFloatOpenHashMap<String> boosts = null;
    float tieBreaker = 0.0f;
    boolean useDisMax = true;

    public boolean isCacheable() {
        return !this.queryString.contains("now");
    }

    public String queryString() {
        return this.queryString;
    }

    public void queryString(String queryString) {
        this.queryString = queryString;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public void defaultField(String defaultField) {
        this.defaultField = defaultField;
    }

    public float boost() {
        return this.boost;
    }

    public void boost(float boost) {
        this.boost = boost;
    }

    public QueryParser.Operator defaultOperator() {
        return this.defaultOperator;
    }

    public void defaultOperator(QueryParser.Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public boolean autoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public void autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
    }

    public boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void allowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public boolean lowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    public void lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public int phraseSlop() {
        return this.phraseSlop;
    }

    public void phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public float fuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void fuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public int fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public int fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    public void fuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.fuzzyMaxExpansions = fuzzyMaxExpansions;
    }

    public MultiTermQuery.RewriteMethod fuzzyRewriteMethod() {
        return this.fuzzyRewriteMethod;
    }

    public void fuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public boolean escape() {
        return this.escape;
    }

    public void escape(boolean escape) {
        this.escape = escape;
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public void defaultAnalyzer(Analyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public Analyzer defaultQuoteAnalyzer() {
        return this.defaultQuoteAnalyzer;
    }

    public void defaultQuoteAnalyzer(Analyzer defaultAnalyzer) {
        this.defaultQuoteAnalyzer = defaultAnalyzer;
    }

    public Analyzer forcedAnalyzer() {
        return this.forcedAnalyzer;
    }

    public void forcedAnalyzer(Analyzer forcedAnalyzer) {
        this.forcedAnalyzer = forcedAnalyzer;
    }

    public Analyzer forcedQuoteAnalyzer() {
        return this.forcedQuoteAnalyzer;
    }

    public void forcedQuoteAnalyzer(Analyzer forcedAnalyzer) {
        this.forcedQuoteAnalyzer = forcedAnalyzer;
    }

    public boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    public void analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
    }

    public MultiTermQuery.RewriteMethod rewriteMethod() {
        return this.rewriteMethod;
    }

    public void rewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public void minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
    }

    public void quoteFieldSuffix(String quoteFieldSuffix) {
        this.quoteFieldSuffix = quoteFieldSuffix;
    }

    public String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    public void lenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public List<String> fields() {
        return this.fields;
    }

    public void fields(List<String> fields) {
        this.fields = fields;
    }

    public Collection<String> queryTypes() {
        return this.queryTypes;
    }

    public void queryTypes(Collection<String> queryTypes) {
        this.queryTypes = queryTypes;
    }

    public ObjectFloatOpenHashMap<String> boosts() {
        return this.boosts;
    }

    public void boosts(ObjectFloatOpenHashMap<String> boosts) {
        this.boosts = boosts;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    public void tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public boolean useDisMax() {
        return this.useDisMax;
    }

    public void useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParserSettings that = (QueryParserSettings)o;
        if (this.autoGeneratePhraseQueries != that.autoGeneratePhraseQueries()) {
            return false;
        }
        if (this.allowLeadingWildcard != that.allowLeadingWildcard) {
            return false;
        }
        if (Float.compare(that.boost, this.boost) != 0) {
            return false;
        }
        if (this.enablePositionIncrements != that.enablePositionIncrements) {
            return false;
        }
        if (this.escape != that.escape) {
            return false;
        }
        if (this.analyzeWildcard != that.analyzeWildcard) {
            return false;
        }
        if (Float.compare(that.fuzzyMinSim, this.fuzzyMinSim) != 0) {
            return false;
        }
        if (this.fuzzyPrefixLength != that.fuzzyPrefixLength) {
            return false;
        }
        if (this.fuzzyMaxExpansions != that.fuzzyMaxExpansions) {
            return false;
        }
        if (this.fuzzyRewriteMethod != null ? !this.fuzzyRewriteMethod.equals(that.fuzzyRewriteMethod) : that.fuzzyRewriteMethod != null) {
            return false;
        }
        if (this.lowercaseExpandedTerms != that.lowercaseExpandedTerms) {
            return false;
        }
        if (this.phraseSlop != that.phraseSlop) {
            return false;
        }
        if (this.defaultAnalyzer != null ? !this.defaultAnalyzer.equals(that.defaultAnalyzer) : that.defaultAnalyzer != null) {
            return false;
        }
        if (this.defaultQuoteAnalyzer != null ? !this.defaultQuoteAnalyzer.equals(that.defaultQuoteAnalyzer) : that.defaultQuoteAnalyzer != null) {
            return false;
        }
        if (this.forcedAnalyzer != null ? !this.forcedAnalyzer.equals(that.forcedAnalyzer) : that.forcedAnalyzer != null) {
            return false;
        }
        if (this.forcedQuoteAnalyzer != null ? !this.forcedQuoteAnalyzer.equals(that.forcedQuoteAnalyzer) : that.forcedQuoteAnalyzer != null) {
            return false;
        }
        if (this.defaultField != null ? !this.defaultField.equals(that.defaultField) : that.defaultField != null) {
            return false;
        }
        if (this.defaultOperator != that.defaultOperator) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) {
            return false;
        }
        if (this.rewriteMethod != null ? !this.rewriteMethod.equals(that.rewriteMethod) : that.rewriteMethod != null) {
            return false;
        }
        if (this.minimumShouldMatch != null ? !this.minimumShouldMatch.equals(that.minimumShouldMatch) : that.minimumShouldMatch != null) {
            return false;
        }
        if (this.quoteFieldSuffix != null ? !this.quoteFieldSuffix.equals(that.quoteFieldSuffix) : that.quoteFieldSuffix != null) {
            return false;
        }
        if (this.lenient != that.lenient) {
            return false;
        }
        if (Float.compare(that.tieBreaker, this.tieBreaker) != 0) {
            return false;
        }
        if (this.useDisMax != that.useDisMax) {
            return false;
        }
        if (this.boosts != null ? !this.boosts.equals(that.boosts) : that.boosts != null) {
            return false;
        }
        if (this.fields != null ? !((Object)this.fields).equals(that.fields) : that.fields != null) {
            return false;
        }
        return !(this.queryTypes != null ? !((Object)this.queryTypes).equals(that.queryTypes) : that.queryTypes != null);
    }

    public int hashCode() {
        int result = this.queryString != null ? this.queryString.hashCode() : 0;
        result = 31 * result + (this.defaultField != null ? this.defaultField.hashCode() : 0);
        result = 31 * result + (this.boost != 0.0f ? Float.floatToIntBits(this.boost) : 0);
        result = 31 * result + (this.defaultOperator != null ? this.defaultOperator.hashCode() : 0);
        result = 31 * result + (this.autoGeneratePhraseQueries ? 1 : 0);
        result = 31 * result + (this.allowLeadingWildcard ? 1 : 0);
        result = 31 * result + (this.lowercaseExpandedTerms ? 1 : 0);
        result = 31 * result + (this.enablePositionIncrements ? 1 : 0);
        result = 31 * result + this.phraseSlop;
        result = 31 * result + (this.fuzzyMinSim != 0.0f ? Float.floatToIntBits(this.fuzzyMinSim) : 0);
        result = 31 * result + this.fuzzyPrefixLength;
        result = 31 * result + (this.escape ? 1 : 0);
        result = 31 * result + (this.defaultAnalyzer != null ? this.defaultAnalyzer.hashCode() : 0);
        result = 31 * result + (this.defaultQuoteAnalyzer != null ? this.defaultQuoteAnalyzer.hashCode() : 0);
        result = 31 * result + (this.forcedAnalyzer != null ? this.forcedAnalyzer.hashCode() : 0);
        result = 31 * result + (this.forcedQuoteAnalyzer != null ? this.forcedQuoteAnalyzer.hashCode() : 0);
        result = 31 * result + (this.analyzeWildcard ? 1 : 0);
        result = 31 * result + (this.fields != null ? ((Object)this.fields).hashCode() : 0);
        result = 31 * result + (this.queryTypes != null ? ((Object)this.queryTypes).hashCode() : 0);
        result = 31 * result + (this.boosts != null ? this.boosts.hashCode() : 0);
        result = 31 * result + (this.tieBreaker != 0.0f ? Float.floatToIntBits(this.tieBreaker) : 0);
        result = 31 * result + (this.useDisMax ? 1 : 0);
        return result;
    }
}

