/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.shards;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterSearchShardsRequest
extends MasterNodeReadOperationRequest<ClusterSearchShardsRequest> {
    private String[] indices;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private String[] types = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.lenient();

    public ClusterSearchShardsRequest() {
    }

    public ClusterSearchShardsRequest(String ... indices) {
        this.indices(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterSearchShardsRequest indices(String ... indices) {
        if (indices == null) {
            throw new ElasticsearchIllegalArgumentException("indices must not be null");
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != null) continue;
            throw new ElasticsearchIllegalArgumentException("indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterSearchShardsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public ClusterSearchShardsRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ClusterSearchShardsRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ClusterSearchShardsRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public ClusterSearchShardsRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.readLocal(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
        this.writeLocal(out);
    }
}

