/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class GatewaySnapshotStatus {
    final Stage stage;
    final long startTime;
    final long time;
    final long indexSize;
    final int expectedNumberOfOperations;

    public GatewaySnapshotStatus(Stage stage, long startTime, long time, long indexSize, int expectedNumberOfOperations) {
        this.stage = stage;
        this.startTime = startTime;
        this.time = time;
        this.indexSize = indexSize;
        this.expectedNumberOfOperations = expectedNumberOfOperations;
    }

    public Stage getStage() {
        return this.stage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TimeValue getTime() {
        return TimeValue.timeValueMillis(this.time);
    }

    public ByteSizeValue getIndexSize() {
        return new ByteSizeValue(this.indexSize);
    }

    public int getExpectedNumberOfOperations() {
        return this.expectedNumberOfOperations;
    }

    public static enum Stage {
        NONE(0),
        INDEX(1),
        TRANSLOG(2),
        FINALIZE(3),
        DONE(4),
        FAILURE(5);

        private final byte value;

        private Stage(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Stage fromValue(byte value) {
            if (value == 0) {
                return NONE;
            }
            if (value == 1) {
                return INDEX;
            }
            if (value == 2) {
                return TRANSLOG;
            }
            if (value == 3) {
                return FINALIZE;
            }
            if (value == 4) {
                return DONE;
            }
            if (value == 5) {
                return FAILURE;
            }
            throw new ElasticsearchIllegalArgumentException("No stage found for [" + value + "]");
        }
    }
}

