/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class PathHierarchyTokenizerFactory
extends AbstractTokenizerFactory {
    private final int bufferSize;
    private final char delimiter;
    private final char replacement;
    private final int skip;
    private final boolean reverse;

    @Inject
    public PathHierarchyTokenizerFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.bufferSize = settings.getAsInt("buffer_size", (Integer)1024);
        String delimiter = settings.get("delimiter");
        if (delimiter == null) {
            this.delimiter = (char)47;
        } else {
            if (delimiter.length() > 1) {
                throw new ElasticsearchIllegalArgumentException("delimiter can only be a one char value");
            }
            this.delimiter = delimiter.charAt(0);
        }
        String replacement = settings.get("replacement");
        if (replacement == null) {
            this.replacement = this.delimiter;
        } else {
            if (replacement.length() > 1) {
                throw new ElasticsearchIllegalArgumentException("replacement can only be a one char value");
            }
            this.replacement = replacement.charAt(0);
        }
        this.skip = settings.getAsInt("skip", (Integer)0);
        this.reverse = settings.getAsBoolean("reverse", (Boolean)false);
    }

    @Override
    public Tokenizer create(Reader reader) {
        if (this.reverse) {
            return new ReversePathHierarchyTokenizer(reader, this.bufferSize, this.delimiter, this.replacement, this.skip);
        }
        return new PathHierarchyTokenizer(reader, this.bufferSize, this.delimiter, this.replacement, this.skip);
    }
}

