/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefOrdValComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefValComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class BytesRefFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    public static final BytesRef MAX_TERM = new BytesRef();
    private final IndexFieldData<?> indexFieldData;
    private final SortMode sortMode;
    private final Object missingValue;

    public BytesRefFieldComparatorSource(IndexFieldData<?> indexFieldData, Object missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.sortMode = sortMode;
        this.missingValue = missingValue;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.STRING;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        BytesRef missingBytes = (BytesRef)this.missingObject(this.missingValue, reversed);
        if (this.indexFieldData.valuesOrdered() && this.indexFieldData instanceof IndexFieldData.WithOrdinals) {
            return new BytesRefOrdValComparator((IndexFieldData.WithOrdinals)this.indexFieldData, numHits, this.sortMode, missingBytes);
        }
        return new BytesRefValComparator(this.indexFieldData, numHits, this.sortMode, missingBytes);
    }

    static {
        char[] chars = Character.toChars(0x10FFFF);
        UnicodeUtil.UTF16toUTF8((char[])chars, (int)0, (int)chars.length, (BytesRef)MAX_TERM);
    }
}

