/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.RateLimiter;

public class RateLimitingInputStream
extends InputStream {
    private final InputStream delegate;
    private final RateLimiter rateLimiter;
    private final Listener listener;

    public RateLimitingInputStream(InputStream delegate, RateLimiter rateLimiter, Listener listener) {
        this.delegate = delegate;
        this.rateLimiter = rateLimiter;
        this.listener = listener;
    }

    @Override
    public int read() throws IOException {
        int b = this.delegate.read();
        long pause = this.rateLimiter.pause(1L);
        if (pause > 0L) {
            this.listener.onPause(pause);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.delegate.read(b, off, len);
        if (n > 0) {
            this.listener.onPause(this.rateLimiter.pause((long)n));
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public static interface Listener {
        public void onPause(long var1);
    }
}

