/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

class RecoveryFileChunkRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private String name;
    private long position;
    private long length;
    private String checksum;
    private BytesReference content;

    RecoveryFileChunkRequest() {
    }

    RecoveryFileChunkRequest(long recoveryId, ShardId shardId, String name, long position, long length, String checksum, BytesArray content) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.name = name;
        this.position = position;
        this.length = length;
        this.checksum = checksum;
        this.content = content;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String name() {
        return this.name;
    }

    public long position() {
        return this.position;
    }

    @Nullable
    public String checksum() {
        return this.checksum;
    }

    public long length() {
        return this.length;
    }

    public BytesReference content() {
        return this.content;
    }

    public RecoveryFileChunkRequest readFileChunk(StreamInput in) throws IOException {
        RecoveryFileChunkRequest request = new RecoveryFileChunkRequest();
        request.readFrom(in);
        return request;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.name = in.readString();
        this.position = in.readVLong();
        this.length = in.readVLong();
        this.checksum = in.readOptionalString();
        this.content = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.name);
        out.writeVLong(this.position);
        out.writeVLong(this.length);
        out.writeOptionalString(this.checksum);
        out.writeBytesReference(this.content);
    }

    public String toString() {
        return this.shardId + ": name='" + this.name + '\'' + ", position=" + this.position + ", length=" + this.length;
    }
}

