/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RecoveryTarget
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    private final ConcurrentMapLong<RecoveryStatus> onGoingRecoveries = ConcurrentCollections.newConcurrentMapLong();

    @Inject
    public RecoveryTarget(Settings settings, ThreadPool threadPool, TransportService transportService, IndicesService indicesService, IndicesLifecycle indicesLifecycle, RecoverySettings recoverySettings) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        transportService.registerHandler("index/shard/recovery/filesInfo", new FilesInfoRequestHandler());
        transportService.registerHandler("index/shard/recovery/fileChunk", new FileChunkTransportRequestHandler());
        transportService.registerHandler("index/shard/recovery/cleanFiles", new CleanFilesRequestHandler());
        transportService.registerHandler("index/shard/recovery/prepareTranslog", new PrepareForTranslogOperationsRequestHandler());
        transportService.registerHandler("index/shard/recovery/translogOps", new TranslogOperationsRequestHandler());
        transportService.registerHandler("index/shard/recovery/finalize", new FinalizeRecoveryRequestHandler());
        indicesLifecycle.addListener(new IndicesLifecycle.Listener(){

            @Override
            public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard) {
                if (indexShard != null) {
                    RecoveryTarget.this.removeAndCleanOnGoingRecovery(RecoveryTarget.this.findRecoveryByShard(indexShard));
                }
            }
        });
    }

    public RecoveryStatus peerRecoveryStatus(ShardId shardId) {
        RecoveryStatus peerRecoveryStatus = this.findRecoveryByShardId(shardId);
        if (peerRecoveryStatus == null) {
            return null;
        }
        if (peerRecoveryStatus.startTime > 0L && peerRecoveryStatus.stage != RecoveryStatus.Stage.DONE) {
            peerRecoveryStatus.time = System.currentTimeMillis() - peerRecoveryStatus.startTime;
        }
        return peerRecoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRecovery(IndexShard indexShard) {
        RecoveryStatus recoveryStatus = this.findRecoveryByShard(indexShard);
        if (recoveryStatus == null) {
            return;
        }
        if (recoveryStatus.sentCanceledToSource) {
            return;
        }
        recoveryStatus.cancel();
        try {
            if (recoveryStatus.recoveryThread != null) {
                recoveryStatus.recoveryThread.interrupt();
            }
            long sleepTime = 100L;
            long maxSleepTime = 10000L;
            for (long rounds = (long)Math.round(100.0f); !recoveryStatus.sentCanceledToSource && rounds > 0L; --rounds) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        finally {
            this.removeAndCleanOnGoingRecovery(recoveryStatus);
        }
    }

    public void startRecovery(final StartRecoveryRequest request, final InternalIndexShard indexShard, final RecoveryListener listener) {
        try {
            indexShard.recovering("from " + request.sourceNode());
        }
        catch (IllegalIndexShardStateException e) {
            listener.onIgnoreRecovery(false, "already in recovering process, " + e.getMessage());
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                RecoveryStatus recoveryStatus = new RecoveryStatus(request.recoveryId(), indexShard);
                RecoveryTarget.this.onGoingRecoveries.put(recoveryStatus.recoveryId, recoveryStatus);
                RecoveryTarget.this.doRecovery(request, recoveryStatus, listener);
            }
        });
    }

    public void retryRecovery(final StartRecoveryRequest request, final RecoveryStatus status, final RecoveryListener listener) {
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                RecoveryTarget.this.doRecovery(request, status, listener);
            }
        });
    }

    private void doRecovery(StartRecoveryRequest request, RecoveryStatus recoveryStatus, RecoveryListener listener) {
        if (request.sourceNode() == null) {
            listener.onIgnoreRecovery(false, "No node to recover from, retry on next cluster state update");
            return;
        }
        InternalIndexShard shard = recoveryStatus.indexShard;
        if (shard == null) {
            listener.onIgnoreRecovery(false, "shard missing locally, stop recovery");
            return;
        }
        if (shard.state() == IndexShardState.CLOSED) {
            listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
            return;
        }
        if (recoveryStatus.isCanceled()) {
            listener.onIgnoreRecovery(false, "canceled recovery");
            return;
        }
        recoveryStatus.recoveryThread = Thread.currentThread();
        try {
            this.logger.trace("[{}][{}] starting recovery from {}", request.shardId().index().name(), request.shardId().id(), request.sourceNode());
            StopWatch stopWatch = new StopWatch().start();
            RecoveryResponse recoveryResponse = this.transportService.submitRequest(request.sourceNode(), "index/shard/recovery/startRecovery", request, new FutureTransportResponseHandler<RecoveryResponse>(){

                @Override
                public RecoveryResponse newInstance() {
                    return new RecoveryResponse();
                }
            }).txGet();
            if (shard.state() == IndexShardState.CLOSED) {
                this.removeAndCleanOnGoingRecovery(recoveryStatus);
                listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
                return;
            }
            stopWatch.stop();
            if (this.logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append(request.shardId().index().name()).append(']').append('[').append(request.shardId().id()).append("] ");
                sb.append("recovery completed from ").append(request.sourceNode()).append(", took[").append(stopWatch.totalTime()).append("]\n");
                sb.append("   phase1: recovered_files [").append(recoveryResponse.phase1FileNames.size()).append("]").append(" with total_size of [").append(new ByteSizeValue(recoveryResponse.phase1TotalSize)).append("]").append(", took [").append(TimeValue.timeValueMillis(recoveryResponse.phase1Time)).append("], throttling_wait [").append(TimeValue.timeValueMillis(recoveryResponse.phase1ThrottlingWaitTime)).append(']').append("\n");
                sb.append("         : reusing_files   [").append(recoveryResponse.phase1ExistingFileNames.size()).append("] with total_size of [").append(new ByteSizeValue(recoveryResponse.phase1ExistingTotalSize)).append("]\n");
                sb.append("   phase2: start took [").append(TimeValue.timeValueMillis(recoveryResponse.startTime)).append("]\n");
                sb.append("         : recovered [").append(recoveryResponse.phase2Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis(recoveryResponse.phase2Time)).append("]").append("\n");
                sb.append("   phase3: recovered [").append(recoveryResponse.phase3Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis(recoveryResponse.phase3Time)).append("]");
                this.logger.trace(sb.toString(), new Object[0]);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("recovery completed from [{}], took [{}]", request.shardId(), request.sourceNode(), stopWatch.totalTime());
            }
            this.removeAndCleanOnGoingRecovery(recoveryStatus);
            listener.onRecoveryDone();
        }
        catch (Throwable e) {
            if (recoveryStatus.isCanceled()) {
                listener.onIgnoreRecovery(false, "canceled recovery");
                return;
            }
            if (shard.state() == IndexShardState.CLOSED) {
                this.removeAndCleanOnGoingRecovery(recoveryStatus);
                listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
                return;
            }
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            if (cause instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if ((cause = ExceptionsHelper.unwrapCause(cause)) instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if (cause instanceof IndexShardNotStartedException || cause instanceof IndexMissingException || cause instanceof IndexShardMissingException) {
                listener.onRetryRecovery(TimeValue.timeValueMillis(500L), recoveryStatus);
                return;
            }
            if (cause instanceof DelayRecoveryException) {
                listener.onRetryRecovery(TimeValue.timeValueMillis(500L), recoveryStatus);
                return;
            }
            this.removeAndCleanOnGoingRecovery(recoveryStatus);
            if (cause instanceof ConnectTransportException) {
                listener.onIgnoreRecovery(true, "source node disconnected (" + request.sourceNode() + ")");
                return;
            }
            if (cause instanceof IndexShardClosedException) {
                listener.onIgnoreRecovery(true, "source shard is closed (" + request.sourceNode() + ")");
                return;
            }
            if (cause instanceof AlreadyClosedException) {
                listener.onIgnoreRecovery(true, "source shard is closed (" + request.sourceNode() + ")");
                return;
            }
            this.logger.trace("[{}][{}] recovery from [{}] failed", e, request.shardId().index().name(), request.shardId().id(), request.sourceNode());
            listener.onRecoveryFailure(new RecoveryFailedException(request, e), true);
        }
    }

    @Nullable
    private RecoveryStatus findRecoveryByShardId(ShardId shardId) {
        for (RecoveryStatus recoveryStatus : this.onGoingRecoveries.values()) {
            if (!recoveryStatus.shardId.equals(shardId)) continue;
            return recoveryStatus;
        }
        return null;
    }

    @Nullable
    private RecoveryStatus findRecoveryByShard(IndexShard indexShard) {
        for (RecoveryStatus recoveryStatus : this.onGoingRecoveries.values()) {
            if (recoveryStatus.indexShard != indexShard) continue;
            return recoveryStatus;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndCleanOnGoingRecovery(@Nullable RecoveryStatus status) {
        if (status == null) {
            return;
        }
        status = this.onGoingRecoveries.remove(status.recoveryId);
        if (status == null) {
            return;
        }
        status.cancel();
        Set<Map.Entry<String, IndexOutput>> entrySet = status.cancleAndClearOpenIndexInputs();
        Iterator<Map.Entry<String, IndexOutput>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IndexOutput> entry = iterator.next();
            IndexOutput indexOutput = entry.getValue();
            synchronized (indexOutput) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)entry.getValue()});
            }
            iterator.remove();
        }
        status.checksums = null;
    }

    class FileChunkTransportRequestHandler
    extends BaseTransportRequestHandler<RecoveryFileChunkRequest> {
        FileChunkTransportRequestHandler() {
        }

        @Override
        public RecoveryFileChunkRequest newInstance() {
            return new RecoveryFileChunkRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(RecoveryFileChunkRequest request, TransportChannel channel) throws Exception {
            IndexOutput indexOutput;
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            Store store = onGoingRecovery.indexShard.store();
            if (request.position() == 0L) {
                onGoingRecovery.checksums.remove(request.name());
                indexOutput = onGoingRecovery.removeOpenIndexOutputs(request.name());
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexOutput});
                String fileName = request.name();
                if (store.directory().fileExists(fileName)) {
                    fileName = "recovery." + onGoingRecovery.startTime + "." + fileName;
                }
                indexOutput = onGoingRecovery.openAndPutIndexOutput(request.name(), fileName, store);
            } else {
                indexOutput = onGoingRecovery.getOpenIndexOutput(request.name());
            }
            if (indexOutput == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            boolean success = false;
            IndexOutput indexOutput2 = indexOutput;
            synchronized (indexOutput2) {
                block19: {
                    block20: {
                        try {
                            BytesReference content;
                            if (RecoveryTarget.this.recoverySettings.rateLimiter() != null) {
                                RecoveryTarget.this.recoverySettings.rateLimiter().pause((long)request.content().length());
                            }
                            if (!(content = request.content()).hasArray()) {
                                content = content.toBytesArray();
                            }
                            indexOutput.writeBytes(content.array(), content.arrayOffset(), content.length());
                            onGoingRecovery.currentFilesSize.addAndGet(request.length());
                            if (indexOutput.getFilePointer() == request.length()) {
                                indexOutput.close();
                                if (request.checksum() != null) {
                                    onGoingRecovery.checksums.put(request.name(), request.checksum());
                                }
                                store.directory().sync(Collections.singleton(request.name()));
                                IndexOutput remove = onGoingRecovery.removeOpenIndexOutputs(request.name());
                                assert (remove == indexOutput);
                            }
                            if ((success = true) && !onGoingRecovery.isCanceled()) break block19;
                            IndexOutput remove = onGoingRecovery.removeOpenIndexOutputs(request.name());
                            if ($assertionsDisabled || remove == indexOutput) break block20;
                        }
                        catch (Throwable throwable) {
                            if (!success || onGoingRecovery.isCanceled()) {
                                IndexOutput remove = onGoingRecovery.removeOpenIndexOutputs(request.name());
                                assert (remove == indexOutput);
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexOutput});
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexOutput});
                }
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class CleanFilesRequestHandler
    extends BaseTransportRequestHandler<RecoveryCleanFilesRequest> {
        CleanFilesRequestHandler() {
        }

        @Override
        public RecoveryCleanFilesRequest newInstance() {
            return new RecoveryCleanFilesRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryCleanFilesRequest request, TransportChannel channel) throws Exception {
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            Store store = onGoingRecovery.indexShard.store();
            String prefix = "recovery." + onGoingRecovery.startTime + ".";
            HashSet<String> filesToRename = Sets.newHashSet();
            for (String existingFile : store.directory().listAll()) {
                if (!existingFile.startsWith(prefix)) continue;
                filesToRename.add(existingFile.substring(prefix.length(), existingFile.length()));
            }
            Object failureToRename = null;
            if (!filesToRename.isEmpty()) {
                Directory directory = store.directory();
                for (String file : filesToRename) {
                    try {
                        directory.deleteFile(file);
                    }
                    catch (Throwable ex) {
                        RecoveryTarget.this.logger.debug("failed to delete file [{}]", ex, file);
                    }
                }
                for (String fileToRename : filesToRename) {
                    store.renameFile(prefix + fileToRename, fileToRename);
                }
            }
            store.writeChecksums(onGoingRecovery.checksums);
            for (String existingFile : store.directory().listAll()) {
                if (request.snapshotFiles().contains(existingFile) || Store.isChecksum(existingFile)) continue;
                try {
                    store.directory().deleteFile(existingFile);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class FilesInfoRequestHandler
    extends BaseTransportRequestHandler<RecoveryFilesInfoRequest> {
        FilesInfoRequestHandler() {
        }

        @Override
        public RecoveryFilesInfoRequest newInstance() {
            return new RecoveryFilesInfoRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryFilesInfoRequest request, TransportChannel channel) throws Exception {
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            onGoingRecovery.phase1FileNames = request.phase1FileNames;
            onGoingRecovery.phase1FileSizes = request.phase1FileSizes;
            onGoingRecovery.phase1ExistingFileNames = request.phase1ExistingFileNames;
            onGoingRecovery.phase1ExistingFileSizes = request.phase1ExistingFileSizes;
            onGoingRecovery.phase1TotalSize = request.phase1TotalSize;
            onGoingRecovery.phase1ExistingTotalSize = request.phase1ExistingTotalSize;
            onGoingRecovery.stage = RecoveryStatus.Stage.INDEX;
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class TranslogOperationsRequestHandler
    extends BaseTransportRequestHandler<RecoveryTranslogOperationsRequest> {
        TranslogOperationsRequestHandler() {
        }

        @Override
        public RecoveryTranslogOperationsRequest newInstance() {
            return new RecoveryTranslogOperationsRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryTranslogOperationsRequest request, TransportChannel channel) throws Exception {
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
            for (Translog.Operation operation : request.operations()) {
                if (onGoingRecovery.isCanceled()) {
                    onGoingRecovery.sentCanceledToSource = true;
                    throw new IndexShardClosedException(request.shardId());
                }
                shard.performRecoveryOperation(operation);
                ++onGoingRecovery.currentTranslogOperations;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class FinalizeRecoveryRequestHandler
    extends BaseTransportRequestHandler<RecoveryFinalizeRecoveryRequest> {
        FinalizeRecoveryRequestHandler() {
        }

        @Override
        public RecoveryFinalizeRecoveryRequest newInstance() {
            return new RecoveryFinalizeRecoveryRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryFinalizeRecoveryRequest request, TransportChannel channel) throws Exception {
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            onGoingRecovery.stage = RecoveryStatus.Stage.FINALIZE;
            onGoingRecovery.indexShard.performRecoveryFinalization(false, onGoingRecovery);
            onGoingRecovery.time = System.currentTimeMillis() - onGoingRecovery.startTime;
            onGoingRecovery.stage = RecoveryStatus.Stage.DONE;
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class PrepareForTranslogOperationsRequestHandler
    extends BaseTransportRequestHandler<RecoveryPrepareForTranslogOperationsRequest> {
        PrepareForTranslogOperationsRequestHandler() {
        }

        @Override
        public RecoveryPrepareForTranslogOperationsRequest newInstance() {
            return new RecoveryPrepareForTranslogOperationsRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryPrepareForTranslogOperationsRequest request, TransportChannel channel) throws Exception {
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(request.shardId());
            }
            if (onGoingRecovery.isCanceled()) {
                onGoingRecovery.sentCanceledToSource = true;
                throw new IndexShardClosedException(request.shardId());
            }
            onGoingRecovery.stage = RecoveryStatus.Stage.TRANSLOG;
            onGoingRecovery.indexShard.performRecoveryPrepareForTranslog();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static interface RecoveryListener {
        public void onRecoveryDone();

        public void onRetryRecovery(TimeValue var1, RecoveryStatus var2);

        public void onIgnoreRecovery(boolean var1, String var2);

        public void onRecoveryFailure(RecoveryFailedException var1, boolean var2);
    }

    public static class Actions {
        public static final String FILES_INFO = "index/shard/recovery/filesInfo";
        public static final String FILE_CHUNK = "index/shard/recovery/fileChunk";
        public static final String CLEAN_FILES = "index/shard/recovery/cleanFiles";
        public static final String TRANSLOG_OPS = "index/shard/recovery/translogOps";
        public static final String PREPARE_TRANSLOG = "index/shard/recovery/prepareTranslog";
        public static final String FINALIZE = "index/shard/recovery/finalize";
    }
}

