/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.FieldDataSource;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.geopoints.GeoPointValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class GeoHashGridParser
implements Aggregator.Parser {
    public static final int DEFAULT_PRECISION = 5;
    public static final int DEFAULT_MAX_NUM_CELLS = 10000;

    @Override
    public String type() {
        return InternalGeoHashGrid.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String field = null;
        int precision = 5;
        int requiredSize = 10000;
        int shardSize = 0;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (!"field".equals(currentFieldName)) continue;
                field = parser.text();
                continue;
            }
            if (token != XContentParser.Token.VALUE_NUMBER) continue;
            if ("precision".equals(currentFieldName)) {
                precision = parser.intValue();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                requiredSize = parser.intValue();
                continue;
            }
            if (!"shard_size".equals(currentFieldName) && !"shardSize".equals(currentFieldName)) continue;
            shardSize = parser.intValue();
        }
        if (shardSize == 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize, context.numberOfShards());
        }
        ValuesSourceConfig<GeoPointValuesSource> config = new ValuesSourceConfig<GeoPointValuesSource>(GeoPointValuesSource.class);
        if (field == null) {
            return new GeoGridFactory(aggregationName, config, precision, requiredSize, shardSize);
        }
        FieldMapper mapper = context.smartNameFieldMapper(field);
        if (mapper == null) {
            config.unmapped(true);
            return new GeoGridFactory(aggregationName, config, precision, requiredSize, shardSize);
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        return new GeoGridFactory(aggregationName, config, precision, requiredSize, shardSize);
    }

    private static class GeoGridFactory
    extends ValueSourceAggregatorFactory<GeoPointValuesSource> {
        private int precision;
        private int requiredSize;
        private int shardSize;

        public GeoGridFactory(String name, ValuesSourceConfig<GeoPointValuesSource> valueSourceConfig, int precision, int requiredSize, int shardSize) {
            super(name, InternalGeoHashGrid.TYPE.name(), valueSourceConfig);
            this.precision = precision;
            this.requiredSize = requiredSize;
            this.shardSize = shardSize;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new GeoHashGridAggregator.Unmapped(this.name, this.requiredSize, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(GeoPointValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            CellValues cellIdValues = new CellValues(valuesSource, this.precision);
            FieldDataSource.Numeric cellIdSource = new CellIdSource(cellIdValues, valuesSource.metaData());
            if (((FieldDataSource)cellIdSource).metaData().multiValued()) {
                cellIdSource = new FieldDataSource.Numeric.SortedAndUnique(cellIdSource);
            }
            NumericValuesSource geohashIdSource = new NumericValuesSource(cellIdSource, null, null);
            return new GeoHashGridAggregator(this.name, this.factories, geohashIdSource, this.requiredSize, this.shardSize, aggregationContext, parent);
        }

        private static class CellIdSource
        extends FieldDataSource.Numeric {
            private final LongValues values;
            private FieldDataSource.MetaData metaData;

            public CellIdSource(LongValues values, FieldDataSource.MetaData delegate) {
                this.values = values;
                this.metaData = FieldDataSource.MetaData.builder(delegate).uniqueness(FieldDataSource.MetaData.Uniqueness.UNKNOWN).build();
            }

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public LongValues longValues() {
                return this.values;
            }

            @Override
            public DoubleValues doubleValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytesValues bytesValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public FieldDataSource.MetaData metaData() {
                return this.metaData;
            }
        }

        private static class CellValues
        extends LongValues {
            private GeoPointValuesSource geoPointValues;
            private GeoPointValues geoValues;
            private int precision;

            protected CellValues(GeoPointValuesSource geoPointValues, int precision) {
                super(true);
                this.geoPointValues = geoPointValues;
                this.precision = precision;
            }

            @Override
            public int setDocument(int docId) {
                this.geoValues = this.geoPointValues.values();
                return this.geoValues.setDocument(docId);
            }

            @Override
            public long nextValue() {
                GeoPoint target = this.geoValues.nextValue();
                return GeoHashUtils.encodeAsLong(target.getLat(), target.getLon(), this.precision);
            }
        }
    }
}

