/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.index;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;

public class IndexNameFacetExecutor
extends FacetExecutor {
    private final String indexName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private int count = 0;

    public IndexNameFacetExecutor(String indexName, TermsFacet.ComparatorType comparatorType, int size) {
        this.indexName = indexName;
        this.comparatorType = comparatorType;
        this.size = size;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, Sets.newHashSet(new InternalStringTermsFacet.TermEntry(this.indexName, this.count)), 0L, this.count);
    }

    class Collector
    extends FacetExecutor.Collector {
        private int count;

        Collector() {
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
        }

        public void collect(int doc) throws IOException {
            ++this.count;
        }

        @Override
        public void postCollection() {
            IndexNameFacetExecutor.this.count = this.count;
        }
    }
}

