/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLAttribute
extends SAMLObject
implements Cloneable {
    private static String factoryClass = null;
    protected String name = null;
    protected String namespace = null;
    protected QName type = null;
    protected long lifetime = 0L;
    protected ArrayList values = new ArrayList();

    public static synchronized String setFactory(String string) {
        String string2 = factoryClass;
        factoryClass = string;
        return string2;
    }

    public static synchronized String getFactory() {
        return factoryClass;
    }

    public static SAMLAttribute getInstance(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute.getInstance() given an empty DOM");
        }
        String string = SAMLAttribute.getFactory();
        if (string == null) {
            return new SAMLAttribute(element);
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Element.class};
            Object[] objectArray = new Object[]{element};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (SAMLAttribute)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to locate attribute factory class (" + string + ")", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to bind to constructor for attribute", (Exception)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to build implementation object for attribute", (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to access attribute factory", (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAMLException) {
                throw (SAMLException)throwable;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() caught unknown exception while building attribute object: " + throwable.getMessage());
        }
    }

    public static SAMLAttribute getInstance(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return SAMLAttribute.getInstance(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLAttribute").error((Object)("caught an exception while parsing a stream:\n" + sAXException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)sAXException);
        }
        catch (IOException iOException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLAttribute").error((Object)("caught an exception while parsing a stream:\n" + iOException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)iOException);
        }
    }

    public SAMLAttribute() {
    }

    public SAMLAttribute(String string, String string2, QName qName, long l, Collection collection) throws SAMLException {
        this.name = XML.assign(string);
        this.namespace = XML.assign(string2);
        this.type = qName;
        this.lifetime = l;
        if (collection != null) {
            this.values.addAll(collection);
        }
    }

    public SAMLAttribute(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttribute(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttribute.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute")) {
            throw new MalformedException("SAMLAttribute.fromDOM() requires saml:Attribute at root");
        }
        this.name = XML.assign(element.getAttributeNS(null, "AttributeName"));
        this.namespace = XML.assign(element.getAttributeNS(null, "AttributeNamespace"));
        Element element2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
        while (element2 != null) {
            if (this.type == null) {
                this.type = XML.getQNameAttribute(element2, "http://www.w3.org/2001/XMLSchema-instance", "type");
            }
            this.valueFromDOM(element2);
            element2 = XML.getNextSiblingElement(element2);
        }
        this.checkValidity();
    }

    protected void valueFromDOM(Element element) throws SAMLException {
        Node node = element.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            this.values.add(node.getNodeValue());
        } else if (node == null) {
            this.values.add("");
        } else {
            this.values.add("");
            this.log.warn((Object)"skipping AttributeValue element without a simple text node");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
        this.setDirty(true);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = string;
        this.setDirty(true);
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName qName) {
        this.type = qName;
        this.setDirty(true);
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long l) {
        this.lifetime = l;
    }

    public Iterator getValues() {
        return this.values.iterator();
    }

    public NodeList getValueElements() {
        return !this.dirty && this.root != null ? ((Element)this.root).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue") : null;
    }

    public void setValues(Collection collection) throws SAMLException {
        this.values.clear();
        if (collection != null) {
            this.values.addAll(collection);
        }
        this.setDirty(true);
    }

    public void addValue(Object object) throws SAMLException {
        if (object != null) {
            this.values.add(object);
        } else {
            this.values.add("");
        }
        this.setDirty(true);
    }

    public void removeValue(int n) throws IndexOutOfBoundsException {
        this.values.remove(n);
        this.setDirty(true);
    }

    protected String computeTypeDecl(Element element) {
        String string = null;
        element.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens");
        if (this.type != null) {
            String string2;
            if ("http://www.w3.org/2001/XMLSchema".equals(this.type.getNamespaceURI())) {
                string2 = "xsd";
            } else {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens", this.type.getNamespaceURI());
                string2 = "typens";
            }
            string = string2 + ":" + this.type.getLocalPart();
        }
        return string;
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return element;
    }

    protected void valueToDOM(int n, Element element) throws SAMLException {
        String string = this.values.get(n).toString();
        if (!XML.isEmpty(string)) {
            element.appendChild(element.getOwnerDocument().createTextNode(string));
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            element.setAttributeNS(null, "AttributeName", this.name);
            element.setAttributeNS(null, "AttributeNamespace", this.namespace);
            String string = this.computeTypeDecl(element);
            for (int i = 0; i < this.values.size(); ++i) {
                Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
                if (string != null) {
                    element2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", string);
                }
                this.valueToDOM(i, element2);
                element.appendChild(element2);
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name) || XML.isEmpty(this.namespace) || this.values.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "Attribute invalid, requires name and namespace, and at least one value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttribute sAMLAttribute = (SAMLAttribute)super.clone();
        sAMLAttribute.values = (ArrayList)this.values.clone();
        return sAMLAttribute;
    }
}

