/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.HashMap;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class SetPriorityThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: SetPriorityThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final int cycleCount;
    protected final BlockingDocuments blockingDocuments;
    protected final String processID;

    public SetPriorityThread(int workerThreadCount, BlockingDocuments blockingDocuments, String processID) throws ManifoldCFException {
        this.blockingDocuments = blockingDocuments;
        this.processID = processID;
        this.cycleCount = workerThreadCount * 10;
        this.setName("Set priority thread");
        this.setDaemon(true);
        this.setPriority(10);
    }

    @Override
    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            Logging.threads.debug((Object)"Set priority thread coming up");
            HashMap<Long, IJobDescription> jobDescriptionMap = new HashMap<Long, IJobDescription>();
            HashMap<String, IRepositoryConnection> connectionMap = new HashMap<String, IRepositoryConnection>();
            while (true) {
                try {
                    block10: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        Logging.threads.debug((Object)"Set priority thread woke up");
                        long currentTime = System.currentTimeMillis();
                        jobDescriptionMap.clear();
                        connectionMap.clear();
                        int processedCount = 0;
                        while (true) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new ManifoldCFException("Interrupted", 2);
                            }
                            if (processedCount >= this.cycleCount) {
                                Logging.threads.debug((Object)"Done reprioritizing because exceeded cycle count");
                                continue block10;
                            }
                            DocumentDescription desc = this.blockingDocuments.getBlockingDocument();
                            if (desc != null) {
                                ManifoldCF.writeDocumentPriorities(threadContext, new DocumentDescription[]{desc}, connectionMap, jobDescriptionMap);
                                ++processedCount;
                                continue;
                            }
                            DocumentDescription[] descs = jobManager.getNextNotYetProcessedReprioritizationDocuments(this.processID, 1000);
                            if (descs.length <= 0) break;
                            ManifoldCF.writeDocumentPriorities(threadContext, descs, connectionMap, jobDescriptionMap);
                            processedCount += descs.length;
                        }
                        Logging.threads.debug((Object)"Done reprioritizing because no more documents to reprioritize");
                        ManifoldCF.sleep((long)5000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Set priority thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    ManifoldCF.systemExit((int)1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("SetPriorityThread initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }
}

