/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser.token;

import java.net.URL;
import java.security.SecureRandom;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SimpleTokenHandlerSessionHelper {
    public static final String ATTR_CMIS_USER = "cmis-token.user";
    public static final String ATTR_CMIS_AUTH_TIMESTAMP = "cmis-token.timestamp";
    public static final String ATTR_CMIS_TOKEN = "cmis-token.token";
    public static final String ATTR_CMIS_LOGIN_KEY = "cmis-token.token.loginkey";
    public static final String ATTR_CMIS_FORM_KEY = "cmis-token.formkey";
    public static final String ATTR_CMIS_APP_URL = "cmis-token.appurl";
    public static final String ATTR_CMIS_APP_KEY = "cmis-token.appkey";
    public static final String ATTR_SEPARATOR = "\n";
    public static final String PARAM_KEY = "key";
    public static final String PARAM_TOKEN = "token";
    public static final String PARAM_URL = "url";
    public static final String PARAM_USER = "user";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_TRUSTAPP = "trustapp";
    public static final int APP_ID_BYTES = 10;
    public static final int APP_ID_LENGTH = 20;
    public static final int KEY_BYTES = 20;
    public static final int KEY_LENGTH = 40;

    public static String getApplicationIdFromKey(String key) {
        if (key == null || key.length() != 60) {
            return null;
        }
        return key.substring(0, 20);
    }

    public static String getLoginKey(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return null;
        }
        return (String)hs.getAttribute(ATTR_CMIS_LOGIN_KEY + appId);
    }

    public static void setLoginKey(HttpServletRequest request, String loginKey, String formKey, URL appURL) {
        HttpSession hs = request.getSession();
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(loginKey);
        hs.setAttribute(ATTR_CMIS_LOGIN_KEY + appId, (Object)loginKey);
        hs.setAttribute(ATTR_CMIS_FORM_KEY + appId, (Object)formKey);
        hs.setAttribute(ATTR_CMIS_APP_URL + appId, (Object)appURL);
    }

    public static boolean checkLoginKey(HttpServletRequest request) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return false;
        }
        String key = SimpleTokenHandlerSessionHelper.getKey(request);
        if (key == null) {
            return false;
        }
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(key);
        if (appId == null) {
            return false;
        }
        return key.equals(hs.getAttribute(ATTR_CMIS_LOGIN_KEY + appId));
    }

    public static void removeLoginKey(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return;
        }
        hs.removeAttribute(ATTR_CMIS_LOGIN_KEY + appId);
    }

    public static boolean checkFormKey(HttpServletRequest request) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return false;
        }
        String formKey = SimpleTokenHandlerSessionHelper.getKey(request);
        if (formKey == null) {
            return false;
        }
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(formKey);
        if (appId == null) {
            return false;
        }
        return formKey.equals(hs.getAttribute(ATTR_CMIS_FORM_KEY + appId));
    }

    public static void removeFormKey(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return;
        }
        hs.removeAttribute(ATTR_CMIS_FORM_KEY + appId);
    }

    public static String getUser(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return null;
        }
        return (String)hs.getAttribute(ATTR_CMIS_USER + appId);
    }

    public static void setUser(HttpServletRequest request, String appId, String user) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return;
        }
        hs.setAttribute(ATTR_CMIS_USER + appId, (Object)user);
        hs.setAttribute(ATTR_CMIS_AUTH_TIMESTAMP + appId, (Object)System.currentTimeMillis());
    }

    public static String getApplicationKey(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return null;
        }
        return (String)hs.getAttribute(ATTR_CMIS_APP_KEY + appId);
    }

    public static void setApplicationKey(HttpServletRequest request, String key) {
        HttpSession hs = request.getSession();
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(key);
        hs.setAttribute(ATTR_CMIS_APP_KEY + appId, (Object)key);
    }

    public static boolean checkApplicationKey(HttpServletRequest request) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return false;
        }
        String key = SimpleTokenHandlerSessionHelper.getKey(request);
        if (key == null) {
            return false;
        }
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(key);
        if (appId == null) {
            return false;
        }
        return key.equals(hs.getAttribute(ATTR_CMIS_APP_KEY + appId));
    }

    public static void removeApplicationKey(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return;
        }
        hs.removeAttribute(ATTR_CMIS_APP_KEY + appId);
        hs.removeAttribute(ATTR_CMIS_APP_URL + appId);
        hs.removeAttribute(ATTR_CMIS_USER + appId);
        hs.removeAttribute(ATTR_CMIS_AUTH_TIMESTAMP + appId);
    }

    public static URL getApplicationURL(HttpServletRequest request, String appId) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return null;
        }
        return (URL)hs.getAttribute(ATTR_CMIS_APP_URL + appId);
    }

    public static boolean testAndInvalidateToken(HttpServletRequest request) {
        HttpSession hs = request.getSession(false);
        if (hs == null) {
            return false;
        }
        String token = SimpleTokenHandlerSessionHelper.getToken(request);
        if (token == null) {
            return false;
        }
        String tokenKey = ATTR_CMIS_TOKEN + token;
        Long tokenCreationTimestamp = (Long)hs.getAttribute(tokenKey);
        if (tokenCreationTimestamp != null) {
            hs.removeAttribute(tokenKey);
            return System.currentTimeMillis() - tokenCreationTimestamp < 28800000L;
        }
        return false;
    }

    public static void addToken(HttpServletRequest request, String token) {
        HttpSession hs = request.getSession();
        String tokenKey = ATTR_CMIS_TOKEN + token;
        hs.setAttribute(tokenKey, (Object)System.currentTimeMillis());
    }

    public static String getKey(HttpServletRequest request) {
        String key = request.getParameter(PARAM_KEY);
        return SimpleTokenHandlerSessionHelper.normalizeKey(key);
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getParameter(PARAM_TOKEN);
        return SimpleTokenHandlerSessionHelper.normalizeKey(token);
    }

    public static String normalizeKey(String key) {
        if (key == null) {
            return null;
        }
        if ((key = key.trim()).length() != 60 || !key.matches("^[0-9a-f]+$")) {
            return null;
        }
        return key;
    }

    public static String generateAppId() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[10];
        random.nextBytes(bytes);
        StringBuilder sb = new StringBuilder(20);
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String generateKey(String appId) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        StringBuilder sb = new StringBuilder(appId + 40);
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

