/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionManipulator;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.MergedData;
import com.github.sommeri.less4j.core.compiler.stages.TreeDeclarationsVisitor;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertiesMerger
extends TreeDeclarationsVisitor {
    private Map<String, MergedData> mergingProperties = new HashMap<String, MergedData>();
    private ASTManipulator manipulator = new ASTManipulator();
    private ExpressionManipulator expressionManipulator = new ExpressionManipulator();

    @Override
    protected void applyToDeclaration(Declaration declaration) {
        if (declaration.isMerging()) {
            this.addToPrevious(declaration);
        }
    }

    private void addToPrevious(Declaration declaration) {
        if (declaration.getExpression() == null) {
            return;
        }
        String key = this.toMergingPropertiesKey(declaration);
        if (this.mergingProperties.containsKey(key)) {
            MergedData mergedDeclaration = this.mergingProperties.get(key);
            this.addToMergeData(mergedDeclaration, declaration.getExpression(), declaration.getMergeOperator());
            this.manipulator.removeFromBody(declaration);
        } else {
            MergedData mergedData = this.createMergeData(declaration);
            this.mergingProperties.put(key, mergedData);
        }
    }

    private MergedData createMergeData(Declaration declaration) {
        Expression expression = declaration.getExpression();
        Expression important = null;
        if (this.expressionManipulator.isImportant(expression)) {
            important = this.expressionManipulator.cutRightmostListedExpression(expression);
        }
        MergedData mergedData = new MergedData(declaration, important);
        mergedData.add(expression);
        return mergedData;
    }

    private void addToMergeData(MergedData mergeData, Expression expression, ListExpressionOperator.Operator merge) {
        if (mergeData.isImportant()) {
            this.expressionManipulator.cutRightmostListedExpression(expression);
        }
        if (mergeData.getOperator() != merge) {
            Expression mergeExpressions = mergeData.mergeExpressions();
            mergeData.setOperator(merge);
            mergeData.replaceExpressions(mergeExpressions);
        }
        mergeData.add(expression);
    }

    private String toMergingPropertiesKey(Declaration declaration) {
        String cssPropertyName = declaration.getNameAsString();
        boolean important = this.expressionManipulator.isImportant(declaration.getExpression());
        return cssPropertyName + " " + important;
    }

    @Override
    protected void enteringBody(Body node) {
        this.mergingProperties = new HashMap<String, MergedData>();
    }

    @Override
    protected void leavingBody(Body node) {
        for (MergedData data : this.mergingProperties.values()) {
            Declaration declaration = data.getDeclaration();
            HiddenTokenAwareTree underlying = declaration.getUnderlyingStructure();
            Expression mergedExpressions = data.mergeExpressions();
            if (data.isImportant()) {
                ListExpression list = this.bundleInSpaceSeparatedList(underlying, mergedExpressions);
                list.addExpression(data.getImportance());
                list.configureParentToAllChilds();
                mergedExpressions = list;
            }
            declaration.setExpression(mergedExpressions);
            mergedExpressions.setParent(declaration);
        }
    }

    private ListExpression bundleInSpaceSeparatedList(HiddenTokenAwareTree underlying, Expression mergedExpressions) {
        if (this.expressionManipulator.isSpaceSeparatedList(mergedExpressions)) {
            return (ListExpression)mergedExpressions;
        }
        List<Expression> iExpressions = ArraysUtils.asList(mergedExpressions);
        ListExpressionOperator space = new ListExpressionOperator(underlying, ListExpressionOperator.Operator.EMPTY_OPERATOR);
        return new ListExpression(underlying, iExpressions, space);
    }
}

