/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;

public class MultiFilingService {

    public static class RemoveObjectFromFolder
    extends AbstractAtomPubServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String removeFrom = this.getStringParameter(request, "removeFrom");
            TempStoreOutputStreamFactory streamFactory = (TempStoreOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.setIgnoreAtomContentSrc(true);
            parser.parse((InputStream)request.getInputStream());
            String objectId = parser.getId();
            try {
                if (this.stopBeforeService(service)) {
                    return;
                }
                if (objectId == null && removeFrom == null) {
                    this.createUnfiledObject(context, service, repositoryId, request, response, parser);
                    return;
                }
                service.removeObjectFromFolder(repositoryId, objectId, removeFrom, null);
                if (this.stopAfterService(service)) {
                    return;
                }
            }
            finally {
                parser.release();
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            if (object.getId() == null) {
                throw new CmisRuntimeException("Object Id is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Location", this.compileUrl(baseUrl, "entry", object.getId()));
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }

        private void createUnfiledObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response, AtomEntryParser parser) throws Exception {
            VersioningState versioningState = this.getEnumParameter(request, "versioningState", VersioningState.class);
            ContentStream contentStream = parser.getContentStream();
            String newObjectId = service.create(repositoryId, parser.getProperties(), null, contentStream, versioningState, parser.getPolicyIds(), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Location", this.compileUrl(baseUrl, "entry", newObjectId));
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }
}

