/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.RemoveClassPathRootAction;
import org.netbeans.modules.java.api.common.project.ui.ShowJavadocAction;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class ProjectNode
extends AbstractNode {
    private static final String PROJECT_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/projectDependencies.gif";
    private final AntArtifact antArtifact;
    private final URI artifactLocation;
    private Image cachedIcon;

    ProjectNode(@NonNull AntArtifact antArtifact, @NonNull URI artifactLocation, @NonNull UpdateHelper helper, @NonNull String classPathId, @NonNull String entryId, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NonNull ReferenceHelper rh, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean removeFromProject) {
        super(Children.LEAF, ProjectNode.createLookup(antArtifact, artifactLocation, helper, classPathId, entryId, webModuleElementName, cs, rh, preRemoveAction, postRemoveAction, removeFromProject));
        this.antArtifact = antArtifact;
        this.artifactLocation = artifactLocation;
    }

    @Override
    public String getDisplayName() {
        ProjectInformation info = this.getProjectInformation();
        if (info != null) {
            return NbBundle.getMessage(ProjectNode.class, "TXT_ProjectArtifactFormat", new Object[]{info.getDisplayName(), this.artifactLocation.toString()});
        }
        return NbBundle.getMessage(ProjectNode.class, "TXT_UnknownProjectName");
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public Image getIcon(int type) {
        if (this.cachedIcon == null) {
            ProjectInformation info = this.getProjectInformation();
            if (info != null) {
                Icon icon = info.getIcon();
                this.cachedIcon = ImageUtilities.icon2Image(icon);
            } else {
                this.cachedIcon = ImageUtilities.loadImage(PROJECT_ICON);
            }
        }
        return this.cachedIcon;
    }

    @Override
    public String getShortDescription() {
        FileObject fo;
        Project p = this.antArtifact.getProject();
        if (p != null && (fo = p.getProjectDirectory()) != null) {
            return FileUtil.getFileDisplayName(fo);
        }
        return super.getShortDescription();
    }

    @Override
    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    @Override
    public boolean canCopy() {
        return false;
    }

    @Override
    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenProjectAction.class), SystemAction.get(ShowJavadocAction.class), SystemAction.get(RemoveClassPathRootAction.class)};
    }

    @Override
    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    private ProjectInformation getProjectInformation() {
        Project p = this.antArtifact.getProject();
        if (p != null) {
            return ProjectUtils.getInformation(p);
        }
        return null;
    }

    private static Lookup createLookup(@NonNull AntArtifact antArtifact, @NonNull URI artifactLocation, @NonNull UpdateHelper helper, @NonNull String classPathId, @NonNull String entryId, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NonNull ReferenceHelper rh, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean removeFromProject) {
        Object[] content;
        Project p = antArtifact.getProject();
        if (p == null) {
            content = new Object[1];
        } else {
            content = new Object[4];
            content[1] = new JavadocProvider(antArtifact, artifactLocation);
            content[2] = p;
            content[3] = new PathFinderImpl();
        }
        content[0] = new ActionFilterNode.Removable(helper, classPathId, entryId, webModuleElementName, cs, rh, preRemoveAction, postRemoveAction, removeFromProject);
        Lookup lkp = Lookups.fixed(content);
        return lkp;
    }

    private static final class PathFinderImpl
    implements PathFinder {
        private PathFinderImpl() {
        }

        @Override
        public Node findPath(Node root, Object target) {
            Project p = root.getLookup().lookup(Project.class);
            if (p != null && p.getProjectDirectory().equals(target)) {
                return root;
            }
            return null;
        }
    }

    private static class OpenProjectAction
    extends NodeAction {
        private OpenProjectAction() {
        }

        @Override
        protected void performAction(Node[] activatedNodes) {
            Project[] projects = new Project[activatedNodes.length];
            for (int i = 0; i < projects.length; ++i) {
                Project p = OpenProjectAction.getProject(activatedNodes[i]);
                if (p == null) {
                    return;
                }
                projects[i] = p;
            }
            OpenProjects.getDefault().open(projects, false);
        }

        @Override
        protected boolean enable(Node[] activatedNodes) {
            List<Project> openedProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project p = OpenProjectAction.getProject(activatedNodes[i]);
                if (p == null) {
                    return false;
                }
                if (!openedProjects.contains(p)) continue;
                return false;
            }
            return true;
        }

        private static Project getProject(Node node) {
            FileObject projectRoot;
            assert (node != null);
            Project p = node.getLookup().lookup(Project.class);
            if (!(p == null || (projectRoot = p.getProjectDirectory()) != null && projectRoot.isValid())) {
                return null;
            }
            return p;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(ProjectNode.class, "CTL_OpenProject");
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx(OpenProjectAction.class);
        }

        @Override
        protected boolean asynchronous() {
            return false;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final AntArtifact antArtifact;
        private final URI artifactLocation;

        JavadocProvider(AntArtifact antArtifact, URI artifactLocation) {
            this.antArtifact = antArtifact;
            this.artifactLocation = artifactLocation;
        }

        @Override
        public boolean hasJavadoc() {
            return this.findJavadoc().size() > 0;
        }

        @Override
        public void showJavadoc() {
            Set<URL> us = this.findJavadoc();
            URL[] urls = us.toArray(new URL[us.size()]);
            URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
            if (pageURL == null) {
                pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
            }
            ProjectInformation info = null;
            Project p = this.antArtifact.getProject();
            if (p != null) {
                info = ProjectUtils.getInformation(p);
            }
            ShowJavadocAction.showJavaDoc(pageURL, info == null ? NbBundle.getMessage(ProjectNode.class, "TXT_UnknownProjectName") : info.getDisplayName());
        }

        private Set<URL> findJavadoc() {
            File scriptLocation = this.antArtifact.getScriptLocation();
            HashSet<URL> urls = new HashSet<URL>();
            try {
                URL artifactURL = BaseUtilities.normalizeURI(Utilities.toURI(scriptLocation).resolve(this.artifactLocation)).toURL();
                if (FileUtil.isArchiveFile(artifactURL)) {
                    artifactURL = FileUtil.getArchiveRoot(artifactURL);
                }
                urls.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc(artifactURL).getRoots()));
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace(mue);
            }
            return urls;
        }
    }
}

