/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.EnhancedForLoopTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.ForLoopTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Types;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class ExpandEnhancedForLoop {
    public static ErrorDescription run(HintContext ctx) {
        TreePath tp = ctx.getPath();
        EnhancedForLoopTree efl = (EnhancedForLoopTree)tp.getLeaf();
        long statementStart = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), efl.getStatement());
        int caret = ctx.getCaretLocation();
        if ((long)caret >= statementStart) {
            return null;
        }
        TypeMirror expressionType = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, efl.getExpression()));
        if (expressionType == null || expressionType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        ExecutableElement iterator = ExpandEnhancedForLoop.findIterable(ctx.getInfo());
        Types t = ctx.getInfo().getTypes();
        if (iterator == null || !t.isSubtype((DeclaredType)expressionType, t.erasure(iterator.getEnclosingElement().asType()))) {
            return null;
        }
        FixImpl fix = new FixImpl(TreePathHandle.create(tp, ctx.getInfo()));
        List<Fix> fixes = Collections.singletonList(fix.toEditorFix());
        return ErrorDescriptionFactory.createErrorDescription(ctx.getSeverity(), NbBundle.getMessage(ExpandEnhancedForLoop.class, "ERR_ExpandEhancedForLoop"), fixes, ctx.getInfo().getFileObject(), caret, caret);
    }

    public static ExecutableElement findIterable(CompilationInfo info) {
        TypeElement iterable = info.getElements().getTypeElement("java.lang.Iterable");
        if (iterable == null) {
            return null;
        }
        for (ExecutableElement ee : ElementFilter.methodsIn(iterable.getEnclosedElements())) {
            if (!ee.getParameters().isEmpty() || !ee.getSimpleName().contentEquals("iterator")) continue;
            return ee;
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(TreePathHandle forLoop) {
            super(forLoop);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(ExpandEnhancedForLoop.class, "ERR_ExpandEhancedForLoop");
        }

        @Override
        protected void performRewrite(@NonNull JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            if (path == null) {
                return;
            }
            EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
            TypeMirror expressionType = copy.getTrees().getTypeMirror(new TreePath(path, efl.getExpression()));
            if (expressionType == null || expressionType.getKind() != TypeKind.DECLARED) {
                return;
            }
            ExecutableElement getIterator = ExpandEnhancedForLoop.findIterable(copy);
            ExecutableType getIteratorType = (ExecutableType)copy.getTypes().asMemberOf((DeclaredType)expressionType, getIterator);
            TypeMirror iteratorType = Utilities.resolveTypeForDeclaration(copy, getIteratorType.getReturnType());
            TreeMaker make = copy.getTreeMaker();
            Tree iteratorTypeTree = make.Type(iteratorType);
            MethodInvocationTree getIteratorTree = make.MethodInvocation(Collections.emptyList(), make.MemberSelect(efl.getExpression(), "iterator"), Collections.emptyList());
            MethodInvocationTree getNextTree = make.MethodInvocation(Collections.emptyList(), make.MemberSelect((ExpressionTree)make.Identifier("it"), "next"), Collections.emptyList());
            MethodInvocationTree hasNextTree = make.MethodInvocation(Collections.emptyList(), make.MemberSelect((ExpressionTree)make.Identifier("it"), "hasNext"), Collections.emptyList());
            VariableTree orig = efl.getVariable();
            VariableTree init = make.Variable(orig.getModifiers(), "it", iteratorTypeTree, getIteratorTree);
            VariableTree value = make.Variable(orig.getModifiers(), orig.getName(), orig.getType(), getNextTree);
            LinkedList<? extends StatementTree> statements = new LinkedList<StatementTree>();
            statements.add(0, value);
            if (efl.getStatement() != null) {
                switch (efl.getStatement().getKind()) {
                    case BLOCK: {
                        BlockTree oldBlock = (BlockTree)efl.getStatement();
                        statements.addAll(oldBlock.getStatements());
                        break;
                    }
                    case EMPTY_STATEMENT: {
                        break;
                    }
                    default: {
                        statements.add(efl.getStatement());
                    }
                }
            }
            BlockTree newBlock = make.Block(statements, false);
            ForLoopTree forLoop = make.ForLoop(Collections.singletonList(init), hasNextTree, Collections.emptyList(), newBlock);
            copy.rewrite(efl, forLoop);
        }
    }
}

