/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.openide.util.Exceptions;

public abstract class LibraryAccessor {
    private static volatile LibraryAccessor instance;

    public static synchronized LibraryAccessor getInstance() {
        if (instance == null) {
            try {
                Class<?> clazz = Class.forName("org.netbeans.api.project.libraries.Library", true, LibraryAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException cnf) {
                Exceptions.printStackTrace(cnf);
            }
        }
        assert (instance != null);
        return instance;
    }

    public static void setInstance(LibraryAccessor _instance) {
        assert (_instance != null);
        instance = _instance;
    }

    public abstract Library createLibrary(LibraryImplementation var1);

    @NonNull
    public abstract LibraryStorageArea getArea(@NonNull LibraryManager var1);

    @NonNull
    public abstract LibraryImplementation getLibraryImplementation(@NonNull Library var1);

    public static void remove(ArealLibraryProvider alp, LibraryImplementation2 lib) throws IOException {
        LibraryAccessor.remove0(alp, lib);
    }

    private static <L extends LibraryImplementation2> void remove0(ArealLibraryProvider<?, L> alp, LibraryImplementation2 lib) throws IOException {
        alp.remove((LibraryImplementation2)alp.libraryType().cast(lib));
    }

    public static Set<? extends LibraryStorageArea> getOpenAreas(ArealLibraryProvider alp) {
        return alp.getOpenAreas();
    }

    public static LibraryImplementation2 createLibrary(ArealLibraryProvider alp, String type, String name, LibraryStorageArea area, Map<String, List<URI>> contents) throws IOException {
        return LibraryAccessor.createLibrary0(alp, type, name, area, contents);
    }

    private static <A extends LibraryStorageArea> LibraryImplementation2 createLibrary0(ArealLibraryProvider<A, ?> alp, String type, String name, LibraryStorageArea area, Map<String, List<URI>> contents) throws IOException {
        return alp.createLibrary(type, name, (LibraryStorageArea)alp.areaType().cast(area), contents);
    }

    public static LibraryProvider getLibraries(ArealLibraryProvider alp, LibraryStorageArea area) {
        return LibraryAccessor.getLibraries0(alp, area);
    }

    private static <A extends LibraryStorageArea> LibraryProvider getLibraries0(ArealLibraryProvider<A, ?> alp, LibraryStorageArea area) {
        return alp.getLibraries((LibraryStorageArea)alp.areaType().cast(area));
    }
}

