/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openide.util.Parameters;
import org.openide.util.VectorIcon;

class IconWithArrow
implements Icon {
    private Icon orig;
    private Icon arrow;
    private boolean paintRollOver;
    private static final int GAP = 6;

    public IconWithArrow(Icon orig, boolean paintRollOver, boolean disabledArrow) {
        Parameters.notNull("original icon", orig);
        this.orig = orig;
        this.paintRollOver = paintRollOver;
        this.arrow = disabledArrow ? ArrowIcon.INSTANCE_DISABLED : ArrowIcon.INSTANCE_DEFAULT;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int height = this.getIconHeight();
        this.orig.paintIcon(c, g, x, y + (height - this.orig.getIconHeight()) / 2);
        this.arrow.paintIcon(c, g, x + 6 + this.orig.getIconWidth(), y + (height - this.arrow.getIconHeight()) / 2);
        if (this.paintRollOver) {
            Color brighter = UIManager.getColor("controlHighlight");
            Color darker = UIManager.getColor("controlShadow");
            if (null == brighter || null == darker) {
                brighter = c.getBackground().brighter();
                darker = c.getBackground().darker();
            }
            if (null != brighter && null != darker) {
                g.setColor(brighter);
                g.drawLine(x + this.orig.getIconWidth() + 1, y, x + this.orig.getIconWidth() + 1, y + this.getIconHeight());
                g.setColor(darker);
                g.drawLine(x + this.orig.getIconWidth() + 2, y, x + this.orig.getIconWidth() + 2, y + this.getIconHeight());
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.orig.getIconWidth() + 6 + this.arrow.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.orig.getIconHeight(), this.arrow.getIconHeight());
    }

    public static int getArrowAreaWidth() {
        return 8;
    }

    static class ArrowIcon
    extends VectorIcon {
        public static final Icon INSTANCE_DEFAULT = new ArrowIcon(false);
        public static final Icon INSTANCE_DISABLED = new ArrowIcon(true);
        private final boolean disabled;

        private ArrowIcon(boolean disabled) {
            super(5, 4);
            this.disabled = disabled;
        }

        @Override
        protected void paintIcon(Component c, Graphics2D g, int width, int height, double scaling) {
            Color color = UIManager.getBoolean("nb.dark.theme") ? (this.disabled ? new Color(90, 90, 90, 255) : new Color(187, 187, 187, 255)) : (this.disabled ? new Color(201, 201, 201, 255) : new Color(86, 86, 86, 255));
            g.setColor(color);
            double overshoot = 2.0 / scaling;
            double arrowWidth = (double)width + overshoot * scaling;
            double arrowHeight = (double)height - 0.2 * scaling;
            double arrowMidX = arrowWidth / 2.0 - overshoot / 2.0 * scaling;
            g.clipRect(0, 0, width, height);
            Path2D.Double arrowPath = new Path2D.Double();
            arrowPath.moveTo(arrowMidX - arrowWidth / 2.0, 0.0);
            arrowPath.lineTo(arrowMidX, arrowHeight);
            arrowPath.lineTo(arrowMidX + arrowWidth / 2.0, 0.0);
            arrowPath.closePath();
            g.fill(arrowPath);
        }
    }
}

