/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.ldaps;

import jakarta.inject.Inject;
import org.apache.openmeetings.db.dao.server.LdapConfigDao;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.DateLabel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class LdapForm
extends AdminBaseForm<LdapConfig> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer listContainer;
    @Inject
    private LdapConfigDao ldapDao;

    public LdapForm(String id, WebMarkupContainer listContainer, LdapConfig ldapConfig) {
        super(id, new CompoundPropertyModel((Object)ldapConfig));
        this.setOutputMarkupId(true);
        this.listContainer = listContainer;
    }

    @Override
    protected void onInitialize() {
        this.add(new Component[]{new CheckBox("active")});
        this.add(new Component[]{new DateLabel("inserted")});
        this.add(new Component[]{new Label("insertedby.login")});
        this.add(new Component[]{new DateLabel("updated")});
        this.add(new Component[]{new Label("updatedby.login")});
        this.add(new Component[]{new CheckBox("addDomainToUserName")});
        this.add(new Component[]{new TextField("domain")});
        this.add(new Component[]{new TextArea("comment")});
        this.add(new Component[]{new RequiredTextField("name").setLabel((IModel)new ResourceModel("165"))});
        this.add(new Component[]{new RequiredTextField("configFileName").setLabel((IModel)new ResourceModel("1115"))});
        super.onInitialize();
        this.setNewRecordVisible(true);
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(this.ldapDao.update((LdapConfig)this.getModelObject(), WebSession.getUserId()));
        this.setNewRecordVisible(false);
        target.add(new Component[]{this, this.listContainer});
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(new LdapConfig());
        target.add(new Component[]{this});
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        LdapConfig ldapConfig = (LdapConfig)this.getModelObject();
        ldapConfig = ldapConfig.getId() != null ? this.ldapDao.get(ldapConfig.getId()) : new LdapConfig();
        this.setModelObject(ldapConfig);
        target.add(new Component[]{this});
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        this.ldapDao.delete((LdapConfig)this.getModelObject(), WebSession.getUserId());
        this.setModelObject(new LdapConfig());
        target.add(new Component[]{this.listContainer});
        target.add(new Component[]{this});
    }
}

