/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.TimeRange;
import com.github.caldav4j.xml.OutputsDOM;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.webdav.xml.Namespace;

public class FreeBusyQuery
extends OutputsDOMBase
implements CalDAVReportRequest {
    public static final String ELEMENT_NAME = "free-busy-query";
    private TimeRange timeRange;

    public FreeBusyQuery() {
    }

    public FreeBusyQuery(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<? extends OutputsDOM> getChildren() {
        return Collections.singleton(this.timeRange);
    }

    @Override
    protected Map<String, String> getAttributes() {
        return null;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.timeRange == null) {
            throw new DOMValidationException("Time range cannot be null");
        }
        this.timeRange.validate();
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }
}

