/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonContext;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OsonArrayImpl
extends OsonAbstractArray
implements OracleJsonArray {
    public OsonArrayImpl(OsonContext osonContext, int n2) {
        super(osonContext, n2);
    }

    @Override
    public Iterator<OracleJsonValue> iterator() {
        return new OsonAbstractArray.ValueIter<OracleJsonValue>();
    }

    @Override
    public OracleJsonValue get(int n2) {
        return (OracleJsonValue)this.getInternal(n2);
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public List<OracleJsonValue> subList(int n2, int n3) {
        return super.sublist(n2, n3);
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new OsonAbstractArray.ListIter<OracleJsonValue>(n2);
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        JsonpOsonContext jsonpOsonContext = new JsonpOsonContext(this.ctx);
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createArray(jsonpOsonContext, this.pos));
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializerImpl jsonSerializerImpl = new JsonSerializerImpl(stringWriter);
        jsonSerializerImpl.write(this);
        jsonSerializerImpl.close();
        return stringWriter.toString();
    }

    @Override
    public <T extends OracleJsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this;
    }

    @Override
    public double getDouble(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return ((OracleJsonNumberImpl)this.getValueInternal(n3)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return ((OracleJsonNumberImpl)this.getValueInternal(n3)).bigDecimalValue();
    }

    @Override
    public long getLong(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return ((OracleJsonNumberImpl)this.getValueInternal(n3)).longValue();
    }

    @Override
    public LocalDateTime getLocalDateTime(int n2) {
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(this.getOffsetWithError(n2));
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDate)oracleJsonValue).getLocalDateTime();
        }
        return ((OracleJsonTimestamp)oracleJsonValue).getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int n2) {
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(this.getOffsetWithError(n2));
        return ((OracleJsonTimestampTZ)oracleJsonValue).getOffsetDateTime();
    }

    @Override
    public byte[] getBytes(int n2) {
        int n3 = this.getOffsetWithError(n2);
        OracleJsonBinary oracleJsonBinary = (OracleJsonBinary)this.getValueInternal(n3);
        return oracleJsonBinary.getBytes();
    }

    @Override
    public boolean add(OracleJsonValue oracleJsonValue) {
        throw this.createNotModifiable();
    }

    @Override
    public boolean addAll(Collection<? extends OracleJsonValue> collection) {
        throw this.createNotModifiable();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends OracleJsonValue> collection) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, OracleJsonValue oracleJsonValue) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(int n2, OracleJsonValue oracleJsonValue) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue remove(int n2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, String string) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(String string) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, int n3) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(int n2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, double d2) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(double d2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, boolean bl) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(boolean bl) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue setNull(int n2) {
        throw this.createNotModifiable();
    }

    @Override
    public void addNull() {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, LocalDateTime localDateTime) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, OffsetDateTime offsetDateTime) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(LocalDateTime localDateTime) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(OffsetDateTime offsetDateTime) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, byte[] byArray) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(byte[] byArray) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, long l2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int n2, BigDecimal bigDecimal) throws OracleJsonException {
        throw this.createNotModifiable();
    }

    @Override
    public void add(long l2) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(BigDecimal bigDecimal) {
        throw this.createNotModifiable();
    }

    private UnsupportedOperationException createNotModifiable() {
        throw OracleJsonExceptions.ARR_NOT_MUTABLE.create(OracleJsonExceptions.ORACLE_FACTORY, new Object[0]);
    }
}

