/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;

abstract class PredicateImpl
extends ExpressionImpl<Boolean>
implements Predicate {
    static final jakarta.persistence.criteria.Expression<?> TRUE_CONSTANT = new Expressions.Constant<Boolean>(true);
    static final jakarta.persistence.criteria.Expression<?> FALSE_CONSTANT = new Expressions.Constant<Boolean>(false);
    private static Predicate TRUE;
    private static Predicate FALSE;
    protected final List<Predicate> _exps = Collections.synchronizedList(new ArrayList());
    private final Predicate.BooleanOperator _op;
    private boolean _negated = false;

    protected PredicateImpl() {
        this(Predicate.BooleanOperator.AND);
    }

    protected PredicateImpl(Predicate.BooleanOperator op) {
        super(Boolean.class);
        this._op = op;
    }

    protected PredicateImpl(Predicate.BooleanOperator op, Predicate ... restrictions) {
        this(op);
        if (restrictions == null || restrictions.length == 0) {
            return;
        }
        for (Predicate p : restrictions) {
            this.add((jakarta.persistence.criteria.Expression<Boolean>)p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredicateImpl add(jakarta.persistence.criteria.Expression<Boolean> s) {
        List<Predicate> list = this._exps;
        synchronized (list) {
            this._exps.add((Predicate)s);
        }
        return this;
    }

    public List<jakarta.persistence.criteria.Expression<Boolean>> getExpressions() {
        CopyOnWriteArrayList<jakarta.persistence.criteria.Expression<Boolean>> result = new CopyOnWriteArrayList<jakarta.persistence.criteria.Expression<Boolean>>();
        if (this._exps.isEmpty()) {
            return result;
        }
        result.addAll(this._exps);
        return result;
    }

    public final Predicate.BooleanOperator getOperator() {
        return this._op;
    }

    public final boolean isEmpty() {
        return this._exps.isEmpty();
    }

    public final boolean isNegated() {
        return this._negated;
    }

    public PredicateImpl not() {
        return new Expressions.Not(this).markNegated();
    }

    protected PredicateImpl markNegated() {
        this._negated = true;
        return this;
    }

    public static Predicate TRUE() {
        if (TRUE == null) {
            Expressions.Constant<Integer> ONE = new Expressions.Constant<Integer>(1);
            TRUE = new Expressions.Equal(ONE, ONE);
        }
        return TRUE;
    }

    public static Predicate FALSE() {
        if (FALSE == null) {
            Expressions.Constant<Integer> ONE = new Expressions.Constant<Integer>(1);
            FALSE = new Expressions.NotEqual(ONE, ONE);
        }
        return FALSE;
    }

    @Override
    Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        if (this._exps.isEmpty()) {
            return factory.newLiteral(this._op == Predicate.BooleanOperator.AND, 2);
        }
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        if (this._exps.isEmpty()) {
            Predicate nil = this._op == Predicate.BooleanOperator.AND ? PredicateImpl.TRUE() : PredicateImpl.FALSE();
            return ((PredicateImpl)nil).toKernelExpression(factory, q);
        }
        if (this._exps.size() == 1) {
            Predicate e0 = this._exps.get(0);
            if (this.isNegated()) {
                e0 = e0.not();
            }
            return ((PredicateImpl)e0).toKernelExpression(factory, q);
        }
        ExpressionImpl e1 = (ExpressionImpl)this._exps.get(0);
        ExpressionImpl e2 = (ExpressionImpl)this._exps.get(1);
        Expression ke1 = e1.toKernelExpression(factory, q);
        Expression ke2 = e2.toKernelExpression(factory, q);
        Expression result = this._op == Predicate.BooleanOperator.AND ? factory.and(ke1, ke2) : factory.or(ke1, ke2);
        for (int i = 2; i < this._exps.size(); ++i) {
            PredicateImpl p = (PredicateImpl)this._exps.get(i);
            result = this._op == Predicate.BooleanOperator.AND ? factory.and(result, p.toKernelExpression(factory, q)) : factory.or(result, p.toKernelExpression(factory, q));
        }
        return this._negated ? factory.not(result) : result;
    }

    @Override
    public void acceptVisit(CriteriaExpressionVisitor visitor) {
        Expressions.acceptVisit(visitor, this, this._exps.toArray(new jakarta.persistence.criteria.Expression[this._exps.size()]));
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        boolean braces = this._exps.size() > 1;
        StringBuilder buffer = Expressions.asValue(q, this._exps.toArray(new jakarta.persistence.criteria.Expression[this._exps.size()]), " " + String.valueOf(this._op) + " ");
        if (braces) {
            buffer.insert(0, "(").append(")");
        }
        if (this.isNegated()) {
            buffer.insert(0, "NOT ");
        }
        return buffer;
    }

    static class Or
    extends PredicateImpl {
        public Or(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
            super(Predicate.BooleanOperator.OR);
            this.add(x).add(y);
        }

        public Or(Predicate ... restrictions) {
            super(Predicate.BooleanOperator.OR, restrictions);
        }
    }

    static class And
    extends PredicateImpl {
        public And(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
            super(Predicate.BooleanOperator.AND);
            this.add(x).add(y);
        }

        public And(Predicate ... restrictions) {
            super(Predicate.BooleanOperator.AND, restrictions);
        }
    }
}

