/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.util.iso.Types;

final class TableHierarchy {
    static final char TYPE_OPEN = '{';
    static final char TYPE_CLOSE = '}';
    private static final Map<String, String> ABBREVIATIONS = new HashMap<String, String>(25);
    private static final Map<String, String> TABLES = new HashMap<String, String>(25);

    private static void add(String table, String abbreviation) {
        ABBREVIATIONS.put(table, abbreviation);
        TABLES.put(abbreviation, table);
    }

    private TableHierarchy() {
    }

    static String encode(String table, String identifier) {
        table = ABBREVIATIONS.getOrDefault(table, table);
        return "{" + table + "}" + identifier;
    }

    static Class<?> subType(Class<?> type, String identifier) {
        int i;
        if (identifier.charAt(0) == '{' && (i = identifier.indexOf(125)) >= 0) {
            String table = identifier.substring(1, i);
            Class<?> subType = Types.forStandardName(table = TABLES.getOrDefault(table, table));
            if (subType != null && type.isAssignableFrom(subType)) {
                type = subType;
            }
        }
        return type;
    }

    static {
        TableHierarchy.add("Individual", "ind");
        TableHierarchy.add("Organisation", "org");
        TableHierarchy.add("ResponsibleParty", "rp");
        TableHierarchy.add("VectorSpatialRepresentation", "vec");
        TableHierarchy.add("GridSpatialRepresentation", "grd");
        TableHierarchy.add("Georectified", "rtf");
        TableHierarchy.add("Georeferenceable", "cbl");
        TableHierarchy.add("DataIdentification", "data");
        TableHierarchy.add("ServiceIdentification", "srv");
        TableHierarchy.add("FeatureCatalogueDescription", "cat");
        TableHierarchy.add("CoverageDescription", "cov");
        TableHierarchy.add("ImageDescription", "img");
        TableHierarchy.add("SampleDimension", "sd");
        TableHierarchy.add("Band", "band");
        TableHierarchy.add("LegalConstraints", "legal");
        TableHierarchy.add("SecurityConstraints", "secu");
        TableHierarchy.add("GeographicBoundingBox", "bbox");
        TableHierarchy.add("BoundingPolygon", "poly");
        TableHierarchy.add("GeographicDescription", "gdsc");
        TableHierarchy.add("SpatialTemporalExtent", "ste");
        TableHierarchy.add("GCPCollection", "gcp");
    }
}

