/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.ObjectStreamException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.GlobalNameSpace;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.gco.CharSequenceAdapter;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@XmlSeeAlso(value={DefaultTypeName.class, DefaultMemberName.class})
public class DefaultLocalName
extends AbstractName
implements LocalName {
    private static final long serialVersionUID = -697839568997068872L;
    final NameSpace scope;
    @XmlJavaTypeAdapter(value=CharSequenceAdapter.class)
    @XmlElement(name="aName", namespace="http://standards.iso.org/iso/19115/-3/gco/1.0")
    final CharSequence name;

    protected DefaultLocalName(NameSpace scope, CharSequence name) {
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        if (scope == GlobalNameSpace.GLOBAL) {
            scope = null;
        }
        this.scope = scope;
        if (name instanceof InternationalString) {
            if (name.getClass() == SimpleInternationalString.class) {
                this.asString = name;
            } else {
                this.name = name;
                return;
            }
        }
        this.name = name.toString();
    }

    public static DefaultLocalName castOrCopy(LocalName object) {
        if (object instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)object);
        }
        if (object instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)object);
        }
        if (object == null || object instanceof DefaultLocalName) {
            return (DefaultLocalName)object;
        }
        NameSpace scope = object.scope();
        InternationalString name = object.toInternationalString();
        if (scope instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)scope).local((CharSequence)name, null);
        }
        return new DefaultLocalName(scope, (CharSequence)name);
    }

    @Override
    public NameSpace scope() {
        return this.scope != null ? this.scope : GlobalNameSpace.GLOBAL;
    }

    @Override
    public final int depth() {
        return 1;
    }

    public final List<DefaultLocalName> getParsedNames() {
        return List.of(this);
    }

    @Override
    public final LocalName head() {
        return this;
    }

    @Override
    public final LocalName tip() {
        return this;
    }

    @Override
    public synchronized String toString() {
        if (this.asString == null) {
            this.asString = this.name instanceof InternationalString ? ((InternationalString)this.name).toString(Locale.ROOT) : this.name.toString();
        } else if (this.asString instanceof InternationalString) {
            return ((InternationalString)this.asString).toString(Locale.ROOT);
        }
        return this.asString.toString();
    }

    @Override
    public synchronized InternationalString toInternationalString() {
        if (!(this.asString instanceof InternationalString)) {
            this.asString = Types.toInternationalString(this.name);
        }
        return (InternationalString)this.asString;
    }

    @Override
    public int compareTo(GenericName name) {
        if (name instanceof LocalName) {
            return this.toString().compareTo(name.toString());
        }
        return super.compareTo(name);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultLocalName that = (DefaultLocalName)object;
            return Objects.equals(this.scope, that.scope) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    @Override
    int computeHashCode() {
        return Objects.hash(this.scope, this.name) ^ 0xFBB7CFB8;
    }

    private Object readResolve() throws ObjectStreamException {
        DefaultNameSpace ns;
        if (this.scope == null) {
            ns = GlobalNameSpace.GLOBAL;
        } else if (this.scope instanceof DefaultNameSpace) {
            ns = (DefaultNameSpace)this.scope;
        } else {
            return this;
        }
        return ns.local(this.name, this);
    }

    DefaultLocalName() {
        this.scope = null;
        this.name = null;
    }
}

