/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCopy
extends AbstractOperation {
    private static Logger log = LoggerFactory.getLogger(AbstractCopy.class);
    final NodeState destParentState;
    private final NodeState srcState;
    private final Name destName;
    private final String srcWorkspaceName;

    AbstractCopy(Path srcPath, Path destPath, String srcWorkspaceName, ManagerProvider srcMgrProvider, ManagerProvider destMgrProvider) throws RepositoryException {
        NodeState srcItemState;
        this.srcState = srcItemState = AbstractCopy.getNodeState(srcPath, srcMgrProvider.getHierarchyManager());
        this.destParentState = AbstractCopy.getNodeState(destPath.getAncestor(1), destMgrProvider.getHierarchyManager());
        int index = destPath.getIndex();
        if (index != 0) {
            String msg = "invalid destination path (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.destName = destPath.getName();
        this.srcWorkspaceName = srcWorkspaceName;
    }

    @Override
    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        this.destParentState.getHierarchyEntry().invalidate(false);
    }

    public String getWorkspaceName() {
        return this.srcWorkspaceName;
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.srcState.getNodeId();
    }

    public NodeId getDestinationParentId() throws RepositoryException {
        return this.destParentState.getNodeId();
    }

    public Name getDestinationName() {
        return this.destName;
    }
}

