/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.auth.form;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.Test;

public class FormReasonTest {

    @Test public void testTimeout() {
        assertEquals(FormReason.TIMEOUT,
            FormReason.valueOf(FormReason.TIMEOUT.name()));
        assertEquals("Session timed out, please login again", 
                FormReason.TIMEOUT.toString());
    }

    @Test public void testInvalidCredentials() {
        assertEquals(FormReason.INVALID_CREDENTIALS,
            FormReason.valueOf(FormReason.INVALID_CREDENTIALS.name()));
        assertEquals("Username and Password do not match", 
                FormReason.INVALID_CREDENTIALS.toString());
    }

    @Test public void testInvalid() {
        try {
            FormReason.valueOf("INVALID");
            fail("unexpected result getting value of an invalid constant");
        } catch (IllegalArgumentException iae) {
            // expected
        }
    }
}
