/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.oauth.impl;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.auth.xing.api.XingUser;
import org.apache.sling.auth.xing.oauth.XingOauthUserManager;
import org.apache.sling.auth.xing.oauth.XingOauthUtil;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.scribe.model.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XingOauthAuthenticationPlugin
implements AuthenticationPlugin {
    final XingOauthUserManager xingOauthUserManager;
    private final Logger logger = LoggerFactory.getLogger(XingOauthAuthenticationPlugin.class);

    public XingOauthAuthenticationPlugin(XingOauthUserManager xingOauthUserManager) {
        this.xingOauthUserManager = xingOauthUserManager;
    }

    public boolean authenticate(Credentials credentials) throws RepositoryException {
        this.logger.debug("authenticate");
        Token accessToken = XingOauthUtil.getAccessToken(credentials);
        XingUser xingUser = XingOauthUtil.getXingUser(credentials);
        if (accessToken == null || xingUser == null) {
            return false;
        }
        User user = this.xingOauthUserManager.getUser(credentials);
        if (user == null) {
            this.logger.debug("no user found for given credentials");
            if (this.xingOauthUserManager.autoCreate()) {
                this.logger.debug("creating a new user from given user data");
                user = this.xingOauthUserManager.createUser(credentials);
            }
        } else if (this.xingOauthUserManager.autoUpdate()) {
            this.xingOauthUserManager.updateUser(credentials);
        }
        return user != null;
    }
}

