/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl.util;

import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class ConfigNameUtil {
    private ConfigNameUtil() {
    }

    public static boolean isValid(String configName) {
        return !StringUtils.isBlank((CharSequence)configName) && !StringUtils.startsWith((CharSequence)configName, (CharSequence)"/") && !StringUtils.contains((CharSequence)configName, (CharSequence)"../");
    }

    public static boolean isValid(Collection<String> configNames) {
        if (configNames == null) {
            return false;
        }
        for (String configName : configNames) {
            if (ConfigNameUtil.isValid(configName)) continue;
            return false;
        }
        return true;
    }

    public static void ensureValidConfigName(String configName) {
        if (!ConfigNameUtil.isValid(configName)) {
            throw new IllegalArgumentException("Invalid configuration name: " + configName);
        }
    }

    public static String[] getAllPartialConfigNameVariations(String configName) {
        Object[] configNameParts = StringUtils.splitPreserveAllTokens((String)configName, (String)"/");
        if (configNameParts.length < 2) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] partialConfigNameVariations = new String[configNameParts.length - 1];
        for (int i = 0; i < configNameParts.length - 1; ++i) {
            partialConfigNameVariations[i] = StringUtils.join((Object[])ArrayUtils.subarray((Object[])configNameParts, (int)0, (int)(i + 1)), (String)"/");
        }
        return partialConfigNameVariations;
    }
}

