/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.messaging.mail.internal;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.commons.messaging.mail.MessageBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleMessageBuilder
implements MessageBuilder {
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html; charset=utf-8";
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain; charset=utf-8";
    private static final String CHARSET_UTF8 = "utf-8";
    private static final String MULTIPART_SUBTYPE_MIXED = "mixed";
    private static final String MULTIPART_SUBTYPE_ALTERNATIVE = "alternative";
    private static final String MULTIPART_SUBTYPE_RELATED = "related";
    private final Session session;
    private final List<Header> headers = new LinkedList<Header>();
    private InternetAddress from;
    private final List<InternetAddress> toRecipients = new LinkedList<InternetAddress>();
    private final List<InternetAddress> ccRecipients = new LinkedList<InternetAddress>();
    private final List<InternetAddress> bccRecipients = new LinkedList<InternetAddress>();
    private final List<InternetAddress> replyTos = new LinkedList<InternetAddress>();
    private String subject;
    private String text;
    private String html;
    private final List<Attachment> attachments = new LinkedList<Attachment>();
    private final List<Inline> inlines = new LinkedList<Inline>();

    SimpleMessageBuilder(@NotNull Session session) {
        this.session = session;
    }

    @Override
    @NotNull
    public MessageBuilder header(@NotNull String name, @Nullable String value) {
        Header header = new Header(name, value);
        this.headers.add(header);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder headers(@NotNull Collection<Header> headers) {
        this.headers.addAll(headers);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder from(@NotNull InternetAddress from) {
        this.from = from;
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder from(@NotNull String address) throws AddressException {
        InternetAddress from = new InternetAddress(address);
        return this.from(from);
    }

    @Override
    @NotNull
    public MessageBuilder from(@NotNull String address, @NotNull String name) throws AddressException {
        InternetAddress from = new InternetAddress(address);
        try {
            from.setPersonal(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.from(from);
    }

    @Override
    @NotNull
    public MessageBuilder to(@NotNull InternetAddress to) {
        this.toRecipients.add(to);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder to(@NotNull String address) throws AddressException {
        InternetAddress to = new InternetAddress(address);
        return this.to(to);
    }

    @Override
    @NotNull
    public MessageBuilder to(@NotNull String address, @NotNull String name) throws AddressException {
        InternetAddress to = new InternetAddress(address);
        try {
            to.setPersonal(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.to(to);
    }

    @Override
    @NotNull
    public MessageBuilder to(@NotNull InternetAddress[] addresses) {
        this.toRecipients.addAll(Arrays.asList(addresses));
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder to(@NotNull String[] addresses) throws AddressException {
        for (String address : addresses) {
            this.to(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder to(@NotNull Collection<String> addresses) throws AddressException {
        for (String address : addresses) {
            this.to(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder cc(@NotNull InternetAddress cc) {
        this.ccRecipients.add(cc);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder cc(@NotNull String address) throws AddressException {
        InternetAddress cc = new InternetAddress(address);
        return this.cc(cc);
    }

    @Override
    @NotNull
    public MessageBuilder cc(@NotNull String address, @NotNull String name) throws AddressException {
        InternetAddress cc = new InternetAddress(address);
        try {
            cc.setPersonal(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.cc(cc);
    }

    @Override
    @NotNull
    public MessageBuilder cc(@NotNull InternetAddress[] addresses) {
        this.ccRecipients.addAll(Arrays.asList(addresses));
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder cc(@NotNull String[] addresses) throws AddressException {
        for (String address : addresses) {
            this.cc(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder cc(@NotNull Collection<String> addresses) throws AddressException {
        for (String address : addresses) {
            this.cc(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder bcc(@NotNull InternetAddress bcc) {
        this.bccRecipients.add(bcc);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder bcc(@NotNull String address) throws AddressException {
        InternetAddress bcc = new InternetAddress(address);
        return this.bcc(bcc);
    }

    @Override
    @NotNull
    public MessageBuilder bcc(@NotNull String address, String name) throws AddressException {
        InternetAddress bcc = new InternetAddress(address);
        try {
            bcc.setPersonal(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.bcc(bcc);
    }

    @Override
    @NotNull
    public MessageBuilder bcc(@NotNull InternetAddress[] addresses) {
        this.bccRecipients.addAll(Arrays.asList(addresses));
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder bcc(@NotNull String[] addresses) throws AddressException {
        for (String address : addresses) {
            this.bcc(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder bcc(@NotNull Collection<String> addresses) throws AddressException {
        for (String address : addresses) {
            this.bcc(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder replyTo(@NotNull InternetAddress replyTo) {
        this.replyTos.add(replyTo);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder replyTo(@NotNull String address) throws AddressException {
        InternetAddress replyTo = new InternetAddress(address);
        return this.replyTo(replyTo);
    }

    @Override
    @NotNull
    public MessageBuilder replyTo(@NotNull String address, @NotNull String name) throws AddressException {
        InternetAddress replyTo = new InternetAddress(address);
        try {
            replyTo.setPersonal(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.replyTo(replyTo);
    }

    @Override
    @NotNull
    public MessageBuilder replyTo(@NotNull InternetAddress[] addresses) {
        this.replyTos.addAll(Arrays.asList(addresses));
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder replyTo(@NotNull String[] addresses) throws AddressException {
        for (String address : addresses) {
            this.replyTo(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder replyTo(@NotNull Collection<String> addresses) throws AddressException {
        for (String address : addresses) {
            this.replyTo(address);
        }
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder subject(@NotNull String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder text(@NotNull String text) {
        this.text = text;
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder html(@NotNull String html) {
        this.html = html;
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder attachment(byte @NotNull [] content, @NotNull String type, @NotNull String filename) {
        return this.attachment(content, type, filename, null);
    }

    @Override
    @NotNull
    public MessageBuilder attachment(byte @NotNull [] content, @NotNull String type, @NotNull String filename, @Nullable Collection<Header> headers) {
        Attachment attachment = new Attachment(content, type, filename, headers);
        this.attachments.add(attachment);
        return this;
    }

    @Override
    @NotNull
    public MessageBuilder inline(byte @NotNull [] content, @NotNull String type, @NotNull String cid) {
        return this.inline(content, type, cid, null);
    }

    @Override
    @NotNull
    public MessageBuilder inline(byte @NotNull [] content, @NotNull String type, @NotNull String cid, @Nullable Collection<Header> headers) {
        Inline inline = new Inline(content, type, cid, headers);
        this.inlines.add(inline);
        return this;
    }

    private List<Header> headers() {
        return this.headers;
    }

    private InternetAddress from() {
        return this.from;
    }

    private List<InternetAddress> to() {
        return this.toRecipients;
    }

    private List<InternetAddress> cc() {
        return this.ccRecipients;
    }

    private List<InternetAddress> bcc() {
        return this.bccRecipients;
    }

    private List<InternetAddress> replyTo() {
        return this.replyTos;
    }

    private String subject() {
        return this.subject;
    }

    private String text() {
        return this.text;
    }

    private String html() {
        return this.html;
    }

    private List<Attachment> attachments() {
        return this.attachments;
    }

    private List<Inline> inlines() {
        return this.inlines;
    }

    private boolean hasText() {
        return this.text() != null;
    }

    private boolean hasHtml() {
        return this.html() != null;
    }

    private boolean hasAttachments() {
        return !this.attachments().isEmpty();
    }

    private boolean hasInlines() {
        return !this.inlines().isEmpty();
    }

    @Override
    @NotNull
    public MimeMessage build() throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        for (Header header : this.headers()) {
            message.setHeader(header.getName(), header.getValue());
        }
        message.setFrom((Address)this.from());
        message.setRecipients(Message.RecipientType.TO, this.to().toArray(new Address[0]));
        message.setRecipients(Message.RecipientType.CC, this.cc().toArray(new Address[0]));
        message.setRecipients(Message.RecipientType.BCC, this.bcc().toArray(new Address[0]));
        message.setReplyTo(this.replyTo().toArray(new Address[0]));
        message.setSubject(this.subject(), StandardCharsets.UTF_8.name());
        if (this.hasHtml() || this.hasAttachments() || this.hasInlines()) {
            MimeMultipart content = new MimeMultipart(MULTIPART_SUBTYPE_MIXED);
            if (this.hasText() && this.hasHtml()) {
                MimeMultipart alternative = new MimeMultipart(MULTIPART_SUBTYPE_ALTERNATIVE);
                SimpleMessageBuilder.handleHtmlAndInlines(alternative, this.html(), this.inlines());
                SimpleMessageBuilder.addText(alternative, this.text());
                MimeBodyPart part = new MimeBodyPart();
                part.setContent((Multipart)alternative);
                content.addBodyPart((BodyPart)part);
            } else if (this.hasHtml()) {
                SimpleMessageBuilder.handleHtmlAndInlines(content, this.html(), this.inlines());
            } else {
                SimpleMessageBuilder.addText(content, this.text());
            }
            SimpleMessageBuilder.addAttachments(content, this.attachments);
            message.setContent((Multipart)content);
        } else {
            message.setText(this.text(), CHARSET_UTF8);
        }
        return message;
    }

    private static void handleHtmlAndInlines(MimeMultipart parent, String html, List<Inline> inlines) throws MessagingException {
        if (!inlines.isEmpty()) {
            MimeMultipart related = new MimeMultipart(MULTIPART_SUBTYPE_RELATED);
            SimpleMessageBuilder.addHtml(related, html);
            SimpleMessageBuilder.addInlines(related, inlines);
            MimeBodyPart part = new MimeBodyPart();
            part.setContent((Multipart)related);
            parent.addBodyPart((BodyPart)part);
        } else {
            SimpleMessageBuilder.addHtml(parent, html);
        }
    }

    private static void addText(MimeMultipart parent, String text) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)text, CONTENT_TYPE_TEXT_PLAIN);
        parent.addBodyPart((BodyPart)part);
    }

    private static void addHtml(MimeMultipart parent, String html) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)html, CONTENT_TYPE_TEXT_HTML);
        parent.addBodyPart((BodyPart)part);
    }

    private static void addAttachments(MimeMultipart parent, List<Attachment> attachments) throws MessagingException {
        for (Attachment attachment : attachments) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(attachment.content);){
                MimeBodyPart part = new MimeBodyPart();
                part.setDisposition("attachment");
                part.setFileName(attachment.filename);
                SimpleMessageBuilder.setDataHandler(part, inputStream, attachment.type);
                if (attachment.headers != null) {
                    SimpleMessageBuilder.setHeaders(part, attachment.headers);
                }
                parent.addBodyPart((BodyPart)part);
            }
            catch (Exception e) {
                String message = String.format("Adding attachment failed: %s", attachment.filename);
                throw new MessagingException(message, e);
            }
        }
    }

    private static void addInlines(MimeMultipart parent, List<Inline> inlines) throws MessagingException {
        for (Inline inline : inlines) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(inline.content);){
                MimeBodyPart part = new MimeBodyPart();
                part.setDisposition("inline");
                part.setContentID(String.format("<%s>", inline.cid));
                SimpleMessageBuilder.setDataHandler(part, inputStream, inline.type);
                if (inline.headers != null) {
                    SimpleMessageBuilder.setHeaders(part, inline.headers);
                }
                parent.addBodyPart((BodyPart)part);
            }
            catch (Exception e) {
                String message = String.format("Adding inline object failed: %s", inline.cid);
                throw new MessagingException(message, e);
            }
        }
    }

    private static void setDataHandler(MimeBodyPart part, InputStream inputStream, String type) throws MessagingException, IOException {
        ByteArrayDataSource source = new ByteArrayDataSource(inputStream, type);
        DataHandler handler = new DataHandler((DataSource)source);
        part.setDataHandler(handler);
    }

    private static void setHeaders(MimeBodyPart part, Collection<Header> headers) throws MessagingException {
        for (Header header : headers) {
            part.setHeader(header.getName(), header.getValue());
        }
    }

    private static class Inline {
        final byte[] content;
        final String type;
        final String cid;
        final Collection<Header> headers;

        Inline(byte @NotNull [] content, @NotNull String type, @NotNull String cid, @Nullable Collection<Header> headers) {
            this.content = content;
            this.type = type;
            this.cid = cid;
            this.headers = headers;
        }
    }

    private static class Attachment {
        final byte[] content;
        final String type;
        final String filename;
        final Collection<Header> headers;

        Attachment(byte @NotNull [] content, @NotNull String type, @NotNull String filename, @Nullable Collection<Header> headers) {
            this.content = content;
            this.type = type;
            this.filename = filename;
            this.headers = headers;
        }
    }
}

